/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.ICapabilityUninstallWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.RemoveCapabilityWizard;
import org.eclipse.ui.internal.ide.dialogs.WizardStep;
import org.eclipse.ui.internal.ide.registry.Capability;
import org.eclipse.ui.internal.ide.registry.CapabilityRegistry;

public class RemoveCapabilityStep
extends WizardStep {
    private Capability capability;
    private String[] natureIds;
    private IProject project;
    private ICapabilityUninstallWizard wizard;

    public RemoveCapabilityStep(int number, Capability capability, String[] natureIds, IProject project) {
        super(number);
        this.capability = capability;
        this.natureIds = natureIds;
        this.project = project;
    }

    public String getLabel() {
        return NLS.bind((String)IDEWorkbenchMessages.RemoveCapabilityStep_label, (Object)this.capability.getName());
    }

    public String getDetails() {
        String details = this.capability.getUninstallDetails();
        if (details == null) {
            if (this.natureIds.length == 1) {
                details = NLS.bind((String)IDEWorkbenchMessages.RemoveCapabilityStep_defaultDescription0, (Object)this.capability.getName());
            } else if (this.natureIds.length == 2) {
                CapabilityRegistry reg = IDEWorkbenchPlugin.getDefault().getCapabilityRegistry();
                Capability otherCapability = reg.getCapabilityForNature(this.natureIds[1]);
                if (otherCapability == this.capability) {
                    otherCapability = reg.getCapabilityForNature(this.natureIds[0]);
                }
                details = NLS.bind((String)IDEWorkbenchMessages.RemoveCapabilityStep_defaultDescription1, (Object)this.capability.getName(), (Object)otherCapability.getName());
            } else {
                StringBuffer msg = new StringBuffer();
                CapabilityRegistry reg = IDEWorkbenchPlugin.getDefault().getCapabilityRegistry();
                int i = 0;
                while (i < this.natureIds.length) {
                    Capability cap = reg.getCapabilityForNature(this.natureIds[i]);
                    if (cap != this.capability) {
                        msg.append("\n    ");
                        msg.append(cap.getName());
                    }
                    ++i;
                }
                details = NLS.bind((String)IDEWorkbenchMessages.RemoveCapabilityStep_defaultDescription2, (Object)this.capability.getName(), (Object)msg);
            }
        }
        return details;
    }

    public IWizard getWizard() {
        if (this.wizard == null) {
            this.wizard = this.capability.getUninstallWizard();
            if (this.wizard == null) {
                this.wizard = new RemoveCapabilityWizard();
            }
            if (this.wizard != null) {
                this.wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY, this.project, this.natureIds);
                this.wizard.addPages();
            }
        }
        return this.wizard;
    }
}

