/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.accesscontrol.ejb.session;

import com.clustercontrol.accesscontrol.factory.ModifyUser;
import com.clustercontrol.accesscontrol.factory.SelectUser;
import com.clustercontrol.accesscontrol.factory.UserFilterProperty;
import com.clustercontrol.accesscontrol.factory.UserProperty;
import com.clustercontrol.accesscontrol.util.LdapConnectionManager;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.util.Messages;
import java.rmi.RemoteException;
import java.security.Principal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AccessControllerBean
implements SessionBean {
    protected static Log m_log = LogFactory.getLog(AccessControllerBean.class);
    private SessionContext m_context;

    public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
        this.m_context = ctx;
    }

    public ArrayList getUserListTableDefine(Locale locale) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(0, new TableColumnInfo(Messages.getString((String)"user.id", (Locale)locale), -1, 100, 16384));
        tableDefine.add(1, new TableColumnInfo(Messages.getString((String)"name", (Locale)locale), -1, 100, 16384));
        tableDefine.add(2, new TableColumnInfo(Messages.getString((String)"description", (Locale)locale), -1, 150, 16384));
        tableDefine.add(3, new TableColumnInfo(Messages.getString((String)"creator.name", (Locale)locale), -1, 100, 16384));
        tableDefine.add(4, new TableColumnInfo(Messages.getString((String)"create.time", (Locale)locale), -1, 100, 16384));
        tableDefine.add(5, new TableColumnInfo(Messages.getString((String)"modifier.name", (Locale)locale), -1, 100, 16384));
        tableDefine.add(6, new TableColumnInfo(Messages.getString((String)"update.time", (Locale)locale), -1, 100, 16384));
        return tableDefine;
    }

    public ArrayList getUserList() throws FinderException, NamingException {
        ArrayList list = null;
        try {
            SelectUser select = new SelectUser();
            list = select.getUserList();
        }
        catch (FinderException e) {
            m_log.debug((Object)("getUserList() -> " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        return list;
    }

    public ArrayList getUserList(Property property) throws FinderException, NamingException {
        ArrayList list = null;
        try {
            SelectUser select = new SelectUser();
            list = select.getUserList(property);
        }
        catch (FinderException e) {
            m_log.debug((Object)("getUserList() -> " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        return list;
    }

    public Property getUserFilterProperty(Locale locale) {
        UserFilterProperty user = new UserFilterProperty();
        return user.getProperty(locale);
    }

    public Property getUserProperty(String uid, int mode, Locale locale) throws FinderException, NamingException {
        try {
            UserProperty user = new UserProperty();
            return user.getProperty(uid, mode, locale);
        }
        catch (FinderException e) {
            m_log.debug((Object)("getUserProperty() -> " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
    }

    public void addUser(Property property) throws NamingException, CreateException, FinderException, ParseException {
        Principal pri = this.m_context.getCallerPrincipal();
        try {
            ModifyUser modify = new ModifyUser();
            modify.addUser(property, pri.getName());
        }
        catch (NamingException e) {
            throw e;
        }
        catch (CreateException e) {
            throw e;
        }
        catch (FinderException e) {
            m_log.debug((Object)("addUser() -> " + e.getMessage()));
            throw e;
        }
        catch (ParseException e) {
            throw e;
        }
    }

    public void modifyUser(Property property) throws NamingException, FinderException {
        Principal pri = this.m_context.getCallerPrincipal();
        try {
            ModifyUser modify = new ModifyUser();
            modify.modifyUser(property, pri.getName());
        }
        catch (NamingException e) {
            throw e;
        }
        catch (FinderException e) {
            m_log.debug((Object)("modifyUser() -> " + e.getMessage()));
            throw e;
        }
    }

    public void deleteUser(String uid) throws NamingException, RemoveException, FinderException {
        try {
            ModifyUser modify = new ModifyUser();
            modify.deleteUser(uid);
        }
        catch (NamingException e) {
            throw e;
        }
        catch (RemoveException e) {
            throw e;
        }
        catch (FinderException e) {
            m_log.debug((Object)("deleteUser() -> " + e.getMessage()));
            throw e;
        }
    }

    public void changePassword(String uid, String password) throws NamingException, RemoveException, FinderException {
        try {
            ModifyUser modify = new ModifyUser();
            modify.modifyPassword(uid, password);
        }
        catch (FinderException e) {
            m_log.debug((Object)("changePassword() -> " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
    }

    public boolean isPermission(String roleName) throws NamingException {
        return this.m_context.isCallerInRole(roleName);
    }

    public String getUserName() throws NamingException, FinderException {
        Principal pri = this.m_context.getCallerPrincipal();
        SelectUser select = new SelectUser();
        return select.getUserName(pri.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getConnection(int count, boolean isQuery) {
        Context ctx = null;
        try {
            for (int i = 0; i < count; ++i) {
                ctx = LdapConnectionManager.getConnectionManager().getDirContext();
                if (isQuery) {
                    Attributes attrs = ctx.getAttributes("uid=hinemos,ou=hinemos,ou=people");
                }
                if (ctx == null) continue;
                try {
                    ctx.close();
                    continue;
                }
                catch (NamingException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

