/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.composite;

import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.monitor.action.GetFilterScope;
import com.clustercontrol.monitor.action.GetScopeListTableDefine;
import com.clustercontrol.monitor.view.action.ScopeSpecifiedShowAction;
import com.clustercontrol.util.Messages;
import java.rmi.AccessException;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class ScopeListComposite
extends Composite {
    private CommonTableViewer tableViewer = null;
    private Label criticalLabel = null;
    private Label warningLabel = null;
    private Label infoLabel = null;
    private Label unknownLabel = null;
    private Label totalLabel = null;
    private boolean openAccessInformation = false;

    public ScopeListComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(5, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Table table = new Table((Composite)this, 66308);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 5;
        table.setLayoutData((Object)gridData);
        this.criticalLabel = new Label((Composite)this, 0x1000000);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.criticalLabel.setLayoutData((Object)gridData);
        this.criticalLabel.setBackground(this.getDisplay().getSystemColor(3));
        this.warningLabel = new Label((Composite)this, 0x1000000);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.warningLabel.setLayoutData((Object)gridData);
        this.warningLabel.setBackground(this.getDisplay().getSystemColor(7));
        this.infoLabel = new Label((Composite)this, 0x1000000);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.infoLabel.setLayoutData((Object)gridData);
        this.infoLabel.setBackground(this.getDisplay().getSystemColor(5));
        this.unknownLabel = new Label((Composite)this, 0x1000000);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.unknownLabel.setLayoutData((Object)gridData);
        this.unknownLabel.setBackground(new Color(null, 128, 192, 255));
        this.totalLabel = new Label((Composite)this, 0x1000000);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.totalLabel.setLayoutData((Object)gridData);
        this.tableViewer = new CommonTableViewer(table);
        this.tableViewer.createTableColumn(GetScopeListTableDefine.getScopeListTableDefine(), 4, 1, 1);
        int i = 0;
        while (i < table.getColumnCount()) {
            table.getColumn(i).setMoveable(true);
            ++i;
        }
        ScopeSpecifiedShowAction listener = new ScopeSpecifiedShowAction();
        this.tableViewer.addDoubleClickListener((IDoubleClickListener)listener);
    }

    public CommonTableViewer getTableViewer() {
        return this.tableViewer;
    }

    public void update(String facilityId) {
        ArrayList infoList;
        block3: {
            super.update();
            infoList = null;
            try {
                infoList = new GetFilterScope().getFilterInfo(facilityId);
            }
            catch (AccessException accessException) {
                if (this.openAccessInformation) break block3;
                this.openAccessInformation = true;
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            }
        }
        if (infoList == null) {
            infoList = new ArrayList();
        }
        this.updateStatus(infoList);
        this.tableViewer.setInput(infoList);
    }

    protected void updateStatus(ArrayList list) {
        int[] status = new int[4];
        if (list != null) {
            int count = list.size();
            int i = 0;
            while (i < count) {
                ArrayList data = (ArrayList)list.get(i);
                int value = (Integer)data.get(0);
                switch (value) {
                    case 0: {
                        status[0] = status[0] + 1;
                        break;
                    }
                    case 2: {
                        status[1] = status[1] + 1;
                        break;
                    }
                    case 3: {
                        status[2] = status[2] + 1;
                        break;
                    }
                    case 1: {
                        status[3] = status[3] + 1;
                    }
                }
                ++i;
            }
        }
        this.criticalLabel.setText(String.valueOf(status[0]));
        this.warningLabel.setText(String.valueOf(status[1]));
        this.infoLabel.setText(String.valueOf(status[2]));
        this.unknownLabel.setText(String.valueOf(status[3]));
        int total = status[0] + status[1] + status[2] + status[3];
        Object[] args = new Object[]{String.valueOf(total)};
        this.totalLabel.setText(Messages.getString((String)"records", (Object[])args));
    }
}

