/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.factory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.notify.ejb.entity.SystemNotifyEventInfoLocal;
import com.clustercontrol.notify.ejb.entity.SystemNotifyInfoLocal;
import com.clustercontrol.notify.ejb.entity.SystemNotifyInfoUtil;
import com.clustercontrol.util.apllog.AplLogger;
import java.util.Collection;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeleteSystemNotify {
    protected static Log m_log = LogFactory.getLog(DeleteSystemNotify.class);

    public boolean delete(String notifyId) throws FinderException, RemoveException, NamingException, JMSException {
        AccessLock.lock((String)"NOTIFY");
        SystemNotifyInfoLocal notify = null;
        try {
            notify = SystemNotifyInfoUtil.getLocalHome().findByPrimaryKey(notifyId);
            Collection ct = notify.getSystemNotifyEventInfo();
            this.deleteEvents(ct);
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            Object[] args = new String[]{notifyId};
            apllog.put("SYS", "003", args);
            m_log.debug((Object)("delete():" + e.getMessage()));
            throw e;
        }
        catch (RemoveException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            Object[] args = new String[]{notifyId};
            apllog.put("SYS", "003", args);
            m_log.debug((Object)("delete():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            Object[] args = new String[]{notifyId};
            apllog.put("SYS", "003", args);
            m_log.debug((Object)("delete():" + e.getMessage()));
            throw e;
        }
        return true;
    }

    public boolean deleteEvents(Collection ct) throws RemoveException {
        if (ct != null && ct.size() > 0) {
            Object[] eventArray = ct.toArray();
            for (int j = 0; j < eventArray.length; ++j) {
                SystemNotifyEventInfoLocal event = (SystemNotifyEventInfoLocal)eventArray[j];
                if (event == null) continue;
                event.remove();
            }
        }
        return true;
    }
}

