/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.util;

import java.util.ArrayList;
import java.util.Date;

public class RealtimeCollectorInfo {
    private int interval;
    private int requestInterval;
    private String facilityId;
    private int graphNum;
    private ArrayList subScopeFacilityId;
    private ArrayList subScopeFacilityName;
    private int subScopeNum;
    private Date timestamp;
    private int timestampId;
    private Date collectStartTime;
    private Date collectEndTime;
    private Date graphStartTime;
    private Date graphEndTime;
    private int graphPlotNum;

    public RealtimeCollectorInfo() {
        this.initialize();
    }

    private void initialize() {
        this.interval = 0;
        this.requestInterval = 0;
        this.facilityId = null;
        this.graphNum = 4;
        this.subScopeNum = 0;
        this.timestamp = new Date(System.currentTimeMillis());
        this.timestampId = 0;
        this.collectStartTime = null;
        this.collectEndTime = null;
        this.graphStartTime = null;
        this.graphEndTime = null;
        this.graphPlotNum = 0;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setFacilityId(String facilityId) {
        this.facilityId = facilityId;
    }

    public String getFacilityId() {
        return this.facilityId;
    }

    public void setGraphNum(int graphNum) {
        this.graphNum = graphNum;
    }

    public int getGraphNum() {
        return this.graphNum;
    }

    public String getSubScopeFacilityId(int i) {
        return this.subScopeFacilityId.get(i).toString();
    }

    public void setSubScopeFacilityId(ArrayList subScopeFacilityId) {
        this.subScopeFacilityId = subScopeFacilityId;
    }

    public ArrayList getSubScopeFacilityName() {
        return this.subScopeFacilityName;
    }

    public void setSubScopeFacilityName(ArrayList subScopeFacilityName) {
        this.subScopeFacilityName = subScopeFacilityName;
    }

    public int getRequestInterval() {
        return this.requestInterval;
    }

    public void setRequestInterval(int requestInterval) {
        this.requestInterval = requestInterval;
    }

    public int getSubScopeNum() {
        return this.subScopeNum;
    }

    public void setSubScopeNum(int subScopeNum) {
        this.subScopeNum = subScopeNum;
    }

    public boolean isCurrentCollect(Date timestamp, int timestampId) {
        boolean ret = false;
        if (this.timestamp == timestamp && this.timestampId == timestampId) {
            ret = true;
        }
        return ret;
    }

    public int setCurrentCollect(Date timestamp) {
        if (timestamp.after(this.timestamp)) {
            this.timestamp = timestamp;
            this.timestampId = 0;
        } else if (this.timestamp == timestamp) {
            ++this.timestampId;
        }
        return this.timestampId;
    }

    public Date getGraphStartTime() {
        return this.graphStartTime;
    }

    public void setGraphStartTime(Date graphStartTime) {
        this.graphStartTime = graphStartTime;
    }

    public Date getGraphEndTime() {
        return this.graphEndTime;
    }

    public void setGraphEndTime(Date graphEndTime) {
        this.graphEndTime = graphEndTime;
    }

    public Date getCollectStartTime() {
        return this.collectStartTime;
    }

    public void setCollectStartTime(Date collectStartTime) {
        this.collectStartTime = collectStartTime;
    }

    public Date getCollectEndTime() {
        return this.collectEndTime;
    }

    public void setCollectEndTime(Date collectEndTime) {
        this.collectEndTime = collectEndTime;
    }

    public int getGraphPlotNum() {
        return this.graphPlotNum;
    }

    public void setGraphPlotNum(int graphPlotNum) {
        this.graphPlotNum = graphPlotNum;
    }
}

