/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.monitor.dialog;

import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.performance.monitor.action.DeletePerformance;
import com.clustercontrol.performance.monitor.action.GetPerformance;
import com.clustercontrol.performance.monitor.action.ModifyPerformance;
import com.clustercontrol.performance.monitor.composite.PerformanceListComposite;
import com.clustercontrol.performance.monitor.dialog.PerformanceCreateDialog;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class PerformanceListDialog
extends CommonDialog {
    private PerformanceListComposite perfList = null;
    private Button buttonAdd = null;
    private Button buttonModify = null;
    private Button buttonDelete = null;
    private Button buttonValid = null;
    private Button buttonInvalid = null;

    public PerformanceListDialog(Shell parent) {
        super(parent);
    }

    protected Point getInitialSize() {
        return new Point(800, 350);
    }

    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString((String)"dialog.performance.monitor.list"));
        GridLayout layout = new GridLayout(8, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 8;
        parent.setLayout((Layout)layout);
        this.perfList = new PerformanceListComposite(parent, 2048);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 7;
        this.perfList.setLayoutData(gridData);
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout(1, true);
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        composite.setLayoutData((Object)gridData);
        this.buttonAdd = this.createButton(composite, Messages.getString((String)"add"));
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PerformanceCreateDialog dialog = new PerformanceCreateDialog(PerformanceListDialog.this.getParentShell());
                if (dialog.open() == 0) {
                    PerformanceListDialog.this.perfList.update();
                }
            }
        });
        new Label(composite, 0);
        this.buttonModify = this.createButton(composite, Messages.getString((String)"modify"));
        this.buttonModify.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String monitorId = null;
                Table table = PerformanceListDialog.this.perfList.getTableViewer().getTable();
                TableItem[] item = table.getSelection();
                if (item != null && item.length > 0) {
                    try {
                        monitorId = (String)((ArrayList)item[0].getData()).get(0);
                    }
                    catch (Exception exception) {}
                }
                if (monitorId != null) {
                    PerformanceCreateDialog dialog = new PerformanceCreateDialog(PerformanceListDialog.this.getParentShell(), monitorId);
                    if (dialog.open() == 0) {
                        int selectIndex = table.getSelectionIndex();
                        PerformanceListDialog.this.perfList.update();
                        table.setSelection(selectIndex);
                    }
                } else {
                    MessageDialog.openWarning(null, (String)Messages.getString((String)"warning"), (String)Messages.getString((String)"message.monitor.1"));
                }
            }
        });
        new Label(composite, 0);
        this.buttonDelete = this.createButton(composite, Messages.getString((String)"delete"));
        this.buttonDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String monitorId = null;
                Table table = PerformanceListDialog.this.perfList.getTableViewer().getTable();
                TableItem[] item = table.getSelection();
                if (item != null && item.length > 0) {
                    try {
                        monitorId = (String)((ArrayList)item[0].getData()).get(0);
                    }
                    catch (Exception exception) {}
                }
                if (monitorId != null) {
                    Object[] args = new String[]{monitorId};
                    if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)Messages.getString((String)"message.monitor.39", (Object[])args))) {
                        boolean result = new DeletePerformance().delete(monitorId);
                        if (result) {
                            MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.monitor.37", (Object[])args));
                            PerformanceListDialog.this.perfList.update();
                        } else {
                            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)Messages.getString((String)"message.monitor.38", (Object[])args));
                        }
                    }
                } else {
                    MessageDialog.openWarning(null, (String)Messages.getString((String)"warning"), (String)Messages.getString((String)"message.monitor.1"));
                }
            }
        });
        new Label(composite, 0);
        this.buttonValid = this.createButton(composite, Messages.getString((String)"valid"));
        this.buttonValid.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PerformanceListDialog.this.setValid(1);
            }
        });
        this.buttonInvalid = this.createButton(composite, Messages.getString((String)"invalid"));
        this.buttonInvalid.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PerformanceListDialog.this.setValid(0);
            }
        });
        Label line = new Label(parent, 258);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 8;
        line.setLayoutData((Object)gridData);
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2, (display.getBounds().height - shell.getSize().y) / 2);
    }

    protected ValidateResult validate() {
        return super.validate();
    }

    private Button createButton(Composite parent, String label) {
        Button button = new Button(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)gridData);
        button.setText(label);
        return button;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, false);
    }

    public void setValid(int valid) {
        ArrayList<String> list = this.perfList.getSelectionData();
        if (list != null && list.size() > 0) {
            StringBuilder monitorIds = new StringBuilder();
            int i = 0;
            while (i < list.size()) {
                if (i > 0) {
                    monitorIds.append(", ");
                }
                monitorIds.append(list.get(i));
                ++i;
            }
            Object[] confirmArgs = new String[]{monitorIds.toString()};
            String message = valid == 1 ? Messages.getString((String)"message.monitor.47", (Object[])confirmArgs) : Messages.getString((String)"message.monitor.48", (Object[])confirmArgs);
            if (!MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)message)) {
                return;
            }
            int i2 = 0;
            while (i2 < list.size()) {
                String monitorId = list.get(i2);
                if (monitorId != null && !monitorId.equals("")) {
                    MonitorInfo info = new GetPerformance().getProcess(monitorId);
                    info.setValid(valid);
                    boolean result = new ModifyPerformance().modify(info);
                    if (!result) {
                        Object[] args = new String[]{monitorId};
                        MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)Messages.getString((String)"message.monitor.36", (Object[])args));
                    }
                }
                ++i2;
            }
            int selectIndex = this.perfList.getTableViewer().getTable().getSelectionIndex();
            this.perfList.update();
            this.perfList.getTableViewer().getTable().setSelection(selectIndex);
        } else {
            MessageDialog.openWarning(null, (String)Messages.getString((String)"warning"), (String)Messages.getString((String)"message.monitor.1"));
        }
    }
}

