/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.action;

import com.clustercontrol.performanceMGR.bean.CollectedDataSet;
import com.clustercontrol.performanceMGR.bean.CollectorLockKey;
import com.clustercontrol.performanceMGR.bean.CollectorProperty;
import com.clustercontrol.performanceMGR.bean.DeviceDataSet;
import com.clustercontrol.performanceMGR.ejb.session.CollectorController;
import com.clustercontrol.performanceMGR.ejb.session.CollectorControllerHome;
import com.clustercontrol.performanceMGR.util.code.CollectorItemTreeItem;
import com.clustercontrol.util.LoginManager;
import com.clustercontrol.util.Messages;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.jnp.interfaces.NamingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordController {
    private static RecordController m_instance = null;
    private CollectorController bean;
    CollectorLockKey m_lockKey;
    private int errorCount = 1;
    public static final String KEY_EJB_URL = "ejbUrl";
    public static final String VALUE_EJB_URL = "jnp://localhost:1099";

    private RecordController() {
        Properties pro = System.getProperties();
        String userName = pro.getProperty("user.name");
        if (userName == null) {
            userName = "nobody";
        }
        String ipAddress = null;
        try {
            ipAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            String time = pro.getProperty("eclipse.startTime");
            if (time == null) {
                time = Long.toString(System.currentTimeMillis());
            }
            int hash = Thread.currentThread().hashCode();
            ipAddress = "unknown host (" + time + "-" + hash + ")";
        }
        this.m_lockKey = new CollectorLockKey(ipAddress, userName);
    }

    public static synchronized RecordController getInstance() {
        if (m_instance == null) {
            m_instance = new RecordController();
        }
        if (RecordController.m_instance.bean != null) {
            m_instance.removeBean();
        }
        m_instance.createBean();
        if (RecordController.m_instance.bean == null) {
            m_instance = null;
            return null;
        }
        return m_instance;
    }

    public static synchronized void deleteInstance() {
        if (m_instance != null) {
            m_instance.removeBean();
            RecordController.m_instance.bean = null;
            m_instance = null;
        }
    }

    private void createBean() {
        try {
            this.bean = this.getCollectorControllerHome().create();
        }
        catch (RemoteException remoteException) {
            this.bean = null;
        }
        catch (CreateException createException) {
            this.bean = null;
        }
        catch (NamingException namingException) {
            this.bean = null;
        }
    }

    private void removeBean() {
        try {
            if (this.bean != null) {
                this.bean.remove();
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (RemoveException removeException) {}
        this.bean = null;
    }

    public ArrayList getCollectionListTableDefine() {
        int i = 0;
        while (i <= this.errorCount) {
            if (this.bean == null) {
                this.createBean();
            }
            if (this.bean != null) {
                try {
                    return this.bean.getCollectionListTableDefine(Locale.getDefault());
                }
                catch (RemoteException remoteException) {
                    this.removeBean();
                }
            }
            ++i;
        }
        return null;
    }

    public ArrayList getCollectionList() {
        int i = 0;
        while (i <= this.errorCount) {
            if (this.bean == null) {
                this.createBean();
            }
            if (this.bean != null) {
                try {
                    return this.bean.getCollectionList();
                }
                catch (RemoteException e) {
                    if (e instanceof AccessException) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                    }
                    this.removeBean();
                }
            }
            ++i;
        }
        return null;
    }

    public boolean registRecordCollector(CollectorProperty def) throws DuplicateKeyException {
        int i = 0;
        while (i <= this.errorCount) {
            if (this.bean == null) {
                this.createBean();
            }
            if (this.bean != null) {
                try {
                    this.bean.createRecordColletor(def);
                    return true;
                }
                catch (RemoteException remoteException) {
                    this.removeBean();
                }
            }
            ++i;
        }
        return false;
    }

    public boolean stopRecordCollector(String collectorID) {
        int i = 0;
        while (i <= this.errorCount) {
            if (this.bean == null) {
                this.createBean();
            }
            if (this.bean != null) {
                try {
                    this.bean.stopRecordCollector(collectorID);
                    return true;
                }
                catch (RemoteException remoteException) {
                    this.removeBean();
                }
            }
            ++i;
        }
        return false;
    }

    public boolean deleteRecordCollector(String collectorID) throws RemoveException {
        int i = 0;
        while (i <= this.errorCount) {
            if (this.bean == null) {
                this.createBean();
            }
            if (this.bean != null) {
                try {
                    this.bean.deleteRecordCollector(collectorID);
                    return true;
                }
                catch (RemoteException remoteException) {
                    this.removeBean();
                }
            }
            ++i;
        }
        return false;
    }

    public CollectorProperty getCollectorProperty(String collectorID) {
        CollectorProperty property = null;
        int i = 0;
        while (i <= this.errorCount) {
            if (this.bean == null) {
                this.createBean();
            }
            if (this.bean != null) {
                try {
                    property = this.bean.getCollectorProperty(collectorID);
                    return property;
                }
                catch (RemoteException remoteException) {
                    this.removeBean();
                }
            }
            ++i;
        }
        return null;
    }

    public CollectedDataSet getRecordCollectedData(String collectorID, String[] facilityIDs, int[] itemIDs, Date startDate, Date endDate) {
        CollectedDataSet dataSet = null;
        int i = 0;
        while (i <= this.errorCount) {
            if (this.bean == null) {
                this.createBean();
            }
            if (this.bean != null) {
                try {
                    dataSet = this.bean.getRecordCollectedData(collectorID, facilityIDs, itemIDs, startDate, endDate);
                    return dataSet;
                }
                catch (RemoteException remoteException) {
                    this.removeBean();
                }
            }
            ++i;
        }
        return null;
    }

    public DeviceDataSet getCurrentDeviceSet(String facilityID) {
        DeviceDataSet deviceSet = null;
        int i = 0;
        while (i <= this.errorCount) {
            if (this.bean == null) {
                this.createBean();
            }
            if (this.bean != null) {
                try {
                    deviceSet = this.bean.getCurrentDeviceSet(facilityID);
                    return deviceSet;
                }
                catch (RemoteException remoteException) {
                    this.removeBean();
                }
            }
            ++i;
        }
        return null;
    }

    public HashMap<String, CollectorItemTreeItem> getItemCodeTreeMap() {
        int i = 0;
        while (i <= this.errorCount) {
            if (this.bean == null) {
                this.createBean();
            }
            if (this.bean != null) {
                try {
                    return this.bean.getItemCodeMap();
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    this.removeBean();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        return null;
    }

    public CollectorItemTreeItem[] getCollectorTree(String facilityId, String collectorId) {
        int i = 0;
        while (i <= this.errorCount) {
            if (this.bean == null) {
                this.createBean();
            }
            if (this.bean != null) {
                try {
                    return this.bean.getCollectorTree(facilityId, collectorId);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    this.removeBean();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        return null;
    }

    public List getAvailableCollectorItemList(String facilityId) {
        int i = 0;
        while (i <= this.errorCount) {
            if (this.bean == null) {
                this.createBean();
            }
            if (this.bean != null) {
                try {
                    return this.bean.getAvailableCollectorItemList(facilityId);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    this.removeBean();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        return null;
    }

    public boolean checkPermissionRead() {
        int i = 0;
        while (i <= this.errorCount) {
            if (this.bean == null) {
                this.createBean();
            }
            if (this.bean != null) {
                try {
                    return this.bean.checkPermissionRead();
                }
                catch (AccessException accessException) {
                    this.bean = null;
                    return false;
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    this.removeBean();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        return false;
    }

    public boolean checkPermissionWrite() {
        int i = 0;
        while (i <= this.errorCount) {
            if (this.bean == null) {
                this.createBean();
            }
            if (this.bean != null) {
                try {
                    return this.bean.checkPerformanceWrite();
                }
                catch (AccessException accessException) {
                    this.bean = null;
                    return false;
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    this.removeBean();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        return false;
    }

    public boolean checkPermissionExecute() {
        int i = 0;
        while (i <= this.errorCount) {
            if (this.bean == null) {
                this.createBean();
            }
            if (this.bean != null) {
                try {
                    return this.bean.checkPermissionExecute();
                }
                catch (AccessException accessException) {
                    this.bean = null;
                    return false;
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    this.removeBean();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        return false;
    }

    public void lock(String collectorID) {
        int i = 0;
        while (i <= this.errorCount) {
            if (this.bean == null) {
                this.createBean();
            }
            if (this.bean != null) {
                try {
                    this.bean.lock(collectorID, this.m_lockKey);
                    return;
                }
                catch (RemoteException remoteException) {
                    this.removeBean();
                }
            }
            ++i;
        }
    }

    public void unlock() {
        int i = 0;
        while (i <= this.errorCount) {
            if (this.bean == null) {
                this.createBean();
            }
            if (this.bean != null) {
                try {
                    this.bean.unlock(this.m_lockKey);
                    return;
                }
                catch (RemoteException remoteException) {
                    this.removeBean();
                }
            }
            ++i;
        }
    }

    private CollectorControllerHome getCollectorControllerHome() throws NamingException {
        return (CollectorControllerHome)this.getContext().lookup("CollectorController");
    }

    private NamingContext getContext() throws NamingException {
        NamingContext namingContext = LoginManager.getContextManager().getNamingContext();
        return namingContext;
    }
}

