/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.snmptrap.dialog;

import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.composite.StringVerifyListener;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.composite.MonitorBasicScopeComposite;
import com.clustercontrol.monitor.run.composite.NumericRunJobComposite;
import com.clustercontrol.notify.composite.NotifyInfoComposite;
import com.clustercontrol.snmptrap.action.AddSnmpTrap;
import com.clustercontrol.snmptrap.action.GetSnmpTrap;
import com.clustercontrol.snmptrap.action.ModifySnmpTrap;
import com.clustercontrol.snmptrap.bean.MonitorSnmpTrapInfo;
import com.clustercontrol.snmptrap.bean.MonitorSnmpTrapOidInfo;
import com.clustercontrol.snmptrap.composite.OidListComposite;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SnmpTrapCreateDialog
extends CommonDialog {
    public static final int WIDTH_TITLE = 5;
    public static final int WIDTH_VALUE = 2;
    private MonitorSnmpTrapInfo inputData = null;
    private ValidateResult validateResult = null;
    private String monitorId = null;
    private MonitorBasicScopeComposite monitorBasicComposite = null;
    private Text textCommunityName = null;
    private OidListComposite oidListComposite = null;
    private CommonTableViewer tableViewer = null;
    private NotifyInfoComposite notifyInfoComposite = null;
    private Button m_checkJobRun = null;
    private NumericRunJobComposite m_jobRun = null;
    private Button confirmValid = null;

    public SnmpTrapCreateDialog(Shell parent) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    public SnmpTrapCreateDialog(Shell parent, String monitorId) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.monitorId = monitorId;
    }

    protected Point getInitialSize() {
        return new Point(750, 750);
    }

    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString((String)"dialog.snmptrap.create.modify"));
        Label label = null;
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 15;
        parent.setLayout((Layout)layout);
        this.monitorBasicComposite = new MonitorBasicScopeComposite(parent, 0, true);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.monitorBasicComposite.setLayoutData((Object)gridData);
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"trap.definition")) + " : ");
        Group groupCheckRule = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        groupCheckRule.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        groupCheckRule.setLayoutData((Object)gridData);
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"community.name")) + " : ");
        this.textCommunityName = new Text((Composite)groupCheckRule, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.textCommunityName.setLayoutData((Object)gridData);
        this.textCommunityName.addVerifyListener((VerifyListener)new StringVerifyListener(64));
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.oidListComposite = new OidListComposite((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.oidListComposite.setLayoutData(gridData);
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"notify.attribute")) + " : ");
        Group groupNotifyAttribute = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        groupNotifyAttribute.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupNotifyAttribute.setLayoutData((Object)gridData);
        this.notifyInfoComposite = new NotifyInfoComposite((Composite)groupNotifyAttribute, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.notifyInfoComposite.setLayoutData((Object)gridData);
        this.m_checkJobRun = new Button((Composite)groupNotifyAttribute, 32);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_checkJobRun.setLayoutData((Object)gridData);
        this.m_checkJobRun.setText(String.valueOf(Messages.getString((String)"run")) + " : ");
        this.m_checkJobRun.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SnmpTrapCreateDialog.this.m_jobRun.setEnabled(SnmpTrapCreateDialog.this.m_checkJobRun.getSelection());
            }
        });
        Group groupRunJob = new Group((Composite)groupNotifyAttribute, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        groupRunJob.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupRunJob.setLayoutData((Object)gridData);
        this.m_jobRun = new NumericRunJobComposite((Composite)groupRunJob, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_jobRun.setLayoutData((Object)gridData);
        this.confirmValid = new Button(parent, 32);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.confirmValid.setLayoutData((Object)gridData);
        this.confirmValid.setText(Messages.getString((String)"setting.valid.confirmed"));
        Label line = new Label(parent, 258);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 15;
        line.setLayoutData((Object)gridData);
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2, (display.getBounds().height - shell.getSize().y) / 2);
        MonitorSnmpTrapInfo info = null;
        if (this.monitorId == null) {
            info = new MonitorSnmpTrapInfo();
            info.setOidInfos(new ArrayList());
        } else {
            info = new GetSnmpTrap().getSnmp(this.monitorId);
        }
        this.setInputData(info);
    }

    public MonitorSnmpTrapInfo getInputData() {
        return this.inputData;
    }

    protected void setInputData(MonitorSnmpTrapInfo monitor) {
        this.monitorBasicComposite.setInputData((MonitorInfo)monitor);
        if (monitor.getCommunityName() != null) {
            this.textCommunityName.setText(monitor.getCommunityName());
        }
        this.oidListComposite.setCheckMode(monitor.getCheckMode());
        this.oidListComposite.setMonitorId(monitor.getMonitorId());
        this.oidListComposite.setOidList(monitor.getOidInfos());
        this.oidListComposite.update();
        if (monitor.getNotifyId() != null) {
            this.notifyInfoComposite.setText(monitor.getNotifyId());
        }
        if (monitor.getApplication() != null) {
            this.notifyInfoComposite.setApplication(monitor.getApplication());
        }
        this.m_checkJobRun.setSelection(YesNoConstant.typeToBoolean((int)monitor.getJobRun()));
        this.m_jobRun.setInputData((MonitorInfo)monitor);
        this.m_jobRun.setEnabled(YesNoConstant.typeToBoolean((int)monitor.getJobRun()));
        if (monitor.getValid() == 1) {
            this.confirmValid.setSelection(true);
        }
    }

    protected MonitorSnmpTrapInfo createInputData() {
        MonitorSnmpTrapInfo info = new MonitorSnmpTrapInfo();
        info.setMonitorTypeId("SNMPTRAP");
        info.setMonitorType(1);
        this.validateResult = this.monitorBasicComposite.createInputData((MonitorInfo)info);
        if (this.validateResult != null) {
            return null;
        }
        if (this.textCommunityName.getText() == null || "".equals(this.textCommunityName.getText().trim())) {
            this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.snmptrap.1"));
            return null;
        }
        info.setCommunityName(this.textCommunityName.getText());
        info.setCheckMode(this.oidListComposite.getCheckMode());
        info.setOidInfos(this.oidListComposite.getOidList());
        int i = 0;
        while (i < info.getOidInfos().size()) {
            MonitorSnmpTrapOidInfo oidInfo = (MonitorSnmpTrapOidInfo)info.getOidInfos().get(i);
            if (oidInfo.getMonitorId() == null || oidInfo.getMonitorId().equals(info.getMonitorId())) {
                oidInfo.setMonitorId(info.getMonitorId());
            }
            ++i;
        }
        if (this.notifyInfoComposite.getText() != null && !"".equals(this.notifyInfoComposite.getText().trim())) {
            info.setNotifyId(this.notifyInfoComposite.getText());
        }
        if (this.notifyInfoComposite.getApplication() != null && !"".equals(this.notifyInfoComposite.getApplication().trim())) {
            info.setApplication(this.notifyInfoComposite.getApplication());
        } else if (this.notifyInfoComposite.getText() != null && !"".equals(this.notifyInfoComposite.getText().trim())) {
            info.setNotifyId(this.notifyInfoComposite.getText());
            this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.10"));
            return null;
        }
        info.setJobRun(YesNoConstant.booleanToType((boolean)this.m_checkJobRun.getSelection()));
        if (info.getJudgementInfo() == null) {
            info.setJudgementInfo(new ArrayList());
        }
        this.validateResult = this.m_jobRun.createInputData((MonitorInfo)info);
        if (this.validateResult != null) {
            return null;
        }
        if (this.confirmValid.getSelection()) {
            info.setValid(1);
        } else {
            info.setValid(0);
        }
        return info;
    }

    protected ValidateResult validate() {
        this.inputData = this.createInputData();
        if (this.inputData != null && this.validateResult == null) {
            return super.validate();
        }
        return this.validateResult;
    }

    protected boolean action() {
        boolean result = false;
        MonitorSnmpTrapInfo info = this.inputData;
        if (info != null) {
            result = this.monitorId == null ? new AddSnmpTrap().add(info) : new ModifySnmpTrap().modify(info);
        }
        return result;
    }

    protected String getOkButtonText() {
        return Messages.getString((String)"ok");
    }

    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }

    private void setValidateResult(String id, String message) {
        this.validateResult = new ValidateResult();
        this.validateResult.setValid(false);
        this.validateResult.setID(id);
        this.validateResult.setMessage(message);
    }

    public CommonTableViewer getTableViewer() {
        return this.tableViewer;
    }
}

