/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.themes;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public final class ColorUtils {
    static /* synthetic */ Class class$0;

    private static RGB process(String value) {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.SWT");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> clazz2 = clazz;
            Field[] fields = clazz2.getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                Field field = fields[i];
                if (field.getType() == Integer.TYPE && Modifier.isStatic(field.getModifiers()) && Modifier.isPublic(field.getModifiers()) && Modifier.isFinal(field.getModifiers()) && value.equals(field.getName())) {
                    return ColorUtils.getSystemColor(field.getInt(null));
                }
                ++i;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        return ColorUtils.getSystemColor(2);
    }

    public static RGB blend(RGB val1, RGB val2) {
        int red = ColorUtils.blend(val1.red, val2.red);
        int green = ColorUtils.blend(val1.green, val2.green);
        int blue = ColorUtils.blend(val1.blue, val2.blue);
        return new RGB(red, green, blue);
    }

    private static int blend(int temp1, int temp2) {
        return Math.abs(temp1 - temp2) / 2 + Math.min(temp1, temp2);
    }

    private static RGB getSystemColor(int colorId) {
        return Display.getCurrent().getSystemColor(colorId).getRGB();
    }

    public static RGB getColorValue(String rawValue) {
        if (rawValue == null) {
            return null;
        }
        if (!ColorUtils.isDirectValue(rawValue = rawValue.trim())) {
            return ColorUtils.process(rawValue);
        }
        return StringConverter.asRGB((String)rawValue);
    }

    public static RGB[] getColorValues(String[] rawValues) {
        RGB[] values = new RGB[rawValues.length];
        int i = 0;
        while (i < rawValues.length) {
            values[i] = ColorUtils.getColorValue(rawValues[i]);
            ++i;
        }
        return values;
    }

    private static boolean isDirectValue(String rawValue) {
        return rawValue.indexOf(44) >= 0;
    }

    private ColorUtils() {
    }
}

