/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.composite;

import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.jobmanagement.action.GetForwardFile;
import com.clustercontrol.jobmanagement.action.GetForwardFileTableDefine;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class ForwardFileComposite
extends Composite {
    protected CommonTableViewer m_viewer = null;
    protected String m_sessionId = null;
    protected String m_jobId = null;
    protected Label m_idLabel = null;

    public ForwardFileComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.m_idLabel = new Label((Composite)this, 16384);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.m_idLabel.setLayoutData((Object)gridData);
        Table table = new Table((Composite)this, 66308);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData((Object)gridData);
        this.m_viewer = new CommonTableViewer(table);
        this.m_viewer.createTableColumn(GetForwardFileTableDefine.get(), 0, 1);
    }

    public void update(String sessionId, String jobId) {
        ArrayList list = null;
        GetForwardFile getForwardFile = new GetForwardFile();
        list = sessionId != null && jobId != null ? getForwardFile.get(sessionId, jobId) : new ArrayList();
        this.m_viewer.setInput(list);
        this.m_sessionId = sessionId;
        this.m_jobId = jobId;
        if (this.m_sessionId != null && this.m_jobId != null) {
            this.m_idLabel.setText(String.valueOf(Messages.getString((String)"session.id")) + " : " + this.m_sessionId + ",   " + Messages.getString((String)"job.id") + " : " + this.m_jobId);
        } else {
            this.m_idLabel.setText(String.valueOf(Messages.getString((String)"session.id")) + " : " + ",   " + Messages.getString((String)"job.id") + " : ");
        }
    }

    public TableViewer getTableViewer() {
        return this.m_viewer;
    }

    public Table getTable() {
        return this.m_viewer.getTable();
    }

    public String getSessionId() {
        return this.m_sessionId;
    }

    public void setSessionId(String sessionId) {
        this.m_sessionId = sessionId;
    }

    public String getJobId() {
        return this.m_jobId;
    }

    public void setJobId(String jobId) {
        this.m_jobId = jobId;
    }
}

