/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.troubledetection.monitor;

import java.io.IOException;
import java.util.Date;
import java.util.Vector;

import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;

import com.clustercontrol.monitor.message.LogOutputInfo;
import com.clustercontrol.troubledetection.output.OutputLog;
import com.clustercontrol.troubledetection.util.NotifyMessages;

/**
 * JBoss監視クラス
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class MonitorJboss extends MonitorBase {
	private static Log log = LogFactory.getLog(MonitorJboss.class);

	protected static final String LOOKUP_NAME = "jmx/invoker/RMIAdaptor";
	protected static final String OBJECT_NAME = "jboss:service=HinemosPartition";
	protected static final String OPERATION_NAME = "getCurrentView";
	
	/**
	 * 監視実行
	 * 
	 * @see com.clustercontrol.troubledetection.monitor.MonitorBase#run()
	 */
	public void run() {
		log.debug("run() start :");
		
		boolean server1 = false;
		boolean server2 = false;
		
		try{
	        InitialContext ic = new InitialContext();
	        
	        //RMIAdaptorを取得
	        RMIAdaptor server = (RMIAdaptor) ic.lookup(LOOKUP_NAME);

	        //ObjectNameを設定
	        ObjectName name = new ObjectName(OBJECT_NAME);
	        
	        //ObjectNameのOperationNameのメソッドを実行
	        Object returnObject = server.invoke(name, OPERATION_NAME, null, null);
	        
	        //結果からJBossのパーティションへの参加をチェックする
	        if(returnObject instanceof Vector){
	        	Vector returnVector = (Vector)returnObject;
	        	
	        	for(int i = 0; i < returnVector.size(); i++){
	        		//host:portを取得
	        		String work = (String)returnVector.get(i);
	        		String node[] = work.split(":");
	        		
	        		//JBossサーバ1のIPと比較
	        		if(node[0].equals(this.troubleDetectionInfo.getJbossServer1())){
	        			server1 = true;
	        		}
	        		//JBossサーバ2のIPと比較
	        		else if(node[0].equals(this.troubleDetectionInfo.getJbossServer2())){
	        			server2 = true;
	        		}
	        	}
	        }
		} catch (NamingException e) {
			log.error("run() : " + e.getMessage());
		} catch (MalformedObjectNameException e) {
			log.error("run() : " + e.getMessage());
		} catch (NullPointerException e) {
			log.error("run() : " + e.getMessage());
		} catch (InstanceNotFoundException e) {
			log.error("run() : " + e.getMessage());
		} catch (MBeanException e) {
			log.error("run() : " + e.getMessage());
		} catch (ReflectionException e) {
			log.error("run() : " + e.getMessage());
		} catch (IOException e) {
			log.error("run() : " + e.getMessage());
		}
		
        //ログ出力
        logout(server1, server2);
        
		log.debug("run() end :");
	}
	
	/**
	 * ログ出力
	 * 
	 * @param server1
	 * @param server2
	 */
	protected void logout(boolean server1, boolean server2) {
		
		String application = NotifyMessages.getString("jboss.application");
		
		OutputLog output = new OutputLog(troubleDetectionInfo);
		
		//サーバ1＆サーバ2正常
		if(server1 && server2){
			//通知情報作成
			LogOutputInfo info = new LogOutputInfo();
			//プラグインID
			info.setPluginId(PLUGIN_ID);
			//アプリケーション
			info.setApplication(application);
			//監視項目ID
			info.setMonitorId("JBOSS01");
			//メッセージID
			info.setMessageId("001");
			//メッセージ、オリジナルメッセージ
			info.setMessage(NotifyMessages.getString("jboss01.001.message"));
			String[] args = {this.troubleDetectionInfo.getJbossServer1(), 
					this.troubleDetectionInfo.getJbossServer2()};
			info.setMessageOrg(NotifyMessages.getString("jboss01.001.org.message", args));
			//ファシリティID
			info.setFacilityId(FACILITY_ID);
			//スコープ01
			info.setScopeText("");
			//重要度
			info.setPriority(getPriority(NotifyMessages.getString("jboss01.001.priority")));
			//発生日時
			info.setGenerationDate(new Date());
			
			//ログ出力
			output.outputLog(notifyInfo, info);
		}
		//サーバ1正常、サーバ2異常
		else if(server1 && !server2){
			//通知情報作成
			LogOutputInfo info = new LogOutputInfo();
			//プラグインID
			info.setPluginId(PLUGIN_ID);
			//アプリケーション
			info.setApplication(application);
			//監視項目ID
			info.setMonitorId("JBOSS01");
			//メッセージID
			info.setMessageId("002");
			//メッセージ、オリジナルメッセージ
			String[] args1 = {this.troubleDetectionInfo.getJbossServer2()};
			info.setMessage(NotifyMessages.getString("jboss01.002.message", args1));
			String[] args2 = {this.troubleDetectionInfo.getJbossServer1(), 
					this.troubleDetectionInfo.getJbossServer2()};
			info.setMessageOrg(NotifyMessages.getString("jboss01.002.org.message", args2));
			//ファシリティID
			info.setFacilityId(FACILITY_ID);
			//スコープ01
			info.setScopeText("");
			//重要度
			info.setPriority(getPriority(NotifyMessages.getString("jboss01.002.priority")));
			//発生日時
			info.setGenerationDate(new Date());
			
			//ログ出力
			output.outputLog(notifyInfo, info);
		}
		//サーバ1異常、サーバ2正常
		else if(!server1 && server2){
			//通知情報作成
			LogOutputInfo info = new LogOutputInfo();
			//プラグインID
			info.setPluginId(PLUGIN_ID);
			//アプリケーション
			info.setApplication(application);
			//監視項目ID
			info.setMonitorId("JBOSS01");
			//メッセージID
			info.setMessageId("002");
			//メッセージ、オリジナルメッセージ
			String[] args1 = {this.troubleDetectionInfo.getJbossServer1()};
			info.setMessage(NotifyMessages.getString("jboss01.002.message", args1));
			String[] args2 = {this.troubleDetectionInfo.getJbossServer2(), 
					this.troubleDetectionInfo.getJbossServer1()};
			info.setMessageOrg(NotifyMessages.getString("jboss01.002.org.message", args2));
			//ファシリティID
			info.setFacilityId(FACILITY_ID);
			//スコープ01
			info.setScopeText("");
			//重要度
			info.setPriority(getPriority(NotifyMessages.getString("jboss01.002.priority")));
			//発生日時
			info.setGenerationDate(new Date());
			
			//ログ出力
			output.outputLog(notifyInfo, info);
		}
	}
	
	/**
	 * ログ出力
	 * 
	 * @param messageId
	 */
	public void logout(String monitorId, String messageId){
		
		String application = NotifyMessages.getString("jboss.application");
		String key = monitorId.toLowerCase() + "." + messageId;
		
		OutputLog output = new OutputLog(troubleDetectionInfo);

		//通知情報作成
		LogOutputInfo info = new LogOutputInfo();
		//プラグインID
		info.setPluginId(PLUGIN_ID);
		//アプリケーション
		info.setApplication(application);
		//監視項目ID
		info.setMonitorId(monitorId);
		//メッセージID
		info.setMessageId(messageId);
		//メッセージ、オリジナルメッセージ
		if(key.equals("jboss02.001")){
			String[] args1 = {this.troubleDetectionInfo.getJbossServer1(), 
					this.troubleDetectionInfo.getJbossServer2()};
			info.setMessage(NotifyMessages.getString(key + ".message", args1));
			String[] args2 = {this.troubleDetectionInfo.getJbossServer1(), 
					this.troubleDetectionInfo.getJbossServer2()};
			info.setMessageOrg(NotifyMessages.getString(key + ".org.message", args2));
		}
		else if(key.equals("jboss03.001")){
			String[] args1 = {this.troubleDetectionInfo.getJbossServer2(), 
					this.troubleDetectionInfo.getJbossServer1()};
			info.setMessage(NotifyMessages.getString(key + ".message", args1));
			String[] args2 = {this.troubleDetectionInfo.getJbossServer2(), 
					this.troubleDetectionInfo.getJbossServer1()};
			info.setMessageOrg(NotifyMessages.getString(key + ".org.message", args2));
		}
		else{
			info.setMessage(NotifyMessages.getString(key + ".message"));
			info.setMessageOrg(NotifyMessages.getString(key + ".org.message"));
		}
		//ファシリティID
		info.setFacilityId(FACILITY_ID);
		//スコープ
		info.setScopeText("");
		//重要度
		info.setPriority(getPriority(NotifyMessages.getString(key + ".priority")));
		//発生日時
		info.setGenerationDate(new Date());
		
		//ログ出力
		output.outputLog(notifyInfo, info);
	}
}
