/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.sql.dialog;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.bean.DataRangeConstant;
import com.clustercontrol.bean.MonitorConstant;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.composite.StringVerifyListener;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorTypeConstant;
import com.clustercontrol.monitor.run.composite.MonitorBasicScopeComposite;
import com.clustercontrol.monitor.run.composite.MonitorRuleComposite;
import com.clustercontrol.monitor.run.composite.NumericMessageComposite;
import com.clustercontrol.monitor.run.composite.NumericRunJobComposite;
import com.clustercontrol.monitor.run.composite.NumericValueInfoComposite;
import com.clustercontrol.monitor.run.composite.StringValueInfoComposite;
import com.clustercontrol.notify.composite.NotifyInfoComposite;
import com.clustercontrol.sql.action.AddSql;
import com.clustercontrol.sql.action.GetSql;
import com.clustercontrol.sql.action.GetSqlStringValueListTableDefine;
import com.clustercontrol.sql.action.ModifySql;
import com.clustercontrol.sql.bean.MonitorSqlInfo;
import com.clustercontrol.sql.util.JdbcDriverUtil;
import com.clustercontrol.util.Messages;

/**
 * SQL監視作成・変更ダイアログクラスです。
 * 
 * @version 2.2.0
 * @since 2.0.0
 */
public class SqlCreateDialog extends CommonDialog {
	
	public static final int WIDTH_TITLE = 5;
	public static final int WIDTH_VALUE = 2;

    // ----- instance フィールド ----- //

    /** 入力値を保持するオブジェクト */
    private MonitorInfo inputData = null;

    /** 入力値の正当性を保持するオブジェクト */
    private ValidateResult validateResult = null;
    
    /** 変更対象の監視項目ID */
    private String monitorId = null;
    
    /** 監視基本情報 */
    private MonitorBasicScopeComposite m_monitorBasic = null;
    
    /** 監視条件 共通部分 */
    private MonitorRuleComposite m_monitorRule = null;
    
    /** 接続文字列 */
    private Text textUrl = null;

    /** JDBCドライバ */
    private Combo textJdbcDriver = null;

    /** ユーザ */
    private Text textUser = null;
    
    /** パスワード */
    private Text textPassword = null;
    
    /** クエリ */
    private Text textQuery = null;
    
    /** 数値監視判定情報 */
    private NumericValueInfoComposite m_numericValueInfo= null;
    
    /** 文字列監視判定情報 */
    private StringValueInfoComposite m_stringValueInfo= null;
    
    /** 通知情報 */
    private NotifyInfoComposite m_notifyInfo = null;
    
    /** 通知メッセージ情報 */
    private NumericMessageComposite m_notifyMessageInfo = null;
    
    /** ジョブ実行 @version 2.1.0 */
    private Button m_checkJobRun = null;
    
    /** ジョブ実行情報 @version 2.1.0 */
    private NumericRunJobComposite m_jobRun = null;

    /** この設定を有効にする */
    private Button confirmValid = null;
    
	/** 監視判定タイプ @version 2.1.0 */
	private int m_monitorType;

    // ----- コンストラクタ ----- //

    /**
     * 作成用ダイアログのインスタンスを返します。
     * 
     * @param parent 親のシェルオブジェクト
     */
    public SqlCreateDialog(Shell parent) {
        super(parent);
    }
    
    /**
     * 作成用ダイアログのインスタンスを返します。
     * 
     * @param parent 親のシェルオブジェクト
     * @param monitorType 監視判定タイプ
     */
    public SqlCreateDialog(Shell parent, int monitorType) {
        super(parent);

        this.m_monitorType = monitorType;
    }

    /**
     * 変更用ダイアログのインスタンスを返します。
     * 
     * @param parent 親のシェルオブジェクト
     * @param monitorId 変更する監視項目ID
     * @param monitorType 監視判定タイプ
     */
    public SqlCreateDialog(Shell parent, String monitorId, int monitorType) {
        super(parent);

        this.monitorId = monitorId;
        this.m_monitorType = monitorType;
    }

    // ----- instance メソッド ----- //

    /**
     * ダイアログエリアを生成します。
     * 
     * @param parent
     *            親のインスタンス
     */
    protected void customizeDialog(Composite parent) {
    	
        Shell shell = this.getShell();

        // タイトル
        shell.setText(Messages.getString("dialog.sql.create.modify"));

        // 変数として利用されるラベル
        Label label = null;
        // 変数として利用されるグリッドデータ
        GridData gridData = null;

        // レイアウト
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 15;
        parent.setLayout(layout);
        
        // 監視基本情報
        m_monitorBasic = new MonitorBasicScopeComposite(parent, SWT.NONE);
        gridData = new GridData();
		gridData.horizontalSpan = 15;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		m_monitorBasic.setLayoutData(gridData);
        
        /*
         * 監視条件グループ
         */
        // ラベル
        label = new Label(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("monitor.rule") + " : ");
        
        // グループ
        Group groupRule = new Group(parent, SWT.NONE);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        groupRule.setLayout(layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        groupRule.setLayoutData(gridData);

        m_monitorRule = new MonitorRuleComposite(groupRule, SWT.NONE);
        gridData = new GridData();
		gridData.horizontalSpan = 15;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		m_monitorRule.setLayoutData(gridData);
        
        /*
         * チェック条件グループ
         */
        // ラベル
        label = new Label(groupRule, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("check.rule") + " : ");
        
        // グループ
        Group groupCheckRule = new Group(groupRule, SWT.NONE);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        groupCheckRule.setLayout(layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        groupCheckRule.setLayoutData(gridData);
        
        // 接続文字列
        // ラベル
        label = new Label(groupCheckRule, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_TITLE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("connection.url") + " : ");
        // テキスト
        this.textUrl = new Text(groupCheckRule, SWT.BORDER | SWT.LEFT);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.textUrl.setLayoutData(gridData);
        this.textUrl.addVerifyListener(
        		new StringVerifyListener(DataRangeConstant.VARCHAR_256));
        this.textUrl.setText("jdbc:");
        // 空白
        label = new Label(groupCheckRule, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        // 接続先DB
        // ラベル
        label = new Label(groupCheckRule, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_TITLE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("connection.db") + " : ");
        // コンボ
        this.textJdbcDriver = new Combo(groupCheckRule, SWT.BORDER | SWT.READ_ONLY);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.textJdbcDriver.setLayoutData(gridData);
        List<List> list = JdbcDriverUtil.getJdbcDriver();
        for(int i = 0; i < list.size(); i++){
        	List driver = list.get(i);
        	String name = (String)driver.get(0);
        	this.textJdbcDriver.add(name);
        }
        this.textJdbcDriver.select(0);
        
        // 空白
        label = new Label(groupCheckRule, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        // ユーザ
        // ラベル
        label = new Label(groupCheckRule, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_TITLE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("user.id") + " : ");
        // テキスト
        this.textUser = new Text(groupCheckRule, SWT.BORDER | SWT.LEFT);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.textUser.setLayoutData(gridData);
        this.textUser.addVerifyListener(
        		new StringVerifyListener(DataRangeConstant.VARCHAR_64));
        // 空白
        label = new Label(groupCheckRule, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        // パスワード
        // ラベル
        label = new Label(groupCheckRule, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_TITLE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("password") + " : ");
        // テキスト
        this.textPassword = new Text(groupCheckRule, SWT.BORDER | SWT.LEFT | SWT.PASSWORD);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.textPassword.setLayoutData(gridData);
        this.textPassword.addVerifyListener(
        		new StringVerifyListener(DataRangeConstant.VARCHAR_64));
        // 空白
        label = new Label(groupCheckRule, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        // SQL文
        // ラベル
        label = new Label(groupCheckRule, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_TITLE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("sql.string") + " : ");
        // テキスト
        this.textQuery= new Text(groupCheckRule, SWT.BORDER | SWT.LEFT);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.textQuery.setLayoutData(gridData);
        this.textQuery.addVerifyListener(
        		new StringVerifyListener(DataRangeConstant.VARCHAR_1024));
        // 空白
        label = new Label(groupCheckRule, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        // 数値監視の場合     
		if(m_monitorType == MonitorTypeConstant.TYPE_NUMERIC){

			/*
	         * 重要度グループ
	         */
	        // ラベル
	        label = new Label(parent, SWT.NONE);
	        gridData = new GridData();
	        gridData.horizontalSpan = 15;
	        gridData.horizontalAlignment = GridData.FILL;
	        gridData.grabExcessHorizontalSpace = true;
	        label.setLayoutData(gridData);
	        label.setText(Messages.getString("def.result") + " : ");
	        
	        // グループ
	        Group groupDefResultNode = new Group(parent, SWT.NONE);
	        layout = new GridLayout(1, true);
	        layout.marginWidth = 5;
	        layout.marginHeight = 5;
	        layout.numColumns = 1;
	        groupDefResultNode.setLayout(layout);
	        gridData = new GridData();
	        gridData.horizontalSpan = 15;
	        gridData.horizontalAlignment = GridData.FILL;
	        gridData.grabExcessHorizontalSpace = true;
	        groupDefResultNode.setLayoutData(gridData);
			
			// 数値判定定義情報
	        m_numericValueInfo = new NumericValueInfoComposite(groupDefResultNode, 
	        		SWT.NONE,
	        		true,
	        		Messages.getString("threshold.lower.limit"),
	        		Messages.getString("threshold.upper.limit"),
	        		NumericValueInfoComposite.INPUT_VERIFICATION_INTEGER_NUMBER);
	        m_numericValueInfo.setInputRange1(DataRangeConstant.SMALLINT_LOW, DataRangeConstant.SMALLINT_HIGH);
	        m_numericValueInfo.setInputRange2(DataRangeConstant.SMALLINT_LOW, DataRangeConstant.SMALLINT_HIGH);
	        gridData = new GridData();
			gridData.horizontalSpan = 1;
			gridData.horizontalAlignment = GridData.FILL;
			gridData.grabExcessHorizontalSpace = true;
			m_numericValueInfo.setLayoutData(gridData);
		}
		
		/*
         * 通知情報の属性グループ
         */
        // ラベル
        label = new Label(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("notify.attribute") + " : ");
        
        // グループ
        Group groupNotifyAttribute = new Group(parent, SWT.NONE);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        groupNotifyAttribute.setLayout(layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        groupNotifyAttribute.setLayoutData(gridData);
        
        // 通知情報（通知ID，アプリケーションID）
		if(m_monitorType == MonitorTypeConstant.TYPE_NUMERIC){
        	this.m_notifyInfo = new NotifyInfoComposite(groupNotifyAttribute, SWT.NONE);
        }
        else if(m_monitorType == MonitorTypeConstant.TYPE_STRING){
        	this.m_notifyInfo = new NotifyInfoComposite(groupNotifyAttribute, SWT.NONE, Messages.getString("notify.id.default"));
        }
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		this.m_notifyInfo.setLayoutData(gridData);
        
		// 数値監視の場合     
		if(m_monitorType == MonitorTypeConstant.TYPE_NUMERIC){
			
			// グループ
	        Group groupNotifyMessage = new Group(groupNotifyAttribute, SWT.NONE);
	        layout = new GridLayout(1, true);
	        layout.marginWidth = 5;
	        layout.marginHeight = 5;
	        layout.numColumns = 1;
	        groupNotifyMessage.setLayout(layout);
	        gridData = new GridData();
	        gridData.horizontalSpan = 1;
	        gridData.horizontalAlignment = GridData.FILL;
	        gridData.grabExcessHorizontalSpace = true;
	        groupNotifyMessage.setLayoutData(gridData);
	        
	        // 通知メッセージ情報（メッセージID、メッセージ）
			this.m_notifyMessageInfo = new NumericMessageComposite(groupNotifyMessage, SWT.NONE);
			gridData = new GridData();
			gridData.horizontalSpan = 1;
			gridData.horizontalAlignment = GridData.FILL;
			gridData.grabExcessHorizontalSpace = true;
			m_notifyMessageInfo.setLayoutData(gridData);
			
			// ジョブ実行
	        this.m_checkJobRun = new Button(groupNotifyAttribute, SWT.CHECK);
	        gridData = new GridData();
	        gridData.horizontalSpan = 1;
	        gridData.horizontalAlignment = GridData.FILL;
	        gridData.grabExcessHorizontalSpace = true;
	        m_checkJobRun.setLayoutData(gridData);
	        m_checkJobRun.setText(Messages.getString("run") + " : ");
	        m_checkJobRun.addSelectionListener(new SelectionAdapter() {
	            public void widgetSelected(SelectionEvent e) {
	            	m_jobRun.setEnabled(m_checkJobRun.getSelection());
	            }
	        });
			
			// ジョブ実行グループ
	        Group groupRunJob = new Group(groupNotifyAttribute, SWT.NONE);
	        layout = new GridLayout(1, true);
	        layout.marginWidth = 5;
	        layout.marginHeight = 5;
	        layout.numColumns = 1;
	        groupRunJob.setLayout(layout);
	        gridData = new GridData();
	        gridData.horizontalSpan = 15;
	        gridData.horizontalAlignment = GridData.FILL;
	        gridData.grabExcessHorizontalSpace = true;
	        groupRunJob.setLayoutData(gridData);
	        
	        // 実行（実行，ジョブID，通知抑制と連動，呼出失敗時）
			this.m_jobRun = new NumericRunJobComposite(groupRunJob, SWT.NONE);
			gridData = new GridData();
			gridData.horizontalSpan = 1;
			gridData.horizontalAlignment = GridData.FILL;
			gridData.grabExcessHorizontalSpace = true;
			m_jobRun.setLayoutData(gridData);
		}
		// 文字列監視の場合
		else if(m_monitorType == MonitorTypeConstant.TYPE_STRING){
			
			/*
	         * 重要度の定義グループ
	         */
			// ラベル
	        label = new Label(parent, SWT.NONE);
	        gridData = new GridData();
	        gridData.horizontalSpan = 15;
	        gridData.horizontalAlignment = GridData.FILL;
	        gridData.grabExcessHorizontalSpace = true;
	        label.setLayoutData(gridData);
	        label.setText(Messages.getString("def.result") + " : ");
	        
	        // グループ
	        Group groupDefResult = new Group(parent, SWT.NONE);
	        layout = new GridLayout(1, true);
	        layout.marginWidth = 5;
	        layout.marginHeight = 5;
	        layout.numColumns = 1;
	        groupDefResult.setLayout(layout);
	        gridData = new GridData();
	        gridData.horizontalSpan = 15;
	        gridData.horizontalAlignment = GridData.FILL;
	        gridData.grabExcessHorizontalSpace = true;
	        groupDefResult.setLayoutData(gridData);
			
	        ArrayList tableDefine = GetSqlStringValueListTableDefine.get();
			this.m_stringValueInfo = new StringValueInfoComposite(groupDefResult, SWT.NONE, tableDefine);
			gridData = new GridData();
			gridData.horizontalSpan = 1;
			gridData.horizontalAlignment = GridData.FILL;
			gridData.grabExcessHorizontalSpace = true;
			m_stringValueInfo.setLayoutData(gridData);
		}
		
        /*
         * 有効／無効
         */
        this.confirmValid = new Button(parent, SWT.CHECK);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.confirmValid.setLayoutData(gridData);
        this.confirmValid.setText(Messages.getString("setting.valid.confirmed"));
        
        // ラインを引く
        Label line = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 15;
        line.setLayoutData(gridData);


        // サイズを最適化
        // グリッドレイアウトを用いた場合、こうしないと横幅が画面いっぱいになります。
        shell.pack();
        shell.setSize(new Point(550, shell.getSize().y));

        // 画面中央に
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2,
                (display.getBounds().height - shell.getSize().y) / 2);

        // 初期表示
        MonitorInfo info = null; 
        if(this.monitorId == null){
        	// 作成の場合
        	info = new MonitorInfo();
        }
        else{
        	// 変更の場合、情報取得
        	info = new GetSql().getSql(this.monitorId, this.m_monitorType);
        }
        this.setInputData(info);
    }

    /**
     * 入力内容を返します。
     * 
     * @return 入力内容を保持した通知情報
     */
    public MonitorInfo getInputData() {
        return this.inputData;
    }

    /**
     * 各項目に入力値を設定します。
     * 
     * @param monitor
     *            設定値として用いる監視情報
     */
    protected void setInputData(MonitorInfo monitor) {

        // 監視基本情報
        m_monitorBasic.setInputData(monitor);
        
        // 監視条件
        m_monitorRule.setInputData(monitor);
        
        // 監視条件 SQL監視情報
        MonitorSqlInfo sqlInfo = (MonitorSqlInfo)monitor.getCheckInfo();
        if(sqlInfo != null){
            if (sqlInfo.getConnectionUrl() != null) {
                this.textUrl.setText(sqlInfo.getConnectionUrl());
            }
            if (sqlInfo.getUser() != null) {
                this.textUser.setText(sqlInfo.getUser());
            }
            if (sqlInfo.getPassword() != null) {
                this.textPassword.setText(sqlInfo.getPassword());
            }
            if (sqlInfo.getJdbcDriver() != null) {
                List<List> list = JdbcDriverUtil.getJdbcDriver();
                for(int i = 0; i < list.size(); i++){
                	List driver = list.get(i);
                	String className = (String)driver.get(1);
                	if(className.equals(sqlInfo.getJdbcDriver())){
                		this.textJdbcDriver.setText((String)driver.get(0));
                		break;
                	}
                }
            }
            if (sqlInfo.getQuery() != null) {
                this.textQuery.setText(sqlInfo.getQuery());
            }
        }
        
        //　通知情報の属性
        if (monitor.getNotifyId() != null) {
        	this.m_notifyInfo.setText(monitor.getNotifyId());
        }
        if (monitor.getApplication() != null) {
        	this.m_notifyInfo.setApplication(monitor.getApplication());
        }
        
        // 数値監視の場合     
		if(m_monitorType == MonitorTypeConstant.TYPE_NUMERIC){
			
			// 重要度の定義
	        m_numericValueInfo.setInputData(monitor);
	        
	        // 通知メッセージの定義
	        m_notifyMessageInfo.setInputData(monitor);
	        
	        // ジョブ実行
	        m_checkJobRun.setSelection(YesNoConstant.typeToBoolean(monitor.getJobRun()));
	        
	        // 各重要度のジョブ実行
	        m_jobRun.setInputData(monitor);
	        m_jobRun.setEnabled(YesNoConstant.typeToBoolean(monitor.getJobRun()));
			
		}
		// 文字列監視の場合
		else if(m_monitorType == MonitorTypeConstant.TYPE_STRING){
			
			// 重要度の定義
	        m_stringValueInfo.setInputData(monitor);
		}
        
        // 有効／無効
        if (monitor.getValid() == ValidConstant.TYPE_VALID) {
            this.confirmValid.setSelection(true);
        }
    }

    /**
     * 入力値を用いて通知情報を生成します。
     * 
     * @return 入力値を保持した通知情報
     */
    protected MonitorInfo createInputData() {
    	MonitorInfo info = new MonitorInfo();

    	info.setMonitorTypeId(MonitorConstant.STRING_SQL);
    	info.setMonitorType(m_monitorType);
    	
    	// 監視基本情報
    	validateResult = m_monitorBasic.createInputData(info);
    	if(validateResult != null){
        	return null;
        }
        
        // 監視条件 共通部分
        validateResult = m_monitorRule.createInputData(info);
        if(validateResult != null){
        	return null;
        }
        
        // 監視条件 SQL監視情報
        MonitorSqlInfo sqlInfo = new MonitorSqlInfo();
        sqlInfo.setMonitorTypeId(MonitorConstant.STRING_SQL);
        sqlInfo.setMonitorId(info.getMonitorId());
        
        //接続先URL
        if (this.textUrl.getText() != null
                && !"".equals((this.textUrl.getText()).trim())) {
    		//テキストボックスから文字列を取得
    		String url = this.textUrl.getText();
    		if (url.length() > 0 && !url.startsWith("jdbc:")) {
                this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.sql.8"));
                return null;
            }
        	sqlInfo.setConnectionUrl(this.textUrl.getText());
        } else {
            this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.sql.1"));
            return null;
        }
        //ユーザ
        if (this.textUser.getText() != null
                && !"".equals((this.textUser.getText()).trim())) {
        	sqlInfo.setUser(this.textUser.getText());
        } else {
            this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.sql.2"));
            return null;
        }
        //パスワード
        if (this.textPassword.getText() != null
                && !"".equals((this.textPassword.getText()).trim())) {
        	sqlInfo.setPassword(this.textPassword.getText());
        } else {
            this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.sql.3"));
            return null;
        }
        //SQL文
        if (this.textQuery.getText() != null
                && !"".equals((this.textQuery.getText()).trim())) {
        	//SELECT文かチェック
        	String work = this.textQuery.getText().trim();
        	if(work.length() >= 6){
        		work = work.substring(0, 6);
    			if( work.equalsIgnoreCase("SELECT")){
    				sqlInfo.setQuery(this.textQuery.getText());
    			}
    			else {
    	            this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.sql.5"));
    	            return null;
    			}
        	}
        	else{
        		this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.sql.5"));
	            return null;
        	}
        } else {
            this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.sql.4"));
            return null;
        }
        //JDBCドライバ
        if (this.textJdbcDriver.getText() != null
                && !"".equals((this.textJdbcDriver.getText()).trim())) {
        	
            List<List> list = JdbcDriverUtil.getJdbcDriver();
            for(int i = 0; i < list.size(); i++){
            	List driver = list.get(i);
            	String name = (String)driver.get(0);
            	if(name.equals(this.textJdbcDriver.getText())){
            		sqlInfo.setJdbcDriver((String)driver.get(1));
            		break;
            	}
            }
            
            if (sqlInfo.getJdbcDriver() != null
                    && !"".equals(sqlInfo.getJdbcDriver().trim())) {
	        } else {
	            this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.sql.1"));
	            return null;
	        }
        } else {
            this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.sql.1"));
            return null;
        }
        info.setCheckInfo(sqlInfo);
        
        // 通知情報の属性
        if (this.m_notifyInfo.getText() != null
                && !"".equals((this.m_notifyInfo.getText()).trim())) {
        	info.setNotifyId(m_notifyInfo.getText());
        }
//        else{
//        	this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.9"));
//            return null;
//        }
        if (this.m_notifyInfo.getApplication() != null
                && !"".equals((this.m_notifyInfo.getApplication()).trim())) {
        	info.setApplication(m_notifyInfo.getApplication());
        }
        else{
        	if (this.m_notifyInfo.getText() != null
                    && !"".equals((this.m_notifyInfo.getText()).trim())) {
        		this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.10"));
                return null;	
        	}
        }
        
        // 数値監視の場合     
		if(m_monitorType == MonitorTypeConstant.TYPE_NUMERIC){
			
			// 重要度の定義
	        validateResult = m_numericValueInfo.createInputData(info);
	        if(validateResult != null){
	        	return null;
	        }
	        
	        // 通知メッセージの定義
	        validateResult = m_notifyMessageInfo.createInputData(info);
	        if(validateResult != null){
	        	return null;
	        }
	        
	        // ジョブ実行
	        info.setJobRun(YesNoConstant.booleanToType(m_checkJobRun.getSelection()));
	        
	        // 各重要度のジョブ実行
	        validateResult = m_jobRun.createInputData(info);
	        if(validateResult != null){
	        	return null;
	        }
		}
		// 文字列監視の場合
		else if(m_monitorType == MonitorTypeConstant.TYPE_STRING){
			
			// 重要度の定義
	        validateResult = m_stringValueInfo.createInputData(info);
	        if(validateResult != null){
	        	return null;
	        }
	        
	        // 重要度の定義に通知IDが設定されていた場合
	        if(m_stringValueInfo.isNotify()){
	        	if (this.m_notifyInfo.getApplication() == null
	                    || "".equals((this.m_notifyInfo.getApplication()).trim())) {
	            	this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.10"));
	                return null;
	            }
	        }
	        
	        // ジョブ実行
	        info.setJobRun(YesNoConstant.TYPE_YES);
		}
        
        // 有効/無効
        if (this.confirmValid.getSelection()) {
        	info.setValid(ValidConstant.TYPE_VALID);
        } else {
        	info.setValid(ValidConstant.TYPE_INVALID);
        }

        return info;
    }

    /**
     * 入力値チェックをします。
     * 
     * @return 検証結果
     */
    protected ValidateResult validate() {
        // 入力値生成
        this.inputData = this.createInputData();

        if (this.inputData != null) {
            return super.validate();
        } else {
            return validateResult;
        }
    }

    /**
     * 入力値をマネージャに登録します。
     * 
     * @return true：正常、false：異常
     * 
     * @see com.clustercontrol.dialog.CommonDialog#action()
     */
    protected boolean action() {
    	boolean result = false;
    	
    	MonitorInfo info = this.inputData;
    	if(info != null){
            if(this.monitorId == null){
            	// 作成の場合
            	result = new AddSql().add(info);
            }
            else{
            	// 変更の場合
            	result = new ModifySql().modify(info);
            }
    	}
    	
    	return result;
    }
    
    /**
     * ＯＫボタンのテキストを返します。
     * 
     * @return ＯＫボタンのテキスト
     */
    protected String getOkButtonText() {
        return Messages.getString("ok");
    }

    /**
     * キャンセルボタンのテキストを返します。
     * 
     * @return キャンセルボタンのテキスト
     */
    protected String getCancelButtonText() {
        return Messages.getString("cancel");
    }
    
    /**
     * 無効な入力値の情報を設定します
     *  
     */
    private void setValidateResult(String id, String message) {

        this.validateResult = new ValidateResult();
        this.validateResult.setValid(false);
        this.validateResult.setID(id);
        this.validateResult.setMessage(message);
    }
}