/*
                                                                                                
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
*/

package com.clustercontrol.snmppoller.job;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

import com.clustercontrol.snmppoller.SnmpSharedTable;
import com.clustercontrol.snmppoller.bean.PollingConfig;
import com.clustercontrol.snmppoller.util.JNDIConnectionManager;

/**
 * SNMPポーリングを実行するジョブクラス
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class SnmpPollingJob implements Job {
	protected static Log m_log = LogFactory.getLog( SnmpPollingJob.class );

	public void execute(JobExecutionContext context) throws JobExecutionException {
		// デバッグログ出力
		m_log.debug("execute start : ");
		
		// 引数を取得します
		JobDataMap dataMap = context.getJobDetail().getJobDataMap();

		// 収集値格納用テーブルを参照するためのJNDI名
		String jndiName = dataMap.getString("jndiName");

		// 収集間隔を取得
		int interval = dataMap.getInt("interval");
		
		// 収集対象のOIDのリスト
		List oids = (List)dataMap.get("oidList");

		// ポーリングの設定
		HashMap snmpConfMap = (HashMap)dataMap.get("snmpConfMap");

		// インデックスチェックフラグの設定
		boolean indexCheckFlg = dataMap.getBoolean("indexCheckFlg");
		
		/* 停止すべきポーリングがないかをチェックします(収集を停止すべきものは停止されます) */
		// 収集値格納用テーブルをルックアップ
		try {
			InitialContext iniCtx = JNDIConnectionManager.getInitialContext();
			
			Object obj = iniCtx.lookup(jndiName);
			
			SnmpSharedTable table = 
				(SnmpSharedTable)PortableRemoteObject.narrow(obj, SnmpSharedTable.class);

			// ファシリティIDのリストを取得
			Iterator itr = snmpConfMap.keySet().iterator();
			while(itr.hasNext()){
				String facilityId = (String)itr.next();
				// ポーリング間隔を設定する(サービス側の情報が失われていた場合にDBの情報で復元)
				table.setPollingInterval(facilityId, interval);
			}
			
			// 全てのファシリティのポーリングスケジュールをチェック
			table.checkAll();

			// ファシリティIDのリストを取得
			itr = snmpConfMap.keySet().iterator();
			while(itr.hasNext()){
				String facilityId = (String)itr.next();
				PollingConfig pConfig = table.getConfig(facilityId);
				if(pConfig == null){
					// 何もしない
					// 上でのチェックで参照されていないテーブルが削除された場合にここを通る
				} else {
					// スレッドをたててポーリングを実行する
					PollingThread pt = new PollingThread(
							pConfig.getSnmpConfig(),
							oids,
							jndiName,
							facilityId,
							indexCheckFlg
					);
					Thread th = new Thread(pt);
					// スレッドをデーモンスレッドとして起動
					th.start();
				}
			}
			
		} catch (NamingException e) {
			m_log.error(e);
		}
		
		// デバッグログ出力
		m_log.debug("execute end   : " + jndiName);
	}
}
