
/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.repository.factory;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.SnmpVersionConstant;
import com.clustercontrol.repository.util.DataTable;
import com.clustercontrol.repository.util.SearchNodeProperties;
import com.clustercontrol.repository.util.SnmpPoller;
import com.clustercontrol.util.PropertyUtil;
//import com.clustercontrol.sharedtable.bean.DataTable;
//import com.clustercontrol.snmppoller.SnmpPoller;

/**
 * SNMPでノードのデータを投入します。（factory）
 * @author miyamoto
 * @version 2.3.0
 * @since 2.1.2
 */

public class SearchNodeBySNMP {
	
	protected static Log m_log = LogFactory.getLog(SearchNodeBySNMP.class);
	
	private static final String OID_NAME      =".1.3.6.1.2.1.1.5.0";
	private static final String OID_DESCR     =".1.3.6.1.2.1.1.1.0";
	private static final String OID_CONTACT   =".1.3.6.1.2.1.1.4.0";
	
	private static final String OID_DEV_NAME  =".1.3.6.1.2.1.25.3.2.1.3";
	private static final String OID_DEV_INDEX =".1.3.6.1.2.1.25.3.2.1.1";
	private static final String OID_DEV_TYPE  =".1.3.6.1.2.1.25.3.2.1.2";
	
	private static final String OID_DISK_INDEX=".1.3.6.1.4.1.2021.13.15.1.1.1";
	private static final String OID_DISK_NAME =".1.3.6.1.4.1.2021.13.15.1.1.2";
	private static final String OID_NIC_INDEX =".1.3.6.1.2.1.2.2.1.1";
	private static final String OID_NIC_NAME  =".1.3.6.1.2.1.2.2.1.2";
	private static final String OID_FILESYSTEM_INDEX = ".1.3.6.1.2.1.25.2.3.1.1";
	private static final String OID_FILESYSTEM_TYPE = ".1.3.6.1.2.1.25.2.3.1.2";
	private static final String OID_FILESYSTEM_NAME=   ".1.3.6.1.2.1.25.2.3.1.3";
	
	/**
	 * ノードの情報を探す。
	 * @param pollingData
	 * @param mode
	 * @param locale
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public static  Property searchNode(Hashtable pollingData,int mode, Locale locale){
		
		//������� conf/repository_search_node.properties 
		//初期値でとりあえず初期化ե�����ͤ����
		
		SearchNodeProperties pollingProp = SearchNodeProperties.getProperties();
		int port					= pollingProp.getPort();
		int version 				= pollingProp.getVersion();
		String community 			= pollingProp.getCommunity();
		InetAddress ipAddress 	    = pollingProp.getAddress();
		int retries 				= pollingProp.getRetry();
		int timeout 				= pollingProp.getTimeOut();
		ArrayList oidList 		    = pollingProp.getOidList();
		
		
		//クライアントから受け取った設定値で上書き ��������
		try {
			ipAddress = InetAddress.getByName((String) pollingData.get("IPAddress"));		
		} catch (UnknownHostException e) {
			e.printStackTrace();
		}
		port = Integer.parseInt((String)pollingData.get("port"));
		community = (String)pollingData.get("community");
		version = ((Integer)pollingData.get("version")).intValue();
		
		//����DTO��poller����
		DataTable ret = new DataTable();
		SnmpPoller poller = new SnmpPoller();
		
		//pollingします。
		poller.polling(ipAddress, 
				port, 
				version, 
				community, 
				retries,
				timeout, 
				oidList, 
				ret);		
		//ポーリングした結果をつめるメソッドにまわします。�Ƶ�����
		return stractProperty(pollingData, ret, mode,locale);
	}
	
	/**
	 *  ノードのプロパティーを構成します。
	 * @param IPadder
	 * @param ret
	 * @param mode
	 * @param locale
	 * @return
	 */
	private static Property stractProperty(Hashtable pollingData,DataTable ret, int mode, Locale locale){
		
		
		//com.clustercontrol.bean.Property.javaを作ります。
		Property property = (new NodeProperty()).getProperty(mode, locale);
		ArrayList propertyList;
		
		//ノード情報"説明"の生成
		if(ret.getValue(OID_DESCR) != null){
			if(((String)ret.getValue(OID_DESCR).getValue()).length() !=0){
				
				propertyList = PropertyUtil.getProperty(property, NodeProperty.DESCRIPTION);
				((Property)propertyList.get(0)).setValue("Auto detect at " + (new Date()).toString());
			}
		}
		
		//IPアドレスの設定
		propertyList = PropertyUtil.getProperty(property, NodeProperty.IP_ADDRESS_V4);
		((Property)propertyList.get(0)).setValue((String)pollingData.get("IPAddress"));
		
		
		//SNMP関連データの設定
		propertyList = PropertyUtil.getProperty(property, NodeProperty.SNMP_PORT);
		((Property)propertyList.get(0)).setValue(new Integer(Integer.parseInt((String)pollingData.get("port"))));
		
		propertyList = PropertyUtil.getProperty(property, NodeProperty.SNMP_COMMUNITY);
		((Property)propertyList.get(0)).setValue((String)pollingData.get("community"));
		
		
		propertyList = PropertyUtil.getProperty(property, NodeProperty.SNMP_VERSION);
		((Property)propertyList.get(0)).setValue(SnmpVersionConstant.typeToString((Integer)pollingData.get("version")));
		
		
		//hostname の設定
		if(ret.getValue(OID_NAME) != null){
			String hostname = (String)ret.getValue(OID_NAME).getValue();
			if(hostname.length() != 0){
				//hosname.domainであればhostnameだけを入力
				if(hostname.indexOf(".") != -1){
					hostname = hostname.substring(0,hostname.indexOf("."));
				}
				//ホスト名、ノード名にそれぞれ設定
				propertyList = PropertyUtil.getProperty(property, NodeProperty.HOST_NAME);
				((Property)propertyList.get(0)).setValue(hostname);
				propertyList = PropertyUtil.getProperty(property, NodeProperty.NODE_NAME);
				((Property)propertyList.get(0)).setValue(hostname);
			}
		}
		
		
		//IPアドレスのバージョンをv4とする。
		propertyList = PropertyUtil.getProperty(property, NodeProperty.IP_ADDRESS_VERSION);
		((Property)propertyList.get(0)).setValue("v4");
		
		//連絡先はsnmpd.confに書かれている内容を設定する。
		if(ret.getValue(OID_CONTACT) != null){
			if(((String)ret.getValue(OID_CONTACT).getValue()).length() != 0){
				propertyList = PropertyUtil.getProperty(property, NodeProperty.ADMINISTRATOR);
				((Property)propertyList.get(0)).setValue((String)ret.getValue(OID_CONTACT).getValue());
			}
		}	
		
		//OSカテゴリの設定
		boolean isWindows = false;
		
		if(ret.getValue(OID_DESCR) != null){
			String description = ((String)ret.getValue(OID_DESCR).getValue()); 
			if(description.length() != 0){
				String OsName = "";
				
				
				//OSの種別はキーワードマッチで行う
				
				if(description.matches(".*indows.*")){
					OsName = "Windows";
					isWindows=true;
				}else if(description.matches(".*inux.*")){
					OsName = "Linux";
				}else if(description.matches(".*SunOS.*") || description.matches("Solaris")){
					OsName= "Solaris"; 
				}else{
					if(description.indexOf(" ") != -1){
						OsName = description.substring(0,description.indexOf(" "));
					}
				}
				
				//OS名は上の判定ロジックを利用した値を設定
				propertyList = PropertyUtil.getProperty(property, NodeProperty.OS_NAME);
				((Property)propertyList.get(0)).setValue(OsName);
				
				//OSのリリースは
				//propertyList = PropertyUtil.getProperty(property, NodeProperty.OS_RELEASE);
				//((Property)propertyList.get(0)).setValue(description);
				
				//OSバージョン
				propertyList = PropertyUtil.getProperty(property, NodeProperty.OS_VERSION);
				((Property)propertyList.get(0)).setValue(description);
				
				//プラットフォームファミリー
				//propertyList = PropertyUtil.getProperty(property, NodeProperty.PLATFORM_FAMILY_NAME);
				//((Property)propertyList.get(0)).setValue(description);
				
				//result.put(FacilityAttributeConstant.MACHINE,description);
				
				//result.put( FacilityAttributeConstant.CHARSET,description);
			}
		}
		
		
		//propertyListの中にdevicPropertyが入っていてその中に設定を行っていく。
		
		propertyList = PropertyUtil.getProperty(property, NodeProperty.DEVICE);
		Property deviceProperty = (Property)propertyList.get(0);
		int index = PropertyUtil.getPropertyIndex(property, deviceProperty);
		
		int j=0;
		
		//ポーリングの結果 retのなかからOIDで始まるものを抽出し、
		//その値を放り込んでいく
		
		/*	Iterator itr = ret.keySet().iterator();
		 while(itr.hasNext()){
		 String fullOid = (String)itr.next();
		 
		 if(fullOid.startsWith(OID_DEV_INDEX)){//デバイス情報で始まるか判定
		 
		 String tmpIndex =  ((String)ret.getValue(fullOid).getValue());
		 
		 if(j == 0){
		 //デバイス情報は1つもないときでもからの要素が１つあるので、そこに代入
		  propertyList = PropertyUtil.getProperty(deviceProperty, NodeProperty.DEVICE_NAME);
		  ((Property)propertyList.get(0)).setValue(((String)ret.getValue(OID_DEV_NAME+"."+tmpIndex).getValue()));
		  propertyList = PropertyUtil.getProperty(deviceProperty, NodeProperty.DEVICE_INDEX);
		  ((Property)propertyList.get(0)).setValue(Integer.parseInt(((String)ret.getValue(OID_DEV_INDEX+"."+tmpIndex).getValue())));
		  
		  propertyList = PropertyUtil.getProperty(deviceProperty, NodeProperty.DEVICE_TYPE);
		  ((Property)propertyList.get(0)).setValue(convDevice((String)ret.getValue(OID_DEV_TYPE+"."+tmpIndex).getValue()));
		  
		  }
		  else{
		  //2つめ以降はコピーをした状況からスタート
		   Property copy = PropertyUtil.copy(deviceProperty);
		   //�ǥХ���̾
		    propertyList = PropertyUtil.getProperty(copy, NodeProperty.DEVICE_NAME);
		    ((Property)propertyList.get(0)).setValue(((String)ret.getValue(OID_DEV_NAME+"."+tmpIndex).getValue()));
		    //�ǥХ���INDEX
		     propertyList = PropertyUtil.getProperty(copy, NodeProperty.DEVICE_INDEX);
		     ((Property)propertyList.get(0)).setValue(Integer.parseInt(((String)ret.getValue(OID_DEV_INDEX+"."+tmpIndex).getValue())));
		     //�ǥХ�������OID_DEV_TYPE+"."+i
		      propertyList = PropertyUtil.getProperty(copy, NodeProperty.DEVICE_TYPE);
		      ((Property)propertyList.get(0)).setValue(convDevice(((String)ret.getValue(OID_DEV_TYPE+"."+tmpIndex).getValue())));				
		      //��Ȥ�property��­������
		       property.addChildren(copy, index + j);
		       
		       }
		       j++;
		       }
		       }
		       */
//		Diskの情報を設定
		int i = 1;	
		while(true){
			
			// OID_DISK_INDEX=".1.3.6.1.4.1.2021.13.15.1.1.1";
			// OID_DISK_NAME =".1.3.6.1.4.1.2021.13.15.1.1.2";
			String oidCounter = OID_DISK_INDEX+"."+i;
			
			if( ret.getValue(oidCounter) != null){
				if(((String)ret.getValue(oidCounter).getValue()).length() != 0 ){
					String disk = (String)ret.getValue(OID_DISK_NAME+"."+i).getValue();
					
					//ramディスクは除外します。
					if(!(disk.startsWith("ram"))){
						if(j == 0){
							
							deviceProperty.setValue((String)ret.getValue(OID_DISK_NAME+"."+i).getValue());
							
							propertyList = PropertyUtil.getProperty(deviceProperty, NodeProperty.DEVICE_NAME);
							((Property)propertyList.get(0)).setValue(((String)ret.getValue(OID_DISK_NAME+"."+i).getValue()));
							//�ǥХ���INDEX
							propertyList = PropertyUtil.getProperty(deviceProperty, NodeProperty.DEVICE_INDEX);
							((Property)propertyList.get(0)).setValue(Integer.parseInt(((String)ret.getValue(OID_DISK_INDEX+"."+i).getValue())));
							//�ǥХ�������
							propertyList = PropertyUtil.getProperty(deviceProperty, NodeProperty.DEVICE_TYPE);
							((Property)propertyList.get(0)).setValue("disk");
							
							
						}
						else{
//							2つめ以降はコピーをした状況からスタート
							
							Property copy = PropertyUtil.copy(deviceProperty);
							
							copy.setValue((String)ret.getValue(OID_DISK_NAME+"."+i).getValue());
							//�ǥХ���̾
							propertyList = PropertyUtil.getProperty(copy, NodeProperty.DEVICE_NAME);
							((Property)propertyList.get(0)).setValue(((String)ret.getValue(OID_DISK_NAME+"."+i).getValue()));
							//�ǥХ���INDEX
							propertyList = PropertyUtil.getProperty(copy, NodeProperty.DEVICE_INDEX);
							((Property)propertyList.get(0)).setValue(Integer.parseInt(((String)ret.getValue(OID_DISK_INDEX+"."+i).getValue())));
							//�ǥХ�������
							propertyList = PropertyUtil.getProperty(copy, NodeProperty.DEVICE_TYPE);
							((Property)propertyList.get(0)).setValue("disk");
							
							//��Ȥ�property��­������
							property.addChildren(copy, index + j);
							
						}
						j++;
					}
					i++;
					
				}else{break;}
			}else{break;}
		}

		
		//NICのインデックスがWindowsの場合には連続ではないので、
		//とってきたすべての値からNICの情報を検索します。
		
         Iterator itr = ret.keySet().iterator();
		 while(itr.hasNext()){
		 String fullOid = (String)itr.next();
		 
			//OID_NIC_INDEX =".1.3.6.1.2.1.2.2.1.1";
			//OID_NIC_NAME  =".1.3.6.1.2.1.2.2.1.2";
		 
		 if(fullOid.startsWith(OID_NIC_INDEX)){//NIC情報で始まるか判定
				 
			 String tmpIndex = fullOid.substring(fullOid.lastIndexOf("."));
	
			 if( ((String)ret.getValue(fullOid).getValue()).length() != 0 ){
					if(j == 0){
						
						if(isWindows){
							//Windows文字化け対策			
							deviceProperty.setValue(convString((String)ret.getValue(OID_NIC_NAME+tmpIndex).getValue()));
							
							propertyList = PropertyUtil.getProperty(deviceProperty, NodeProperty.DEVICE_NAME);
							((Property)propertyList.get(0)).setValue(convString((String)ret.getValue(OID_NIC_NAME+tmpIndex).getValue()));
						}else{
							deviceProperty.setValue((String)ret.getValue(OID_NIC_NAME+tmpIndex).getValue());
							
							propertyList = PropertyUtil.getProperty(deviceProperty, NodeProperty.DEVICE_NAME);
							((Property)propertyList.get(0)).setValue(((String)ret.getValue(OID_NIC_NAME+tmpIndex).getValue()));
						}
						
						//�ǥХ���INDEX
						propertyList = PropertyUtil.getProperty(deviceProperty, NodeProperty.DEVICE_INDEX);
						((Property)propertyList.get(0)).setValue(Integer.parseInt(((String)ret.getValue(OID_NIC_INDEX+tmpIndex).getValue())));
						//�ǥХ�������
						propertyList = PropertyUtil.getProperty(deviceProperty, NodeProperty.DEVICE_TYPE);
						((Property)propertyList.get(0)).setValue("nic");		
					}
					else{
						
						Property copy = PropertyUtil.copy(deviceProperty);
						
						
						if(isWindows){
							//Windows文字化け対策			
							copy.setValue(convString((String)ret.getValue(OID_NIC_NAME+tmpIndex).getValue()));
							
							propertyList = PropertyUtil.getProperty(copy, NodeProperty.DEVICE_NAME);
							((Property)propertyList.get(0)).setValue(convString((String)ret.getValue(OID_NIC_NAME+tmpIndex).getValue()));
						}else{
							deviceProperty.setValue((String)ret.getValue(OID_NIC_NAME+tmpIndex).getValue());
							
							propertyList = PropertyUtil.getProperty(copy, NodeProperty.DEVICE_NAME);
							((Property)propertyList.get(0)).setValue(((String)ret.getValue(OID_NIC_NAME+tmpIndex).getValue()));
						}
						//�ǥХ���INDEX
						propertyList = PropertyUtil.getProperty(copy, NodeProperty.DEVICE_INDEX);
						((Property)propertyList.get(0)).setValue(Integer.parseInt(((String)ret.getValue(OID_NIC_INDEX+tmpIndex).getValue())));
						//�ǥХ�������
						propertyList = PropertyUtil.getProperty(copy, NodeProperty.DEVICE_TYPE);
						((Property)propertyList.get(0)).setValue("nic");
						
						//��Ȥ�property��­������
						property.addChildren(copy, index + j);
						
					}
					j++;	
				}
			}
		}
		
		//ファイルシステム
		propertyList = PropertyUtil.getProperty(property, NodeProperty.FILE_SYSTEM);
		Property fileSystemProperty = (Property)propertyList.get(0);
		index = PropertyUtil.getPropertyIndex(property, fileSystemProperty);
		
		i=1;	
		j=0;
		
		while(true){
			// OID_FILESYSTEM_INDEX = ".1.3.6.1.2.1.25.2.3.1.1";
			// OID_FILESYSTEM_NAME  = ".1.3.6.1.2.1.25.2.3.1.3";
			String oidCounter = OID_FILESYSTEM_INDEX+"."+i;
			
			if( ret.getValue(oidCounter) != null){
				if( ((String)ret.getValue(oidCounter).getValue()).length() != 0 ){
					
					//hrStrageFixedDiskの場合のみノード情報に追加
					//.1.3.6.1.2.1.25.2.1.4←hrStrageFixedDisk
					
					String strageType =  ret.getValue(OID_FILESYSTEM_TYPE+"."+i).getValue().toString();
				
					if(strageType.equals(".1.3.6.1.2.1.25.2.1.4")){
				
						if(j == 0){
														
							//ファイルシステムと書いてあるところにマウントポイントを表示
							fileSystemProperty.setValue((String)ret.getValue(OID_FILESYSTEM_NAME+"."+i).getValue());
							
							propertyList = PropertyUtil.getProperty(fileSystemProperty, NodeProperty.FILE_SYSTEM_MOUNT_POINT);
							
							((Property)propertyList.get(0)).setValue( ((String)ret.getValue(OID_FILESYSTEM_NAME+"."+i).getValue()));
							//�ǥХ���INDEX
							propertyList = PropertyUtil.getProperty(fileSystemProperty, NodeProperty.FILE_SYSTEM_INDEX);
							((Property)propertyList.get(0)).setValue(Integer.parseInt(((String)ret.getValue(OID_FILESYSTEM_INDEX+"."+i).getValue())));
							
						}
						else{
							
							Property copy = PropertyUtil.copy(fileSystemProperty);
							
							//ファイルシステムと書いてあるところにマウントポイントを表示
							copy.setValue((String)ret.getValue(OID_FILESYSTEM_NAME+"."+i).getValue());
							
							//�ǥХ���̾
							propertyList = PropertyUtil.getProperty(copy, NodeProperty.FILE_SYSTEM_MOUNT_POINT);
							((Property)propertyList.get(0)).setValue(((String)ret.getValue(OID_FILESYSTEM_NAME+"."+i).getValue()));
							//�ǥХ���INDEX
							propertyList = PropertyUtil.getProperty(copy, NodeProperty.FILE_SYSTEM_INDEX);
							((Property)propertyList.get(0)).setValue(Integer.parseInt(((String)ret.getValue(OID_FILESYSTEM_INDEX+"."+i).getValue())));
							
							//��Ȥ�property��­������
							property.addChildren(copy, index + j);
							
						}
						j++;
						
					}
					i++;
					
				}else{break;}
			}else{break;}
		}
		
		return property;
	}
	
	
	/**
	 * OIDとデバイスの名前を変換します。
	 * このメソッドは現在(ver2.3.0)のバージョンでは使用しません。
	 * @param deviceOID
	 * @return
	 */
	private static String convDevice(String deviceOID){
		String ret = null;
		
		if(deviceOID.equals(".1.3.6.1.2.1.25.3.1.1")){
			ret = "Other";
		}else if (deviceOID.equals(".1.3.6.1.2.1.25.3.1.2")){
			ret = "Unknown";
		}else if (deviceOID.equals(".1.3.6.1.2.1.25.3.1.3")){
			ret = "Processor";
		}else if (deviceOID.equals(".1.3.6.1.2.1.25.3.1.4")){
			ret = "Network";
		}else if (deviceOID.equals(".1.3.6.1.2.1.25.3.1.5")){
			ret = "Printer";
		}else if (deviceOID.equals(".1.3.6.1.2.1.25.3.1.6")){
			ret = "DiskStorage";
		}else if (deviceOID.equals(".1.3.6.1.2.1.25.3.1.10")){
			ret = "Video";
		}else if (deviceOID.equals(".1.3.6.1.2.1.25.3.1.11")){
			ret = "Audio";
		}else if (deviceOID.equals(".1.3.6.1.2.1.25.3.1.12")){
			ret = "Coprocessor";
		}else if (deviceOID.equals(".1.3.6.1.2.1.25.3.1.13")){
			ret = "Keyboard";
		}else if (deviceOID.equals(".1.3.6.1.2.1.25.3.1.14")){
			ret = "Modem";
		}else if (deviceOID.equals(".1.3.6.1.2.1.25.3.1.15")){
			ret = "ParallelPor";
		}else if (deviceOID.equals(".1.3.6.1.2.1.25.3.1.16")){
			ret = "Pointing";
		}else if (deviceOID.equals(".1.3.6.1.2.1.25.3.1.17")){
			ret = "SerialPort";
		}else if (deviceOID.equals(".1.3.6.1.2.1.25.3.1.18")){
			ret = "Tape";
		}else if (deviceOID.equals(".1.3.6.1.2.1.25.3.1.19")){
			ret = "Clock";
		}else if (deviceOID.equals(".1.3.6.1.2.1.25.3.1.20")){
			ret = "VolatileMemory";
		}else if (deviceOID.equals(".1.3.6.1.2.1.25.3.1.21")){
			ret = "NonVolatileMemory ";
		}else{
			ret = "Unknow"; 
		}
		return ret;
		
	}
	
	private static String convString(String str){
		
		//strはなぜかASCIIが16進で入っている。
		
		char[] chars;
		short  first;
		short second;
		chars=str.toCharArray();
//		char ret[] = new char[chars.length/3 + 1]; 
		
		StringBuffer ret = new StringBuffer();
		
		int j=0;
		for(int i = 0; i<chars.length;){
			
			
			first  = (short) (chars[i] - 48); //48は"0"なので、"1"→1の変換	
			second = (short)(chars[i+1]- 48);
			
			if(second >10){
				//16進でA-Fの場合には、さらに7を引く
				//10 ⇔ A(16進)なので("A"→65)を10にする、 10 = "A"(65) - "0"(48) - 7
				second -=7;
			}
			

//			ret[j] = (char) (first*16+second);
			ret.append((char) (first*16+second));
			
			i+=3;//1文字は"56 "とかで構成するので、配列2つを読んで" "をスキップ
			j++;//リターンも文字もインクリメント
		}
				
//		return (new String(ret));
		// 変換後の文字列の最終文字がnullであるため、それを除外
		return (ret.substring(0, ret.length()-1).toString());
		
		
	}
}
