/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.bean;

import java.io.Serializable;

/**
 * ジョブ通知情報クラス
 * ジョブの通知に関する情報を格納するクラスです。
 * 
 * @version 2.0.0
 * @since 1.0.0
 */
public class JobNotificationsInfo implements Serializable, Cloneable{
	/** シリアライズ可能クラスに定義するUID */
	private static final long serialVersionUID = 3052367114166008592L;
	
	/** 終了状態 */
	protected int m_type;
	
	/** 重要度 */
	protected int m_priority;
	
	/** 通知ID */
	protected String m_notify_id;
	
	/**
	 * 重要度を返す
	 * @return 重要度
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public int getPriority() {
		return m_priority;
	}
	
	/**
	 * 重要度を設定する
	 * @param priority 重要度
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public void setPriority(int priority) {
		this.m_priority = priority;
	}
	
	/**
	 * 通知IDを返す
	 * @return 通知ID
	 */
	public String getNotify_id() {
		return m_notify_id;
	}
	
	/**
	 * 通知IDを設定する
	 * @param notify_id 通知ID
	 */
	public void setNotify_id(String notify_id) {
		this.m_notify_id = notify_id;
	}
	
	/**
	 * 終了状態を返す
	 * @return 終了状態
	 * @see com.clustercontrol.bean.EndStatusConstant
	 */
	public int getType() {
		return m_type;
	}
	
	/**
	 * 終了状態を設定する
	 * @param type 終了状態
	 * @see com.clustercontrol.bean.EndStatusConstant
	 */
	public void setType(int type) {
		this.m_type = type;
	}
	
	/**
	 * ジョブ通知情報のクローンを作成する
	 * 
	 * @see java.lang.Object#clone()
	 */
	protected Object clone() {
		try {
			JobNotificationsInfo clone = (JobNotificationsInfo)super.clone();
			
			clone.setNotify_id(this.getNotify_id());
			clone.setPriority(this.getPriority());
			clone.setType(this.getType());
			
			return clone;
		} catch (CloneNotSupportedException e) {
			return null;
		}
	}
}