/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;

/**
 * ジョブ情報クラス
 * ジョブの基本情報を格納するクラスです。
 * 
 * @version 2.0.0
 * @since 1.0.0
 */
public class JobInfo implements Serializable, Cloneable {
	
	/** シリアライズ可能クラスに定義するUID */
	private static final long serialVersionUID = -1710299199569960870L;
	
	/** ジョブID */
	protected String m_id;
	
	/** ジョブ名 */
	protected String m_name;
	
	/** ジョブ種別 */
	protected int m_type;
	
	/** ジョブ待ち条件情報 */
	protected JobWaitRuleInfo m_waitRule;
	
	/** ジョブコマンド情報 */
	protected JobCommandInfo m_command;
	
	/** ジョブファイル転送情報 */
	protected JobFileInfo m_file;
	
	/** ジョブ終了状態情報 */
	protected ArrayList m_endStatus;
	
	/** ジョブ通知情報 */
	protected ArrayList m_notifications;
	
	/** ジョブ変数情報 */
	protected ArrayList m_param;
	
	/** 作成日時 */
	protected Date m_createTime;
	
	/** 最終更新日時 */
	protected Date m_updateTime;
	
	/** 新規作成ユーザ */
	protected String m_createUser;
	
	/** 最終更新ユーザ */
	protected String m_updateUser;
	
	/** 説明 */
	protected String m_description;
	
	/** 更新フラグ */
	protected boolean m_update;

	/**
	 * コンストラクタ
	 * 
	 * @param id ジョブID
	 * @param name ジョブ名
	 * @param type ジョブ種別
	 * @see com.clustercontrol.bean.JobConstant
	 */
	public JobInfo(String id, String name, int type) {
		setId(id);
		setName(name);
		setType(type);
	}
	
	/**
	 * ジョブ終了状態情報を返す
	 * 
	 * @return ジョブ終了状態情報のリスト
	 * @see com.clustercontrol.jobmanagement.bean.JobEndStatusInfo
	 */
	public ArrayList getEndStatus() {
		return m_endStatus;
	}
	
	/**
	 * ジョブ終了状態情報を設定する
	 * 
	 * @param endStatus ジョブ終了状態情報のリスト
	 * @see com.clustercontrol.jobmanagement.bean.JobEndStatusInfo
	 */
	public void setEndStatus(ArrayList endStatus) {
		this.m_endStatus = endStatus;
	}
	
	/**
	 * ジョブコマンド情報を返す
	 * 
	 * @return ジョブコマンド情報
	 * @see com.clustercontrol.jobmanagement.bean.JobCommandInfo
	 */
	public JobCommandInfo getCommand() {
		return m_command;
	}
	
	/**
	 * ジョブコマンド情報を設定する
	 * 
	 * @param command ジョブコマンド情報
	 * @see com.clustercontrol.jobmanagement.bean.JobCommandInfo
	 */
	public void setCommand(JobCommandInfo command) {
		this.m_command = command;
	}
	
	/**
	 * ジョブファイル転送情報を返す
	 * 
	 * @return ジョブファイル転送情報
	 * @see com.clustercontrol.jobmanagement.bean.JobFileInfo
	 */
	public JobFileInfo getFile() {
		return m_file;
	}
	
	/**
	 * ジョブファイル転送情報を設定する
	 * 
	 * @param file ジョブファイル転送情報
	 * @see com.clustercontrol.jobmanagement.bean.JobFileInfo
	 */
	public void setFile(JobFileInfo file) {
		this.m_file = file;
	}
	
	/**
	 * ジョブIDを返す
	 * 
	 * @return ジョブID
	 */
	public String getId() {
		return m_id;
	}
	
	/**
	 * ジョブIDを設定する
	 * 
	 * @param id ジョブID
	 */
	public void setId(String id) {
		this.m_id = id;
	}
	
	/**
	 * ジョブ通知情報を返す
	 * 
	 * @return ジョブ通知情報のリスト
	 * @see com.clustercontrol.jobmanagement.bean.JobNotificationsInfo
	 */
	public ArrayList getNotifications() {
		return m_notifications;
	}
	
	/**
	 * ジョブ通知情報を設定する
	 * 
	 * @param notifications ジョブ通知情報
	 * @see com.clustercontrol.jobmanagement.bean.JobNotificationsInfo
	 */
	public void setNotifications(ArrayList notifications) {
		this.m_notifications = notifications;
	}
	
	/**
	 * ジョブ変数情報を返す
	 * 
	 * @return ジョブ変数情報
	 * @see com.clustercontrol.jobmanagement.bean.JobParameterInfo
	 */
	public ArrayList getParam() {
		return m_param;
	}
	
	/**
	 * ジョブ変数情報を設定する
	 * 
	 * @param param ジョブ変数情報
	 * @see com.clustercontrol.jobmanagement.bean.JobParameterInfo
	 */
	public void setParam(ArrayList param) {
		this.m_param = param;
	}
	
	/**
	 * ジョブ名を返す
	 * 
	 * @return ジョブ名
	 */
	public String getName() {
		return m_name;
	}
	
	/**
	 * ジョブ名を設定する
	 * 
	 * @param name ジョブ名
	 */
	public void setName(String name) {
		this.m_name = name;
	}
	
	/**
	 * ジョブ待ち条件情報を返す
	 * 
	 * @return ジョブ待ち条件情報
	 * @see com.clustercontrol.jobmanagement.bean.JobWaitRuleInfo
	 */
	public JobWaitRuleInfo getWaitRule() {
		return m_waitRule;
	}
	
	/**
	 * ジョブ待ち条件情報を設定する
	 * 
	 * @param waitRule ジョブ待ち条件情報
	 * @see com.clustercontrol.jobmanagement.bean.JobWaitRuleInfo
	 */
	public void setWaitRule(JobWaitRuleInfo waitRule) {
		this.m_waitRule = waitRule;
	}
	
	/**
	 * ジョブ種別を返す
	 * 
	 * @return ジョブ種別
	 * @see com.clustercontrol.bean.JobConstant
	 */
	public int getType() {
		return m_type;
	}
	
	/**
	 * ジョブ種別を設定する
	 * 
	 * @param type ジョブ種別
	 * @see com.clustercontrol.bean.JobConstant
	 */
	public void setType(int type) {
		this.m_type = type;
	}
	
	/**
	 * 作成日時を返す
	 * @return 作成日時
	 */
	public Date getCreateTime() {
		return m_createTime;
	}
	
	/**
	 * 作成日時を設定する
	 * @param createTime 作成日時
	 */
	public void setCreateTime(Date createTime) {
		this.m_createTime = createTime;
	}
	
	/**
	 * 最終更新日時を返す
	 * @return 最終更新日時
	 */
	public Date getUpdateTime() {
		return m_updateTime;
	}
	
	/**
	 * 最終更新日時を設定する
	 * @param updateTime 最終更新日時
	 */
	public void setUpdateTime(Date updateTime) {
		this.m_updateTime = updateTime;
	}
	
	/**
	 * 新規作成ユーザを返す
	 * @return 新規作成ユーザ
	 */
	public String getCreateUser() {
		return m_createUser;
	}
	
	/**
	 * 新規作成ユーザを設定する
	 * @param createUser 新規作成ユーザ
	 */
	public void setCreateUser(String createUser) {
		this.m_createUser = createUser;
	}
	
	/**
	 * 最終更新ユーザを返す
	 * @return 最終更新ユーザ
	 */
	public String getUpdateUser() {
		return m_updateUser;
	}
	
	/**
	 * 最終更新ユーザを設定する
	 * @param updateUser 最終更新ユーザ
	 */
	public void setUpdateUser(String updateUser) {
		this.m_updateUser = updateUser;
	}
	
	/**
	 * 説明を返す
	 * @return 説明
	 */
	public String getDescription() {
		return m_description;
	}
	
	/**
	 * 説明を設定する
	 * @param description 説明
	 */
	public void setDescription(String description) {
		this.m_description = description;
	}
	
	/**
	 * 更新フラグを返す
	 * @return 更新フラグ
	 */
	public boolean isUpdate() {
		return m_update;
	}
	
	/**
	 * 更新フラグを設定する
	 * @param update 更新フラグ
	 */
	public void setUpdate(boolean update) {
		this.m_update = update;
	}
	
	/**
	 * ジョブ情報のクローンを作成する
	 * 
	 * @see java.lang.Object#clone()
	 */
	@SuppressWarnings("unchecked")
	protected Object clone() {
		try {
			JobInfo clone = (JobInfo)super.clone();
			
			if(this.getCommand() instanceof JobCommandInfo)
				clone.setCommand((JobCommandInfo)this.getCommand().clone());
			if(this.getFile() instanceof JobFileInfo)
				clone.setFile((JobFileInfo)this.getFile().clone());
			if(this.getCreateTime() instanceof Date)
				clone.setCreateTime((Date)this.getCreateTime().clone());
			clone.setDescription(this.getDescription());
			clone.setId(this.getId());
			clone.setName(this.getName());
			clone.setType(this.getType());
			clone.setUpdate(this.isUpdate());
			if(this.getUpdateTime() instanceof Date)
				clone.setUpdateTime((Date)this.getUpdateTime().clone());
			if(this.getWaitRule() instanceof JobWaitRuleInfo)
				clone.setWaitRule((JobWaitRuleInfo)this.getWaitRule().clone());
			
			ArrayList cloneList = new ArrayList();
			if(this.getEndStatus() != null && this.getEndStatus() instanceof ArrayList){
				for(int i = 0; i < this.getEndStatus().size(); i++){
					Object source = this.getEndStatus().get(i);
					if(source != null && source instanceof JobEndStatusInfo){
						cloneList.add(((JobEndStatusInfo)source).clone());
					}
				}
			}
			clone.setEndStatus(cloneList);
			
			cloneList = new ArrayList();
			if(this.getNotifications() != null && this.getNotifications() instanceof ArrayList){
				for(int i = 0; i < this.getNotifications().size(); i++){
					Object source = this.getNotifications().get(i);
					if(source != null && source instanceof JobNotificationsInfo){
						cloneList.add(((JobNotificationsInfo)source).clone());
					}
				}
			}
			clone.setNotifications(cloneList);
			
			cloneList = new ArrayList();
			if(this.getParam() != null && this.getParam() instanceof ArrayList){
				for(int i = 0; i < this.getParam().size(); i++){
					Object source = this.getParam().get(i);
					if(source != null && source instanceof JobParameterInfo){
						cloneList.add(((JobParameterInfo)source).clone());
					}
				}
			}
			clone.setParam(cloneList);
			
			return clone;
		} catch (CloneNotSupportedException e) {
			return null;
		}
	}
}