/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.bean;

import java.io.Serializable;

/**
 * ジョブ終了状態情報クラス
 * ジョブの終了状態に関する情報を格納するクラスです。
 * 
 * @version 2.0.0
 * @since 1.0.0
 */
public class JobEndStatusInfo implements Serializable, Cloneable {
	/** シリアライズ可能クラスに定義するUID */
	private static final long serialVersionUID = 5256607875379422805L;

	/** 終了状態の種別 */
    protected int m_type;

    /** 終了状態の終了値 */
    protected int m_value;

    /** 終了値範囲(開始) */
    protected int m_startRangeValue;

    /** 終了値範囲(終了) */
    protected int m_endRangeValue;

    /**
     * 終了値範囲(終了)を返す
     * @return 終了値範囲(終了)
     */
    public int getEndRangeValue() {
        return m_endRangeValue;
    }

    /**
     * 終了値範囲(終了)を設定する
     * @param endRangeValue 終了値範囲(終了)
     */
    public void setEndRangeValue(int endRangeValue) {
        this.m_endRangeValue = endRangeValue;
    }

    /**
     * 終了値範囲(開始)を返す
     * @return 終了値範囲(開始)
     */
    public int getStartRangeValue() {
        return m_startRangeValue;
    }

    /**
     * 終了値範囲(開始)を設定する
     * @param startRangeValue 終了値範囲(開始)
     */
    public void setStartRangeValue(int startRangeValue) {
        this.m_startRangeValue = startRangeValue;
    }

    /**
     * 終了状態の種別を返す
     * @return 終了状態の種別
     * @see com.clustercontrol.bean.EndStatusConstant
     */
    public int getType() {
        return m_type;
    }

    /**
     * 終了状態の種別を設定する
     * @param type 終了状態の種別
     * @see com.clustercontrol.bean.EndStatusConstant
     */
    public void setType(int type) {
        this.m_type = type;
    }

    /**
     * 終了状態の終了値を返す
     * @return 終了状態の終了値
     */
    public int getValue() {
        return m_value;
    }

    /**
     * 終了状態の終了値を設定する
     * @param value 終了状態の終了値
     */
    public void setValue(int value) {
        this.m_value = value;
    }
    
	/**
	 * ジョブ終了状態情報のクローンを作成する
	 * 
	 * @see java.lang.Object#clone()
	 */
    protected Object clone() {
        try {
            JobEndStatusInfo clone = (JobEndStatusInfo)super.clone();
            
            clone.setEndRangeValue(this.getEndRangeValue());
            clone.setStartRangeValue(this.getStartRangeValue());
            clone.setType(this.getType());
            clone.setValue(this.getValue());
            
            return clone;
        } catch (CloneNotSupportedException e) {
            return null;
        }
    }
}