/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.http.factory;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.http.util.ControlHttpInfo;
import com.clustercontrol.monitor.run.bean.MonitorCheckInfo;
import com.clustercontrol.monitor.run.factory.SelectMonitorStringValueType;

/**
 * HTTP監視情報 文字列監視用検索クラス
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class SelectMonitorHttpString extends SelectMonitorStringValueType{
	
	protected static Log m_log = LogFactory.getLog( SelectMonitorHttpString.class );
	
	/* (non-Javadoc)
	 * @see com.clustercontrol.monitor.run.factory.SelectMonitor#getCheckInfo()
	 */
	@Override
	public MonitorCheckInfo getCheckInfo() throws FinderException, NamingException{
		
		// HTTP監視情報を取得
		ControlHttpInfo http = new ControlHttpInfo(m_monitorId, m_monitorTypeId);
		return http.get();
	}
}
