/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.logtransfer.bean;

import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.bean.YesNoConstant;

/**
 * 転送対象ログファイル情報クラスです。
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class LogTransferFileInfo
extends Object
implements java.io.Serializable
{
	private static final long serialVersionUID = -4462375753518480224L;

	/** 転送設定ID */
	protected String m_transferId; 
	
	/** ログファイル名 */
	protected String m_filePath;
	
	/** 動作間隔（秒） */
	protected int m_runInterval;
	
	/** 最初にファイルをチェック */
	protected int m_existenceFlg = YesNoConstant.TYPE_YES;
	
	/** 有効/無効 */
	protected int m_valid = ValidConstant.TYPE_VALID;
	
	public LogTransferFileInfo() {
	}
	
	public LogTransferFileInfo(String id, String path, int interval, int existenceFlg, int valid) {
		m_transferId = id;
		m_filePath = path;
		m_runInterval = interval;
		m_existenceFlg = existenceFlg;
		m_valid = valid;
	}

	/**
	 * @return m_existenceFlg を戻します。
	 */
	public int getExistenceFlg() {
		return m_existenceFlg;
	}
	
	/**
	 * @param flg 設定する m_existenceFlg。
	 */
	public void setExistenceFlg(int flg) {
		m_existenceFlg = flg;
	}
	
	/**
	 * @return m_filePath を戻します。
	 */
	public String getFilePath() {
		return m_filePath;
	}
	
	/**
	 * @param path 設定する m_filePath。
	 */
	public void setFilePath(String path) {
		m_filePath = path;
	}
	
	/**
	 * @return m_runInterval を戻します。
	 */
	public int getRunInterval() {
		return m_runInterval;
	}
	
	/**
	 * @param interval 設定する m_runInterval。
	 */
	public void setRunInterval(int interval) {
		m_runInterval = interval;
	}
	
	/**
	 * @return m_transferId を戻します。
	 */
	public String getTransferId() {
		return m_transferId;
	}
	
	/**
	 * @param id 設定する m_transferId。
	 */
	public void setTransferId(String id) {
		m_transferId = id;
	}
	
	/**
	 * @return m_valid を戻します。
	 */
	public int getValid() {
		return m_valid;
	}
	
	/**
	 * @param valid 設定する m_valid。
	 */
	public void setValid(int valid) {
		this.m_valid = valid;
	}
}
