/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.composite;

import java.util.ArrayList;
import java.util.Date;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

/**
 * CommonTableViewerクラス用のViewerSorterクラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class CommonTableViewerSorter extends ViewerSorter {
	/** カラムインデックス */
	protected int m_columnIndex = 0;
	
	/** カラムインデックス */
	protected int m_columnIndex2 = 0;
	
	/** ソートオーダー */
	protected int m_order = 1;
	
	/**
	 * コンストラクタ
	 * 
	 * @param column
	 *            ソート対象カラムインデックス
	 * @since 1.0.0
	 */
	public CommonTableViewerSorter(int columnIndex) {
		this(columnIndex,-1,1);
	}
	
	/**
	 * コンストラクタ
	 * 
	 * @param column
	 *            ソート対象カラムインデックス
	 * @param columnIndex
	 */
	public CommonTableViewerSorter(int columnIndex,int columIndex2) {
		this(columnIndex, columIndex2,1);
	}
	/**
	 * コンストラクタ
	 * 
	 * @param column
	 *            ソート対象カラムインデックス
	 * @param order
	 *            ソートオーダー
	 * @since 1.0.0
	 */
	public CommonTableViewerSorter(int columnIndex, int columnIndex2, int order) {
		super();
		
		this.m_columnIndex = columnIndex;
		//セカンドソーターを必要としない場合には-1が入ってる。
		this.m_columnIndex2 = columnIndex2;
		
		//昇順・降順の設定　1: 昇順　-1:降順
		this.m_order = order;
	}
	
	/**
	 * 比較処理
	 * 
	 * @param viewer
	 * @param e1
	 * @param e2
	 * @return 比較結果。superクラスの結果をソートオーダーにより反転する
	 * @since 1.0.0
	 */
	public int compare(Viewer viewer, Object e1, Object e2) {
		if (e1 instanceof ArrayList && e2 instanceof ArrayList) {
			Object object1 = ((ArrayList) e1).get(m_columnIndex);
			Object object2 = ((ArrayList) e2).get(m_columnIndex);
			
			int rtn = 0;
			if (object1 != null && object2 != null
					&& object1.getClass() == Date.class
					&& object2.getClass() == Date.class) {
				rtn = ((Date) object1).compareTo((Date) object2);
				
			} else if (object1 != null && object2 != null
					&& object1.getClass() == Integer.class
					&& object2.getClass() == Integer.class)
			{
				//Intergerの場合には、compareではなく値の大小を比較する。
				// 2と10だと2を前にする。
				rtn =  ((Integer)object1).intValue() - ((Integer)object2).intValue();
			}else{
				rtn = super.compare(viewer, object1, object2);
			}
			
			//第1ソートが等価で第２ソートが有効な場合には
			//第2ソートを行う。
			if( rtn == 0 && m_columnIndex2 >= 0){
				
				object1 = ((ArrayList) e1).get(m_columnIndex2);
				object2 = ((ArrayList) e2).get(m_columnIndex2);
				
				//上と同じ			
				if (object1 != null && object2 != null
						&& object1.getClass() == Date.class
						&& object2.getClass() == Date.class) {
					rtn = ((Date) object1).compareTo((Date) object2);
					
				} else if (object1.getClass() == Integer.class
						&& object2.getClass() == Integer.class)
				{
					//Intergerの場合には、compareではなく値の大小を比較する。
					// 2と10だと2を前にする。
					rtn =  ((Integer)object1).intValue() - ((Integer)object2).intValue();
				}else{
					rtn = super.compare(viewer, object1, object2);
					
				}
				
			}
			if (m_order == 1) {
				return rtn;
			} else {
				return 0 - rtn;
			}
		}
		return 0;	
	}
	
	/**
	 * ソート対象カラムインデックス取得
	 * 
	 * @return カラムインデックス
	 * @since 1.0.0
	 */
	public int getColumnIndex() {
		return this.m_columnIndex;
	}
}