/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.bean;

import com.clustercontrol.util.Messages;

/**
 * SNMPバージョンクラス
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class SnmpVersionConstant {
    /** v1 */
    public static final int TYPE_V1 = 0;

    /** v2c */
    public static final int TYPE_V2 = 1;

    /** v1（文字列） */
    public static final String STRING_V1 = Messages.getString("snmp.version.1");

    /** v2c（文字列） */
    public static final String STRING_V2 = Messages.getString("snmp.version.2");

    /**
     * 種別から文字列に変換する
     * 
     * @param type
     * @return
     */
    public static String typeToString(Integer type) {
        if (type == TYPE_V1) {
            return STRING_V1;
        } else if (type == TYPE_V2) {
            return STRING_V2;
        }
        return "";
    }

    /**
     * 文字列から種別に変換する
     * 
     * @param type
     * @return
     */
    public static Integer stringToType(String string) {
        if (string.equals(STRING_V1)) {
            return TYPE_V1;
        } else if (string.equals(STRING_V2)) {
            return TYPE_V2;
        }
        return -1;
    }
}