/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * プロパティシート用ツリーアイテムクラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class PropertyTreeItem implements Serializable {
    /**
	 * 
	 */
	private static final long serialVersionUID = 1796344516594486143L;

	/** 親プロパティ */
    protected PropertyTreeItem m_Parent;

    /** 子プロパティ */
    protected List m_Children = new ArrayList();

    /** プロパティID */
    protected String m_ID;

    /** プロパティ項目名 */
    protected String m_Name;

    /**
     * @return children を戻します。
     * @since 1.0.0
     */
    public Object[] getChildren() {
        return m_Children.toArray();
    }

    /**
     * @return children を戻します。
     * @since 1.0.0
     */
    public void removeChildren() {
        for (int i = 0; i < m_Children.size(); i++) {
            ((Property) m_Children.get(i)).setParent(null);
        }
        m_Children.removeAll(m_Children);
    }

    /**
     * @param child
     * @since 1.0.0
     */
    public void removeChildren(PropertyTreeItem child) {
        m_Children.remove(child);
    }

    /**
     * @param children
     *            children を設定。
     * @since 1.0.0
     */
    public void addChildren(PropertyTreeItem child) {
        m_Children.add(child);
        child.setParent(this);
    }

    /**
     * @param children
     *            children を設定。
     * @param index
     *            追加位置
     * @since 1.0.0
     */
    public void addChildren(PropertyTreeItem child, int index) {
        m_Children.add(index, child);
        child.setParent(this);
    }

    /**
     * @return iD を戻します。
     * @since 1.0.0
     */
    public String getID() {
        return m_ID;
    }

    /**
     * @param id
     *            iD を設定。
     * @since 1.0.0
     */
    public void setID(String id) {
        m_ID = id;
    }

    /**
     * @return name を戻します。
     * @since 1.0.0
     */
    public String getName() {
        return m_Name;
    }

    /**
     * @param name
     *            name を設定。
     * @since 1.0.0
     */
    public void setName(String name) {
        m_Name = name;
    }

    /**
     * @return parent を戻します。
     * @since 1.0.0
     */
    public PropertyTreeItem getParent() {
        return m_Parent;
    }

    /**
     * @param parent
     *            parent を設定。
     * @since 1.0.0
     */
    public void setParent(PropertyTreeItem parent) {
        m_Parent = parent;
    }

    /**
     * @param 子プロパティ数を戻します。
     * @since 1.0.0
     */
    public int size() {
        return m_Children.size();
    }
}