/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRCalculable;
import net.sf.jasperreports.engine.fill.JRIntegerIncrementerFactory;

class JRIntegerCountIncrementer
extends JRAbstractExtendedIncrementer {
    private static JRIntegerCountIncrementer mainInstance = new JRIntegerCountIncrementer();

    private JRIntegerCountIncrementer() {
    }

    public static JRIntegerCountIncrementer getInstance() {
        return mainInstance;
    }

    public Object increment(JRCalculable variable, Object expressionValue, AbstractValueProvider valueProvider) {
        Number value = (Number)variable.getIncrementedValue();
        if (value == null || variable.isInitialized()) {
            value = JRIntegerIncrementerFactory.ZERO;
        }
        if (expressionValue == null) {
            return value;
        }
        return new Integer(value.intValue() + 1);
    }

    public Object combine(JRCalculable calculable, JRCalculable calculableValue, AbstractValueProvider valueProvider) {
        Number value = (Number)calculable.getIncrementedValue();
        Number combineValue = (Number)calculableValue.getValue();
        if (value == null || calculable.isInitialized()) {
            value = JRIntegerIncrementerFactory.ZERO;
        }
        if (combineValue == null) {
            return value;
        }
        return new Integer(value.intValue() + combineValue.intValue());
    }

    public Object initialValue() {
        return JRIntegerIncrementerFactory.ZERO;
    }
}

