/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.geometric;

import java.io.Serializable;
import java.sql.SQLException;
import org.postgresforest.geometric.PGpoint;
import org.postgresforest.util.PGobject;
import org.postgresforest.util.PGtokenizer;
import org.postgresforest.util.PSQLException;
import org.postgresforest.util.PSQLState;

public class PGline
extends PGobject
implements Serializable,
Cloneable {
    public PGpoint[] point = new PGpoint[2];

    public PGline(double x1, double y1, double x2, double y2) {
        this(new PGpoint(x1, y1), new PGpoint(x2, y2));
    }

    public PGline(PGpoint p1, PGpoint p2) {
        this();
        this.point[0] = p1;
        this.point[1] = p2;
    }

    public PGline(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public PGline() {
        this.setType("line");
    }

    public void setValue(String s) throws SQLException {
        PGtokenizer t = new PGtokenizer(PGtokenizer.removeBox(s), ',');
        if (t.getSize() != 2) {
            throw new PSQLException("postgresql.geo.line", PSQLState.DATA_TYPE_MISMATCH, s);
        }
        this.point[0] = new PGpoint(t.getToken(0));
        this.point[1] = new PGpoint(t.getToken(1));
    }

    public boolean equals(Object obj) {
        if (obj instanceof PGline) {
            PGline p = (PGline)obj;
            return p.point[0].equals(this.point[0]) && p.point[1].equals(this.point[1]) || p.point[0].equals(this.point[1]) && p.point[1].equals(this.point[0]);
        }
        return false;
    }

    public Object clone() {
        return new PGline((PGpoint)this.point[0].clone(), (PGpoint)this.point[1].clone());
    }

    public String getValue() {
        return "[" + this.point[0] + "," + this.point[1] + "]";
    }
}

