/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.rmi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Map;
import org.jboss.remoting.CannotConnectException;
import org.jboss.remoting.ConnectionFailedException;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.RemoteClientInvoker;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.marshal.rmi.RMIMarshaller;
import org.jboss.remoting.transport.rmi.RMIServerInvokerInf;

public class RMIClientInvoker
extends RemoteClientInvoker {
    private RMIServerInvokerInf server;
    private boolean connected = false;

    public RMIClientInvoker(InvokerLocator locator) {
        super(locator);
    }

    private int getRegistryPort(InvokerLocator locator) {
        String value;
        int port = 3455;
        Map params = locator.getParameters();
        if (params != null && (value = (String)params.get("registryPort")) != null) {
            try {
                port = Integer.parseInt(value);
                this.log.debug("Using port " + port + " for rmi registry.");
            }
            catch (NumberFormatException e) {
                this.log.error("Can not set the RMIServerInvoker RMI registry to port " + value + ".  This is not a valid port number.");
            }
        }
        return port;
    }

    public void setServerStub(RMIServerInvokerInf server) {
        this.server = server;
        this.log.trace(this.server);
    }

    public RMIServerInvokerInf getServerStub() {
        return this.server;
    }

    protected void handleConnect() throws ConnectionFailedException {
        try {
            String host = this.locator.getHost();
            int port = this.getRegistryPort(this.locator);
            Registry regsitry = LocateRegistry.getRegistry(host, port);
            Remote remoteObj = regsitry.lookup("remoting/RMIServerInvoker/" + this.locator.getPort());
            this.log.debug("Remote RMI Stub: " + remoteObj);
            this.setServerStub((RMIServerInvokerInf)remoteObj);
            this.connected = true;
        }
        catch (Exception e) {
            this.connected = false;
            this.log.debug("Error connecting RMI invoker client.", e);
            throw new CannotConnectException("Error connecting RMI invoker client", e);
        }
    }

    protected void handleDisconnect() {
    }

    protected String getDefaultDataType() {
        return "rmi";
    }

    protected Object transport(String sessionId, Object invocation, Map metadata, Marshaller marshaller, UnMarshaller unmarshaller) throws IOException, ConnectionFailedException {
        if (this.server == null) {
            this.log.error("Server stub has not been set in RMI invoker client.  See previous errors for details.");
            throw new CannotConnectException("Server stub has not been set.");
        }
        try {
            Object payload = invocation;
            if (marshaller != null && !(marshaller instanceof RMIMarshaller)) {
                PipedOutputStream pos = new PipedOutputStream();
                PipedInputStream pis = new PipedInputStream();
                pos.connect(pis);
                marshaller.write(payload, pos);
                pos.flush();
                pos.write(new byte[0]);
                pos.flush();
                ObjectInputStream ois = new ObjectInputStream(pis);
                try {
                    pos.close();
                    payload = ois.readObject();
                    ois.close();
                }
                catch (ClassNotFoundException e) {
                    this.log.error("Could not marshall invocation payload object " + payload, e);
                    throw new IOException(e.getMessage());
                }
            }
            Object response = this.server.transport(payload);
            return response;
        }
        catch (RemoteException e) {
            throw new CannotConnectException("Error making invocation in RMI client invoker.", e);
        }
    }
}

