/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.http;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpParser;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.marshal.MarshalFactory;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.transport.web.WebServerInvoker;
import org.jboss.util.threadpool.BasicThreadPool;
import org.jboss.util.threadpool.BlockingMode;
import org.jboss.util.threadpool.ThreadPool;
import org.jboss.util.threadpool.ThreadPoolMBean;

public class HTTPServerInvoker
extends WebServerInvoker
implements Runnable {
    public static final String MAX_NUM_HTTP_THREADS_KEY = "maxNumThreadsHTTP";
    public static final String HTTP_THREAD_POOL_CLASS_KEY = "HTTPThreadPool";
    private String httpThreadPoolClass = null;
    private static int BACKLOG_DEFAULT = 1000;
    private static int MAX_POOL_SIZE_DEFAULT = 100;
    private ServerSocket serverSocket = null;
    private boolean running = false;
    private ThreadPool httpThreadPool;
    private int maxPoolSize = MAX_POOL_SIZE_DEFAULT;
    protected int backlog = BACKLOG_DEFAULT;
    public static String HTML = "text/html";
    public static String PLAIN = "text/plain";
    public static String SOAP = "application/soap+xml";
    static /* synthetic */ Class class$org$jboss$util$threadpool$ThreadPoolMBean;

    public HTTPServerInvoker(InvokerLocator locator) {
        super(locator);
    }

    public HTTPServerInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
    }

    protected String getDefaultDataType() {
        return "serializable";
    }

    protected void setup() throws Exception {
        super.setup();
        Map config = this.getConfiguration();
        String maxNumOfThreads = (String)config.get(MAX_NUM_HTTP_THREADS_KEY);
        if (maxNumOfThreads != null && maxNumOfThreads.length() > 0) {
            try {
                this.maxPoolSize = Integer.parseInt(maxNumOfThreads);
            }
            catch (NumberFormatException e) {
                this.log.error("Can not convert max number of threads value (" + maxNumOfThreads + ") into a number.");
            }
        }
        this.httpThreadPoolClass = (String)config.get(HTTP_THREAD_POOL_CLASS_KEY);
    }

    public void setMaxNumberOfHTTPThreads(int numOfThreads) {
        this.maxPoolSize = numOfThreads;
    }

    public int getMaxNumberOfHTTPThreads() {
        return this.maxPoolSize;
    }

    public ThreadPool getHTTPThreadPool() {
        if (this.httpThreadPool == null) {
            if (this.httpThreadPoolClass == null || this.httpThreadPoolClass.length() == 0) {
                BasicThreadPool basicthreadpool = new BasicThreadPool("JBossRemoting - HTTP Server Invoker");
                basicthreadpool.setBlockingMode(BlockingMode.RUN);
                basicthreadpool.setMaximumPoolSize(this.maxPoolSize);
                this.httpThreadPool = basicthreadpool;
            } else {
                boolean isObjName = false;
                try {
                    ObjectName objName = new ObjectName(this.httpThreadPoolClass);
                    this.httpThreadPool = this.createThreadPoolProxy(objName);
                    isObjName = true;
                }
                catch (MalformedObjectNameException e) {
                    this.log.debug("Thread pool class supplied is not an object name.");
                }
                if (!isObjName) {
                    try {
                        this.httpThreadPool = (ThreadPool)this.getClassLoader().loadClass(this.httpThreadPoolClass).newInstance();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error loading instance of ThreadPool based on class name: " + this.httpThreadPoolClass);
                    }
                }
            }
        }
        return this.httpThreadPool;
    }

    private ThreadPool createThreadPoolProxy(ObjectName objName) {
        MBeanServer server = this.getMBeanServer();
        if (server == null) {
            throw new RuntimeException("Can not register MBean ThreadPool as the ServerInvoker has not been registered with a MBeanServer.");
        }
        ThreadPoolMBean poolMBean = (ThreadPoolMBean)MBeanServerInvocationHandler.newProxyInstance(server, objName, class$org$jboss$util$threadpool$ThreadPoolMBean == null ? (class$org$jboss$util$threadpool$ThreadPoolMBean = HTTPServerInvoker.class$("org.jboss.util.threadpool.ThreadPoolMBean")) : class$org$jboss$util$threadpool$ThreadPoolMBean, false);
        ThreadPool pool = poolMBean.getInstance();
        return pool;
    }

    public void setHTTPThreadPool(ThreadPool pool) {
        this.httpThreadPool = pool;
    }

    public void start() throws IOException {
        if (!this.running) {
            this.running = true;
            try {
                ThreadPool httpThreadPool = this.getHTTPThreadPool();
                InetAddress bindAddress = InetAddress.getByName(this.getServerBindAddress());
                this.serverSocket = this.createServerSocket(this.getServerBindPort(), this.backlog, bindAddress);
                for (int t = 0; t < this.maxPoolSize; ++t) {
                    httpThreadPool.run(this);
                }
            }
            catch (IOException e) {
                this.log.error("Error starting ServerSocket.  Bind port: " + this.getServerBindPort() + ", bind address: " + this.getServerBindAddress());
                throw e;
            }
        }
        super.start();
    }

    protected ServerSocket createServerSocket(int serverBindPort, int backlog, InetAddress bindAddress) throws IOException {
        return new ServerSocket(serverBindPort, backlog, bindAddress);
    }

    public void run() {
        block3: {
            try {
                Socket socket = this.serverSocket.accept();
                if (socket != null) {
                    this.httpThreadPool.run(this);
                    this.processRequest(socket);
                }
            }
            catch (Throwable thr) {
                if (!this.running) break block3;
                this.log.error("Error processing incoming request.", thr);
            }
        }
    }

    public void stop() {
        if (this.running) {
            this.running = false;
            this.maxPoolSize = 0;
            try {
                this.httpThreadPool.stop(false);
                this.httpThreadPool.waitForTasks(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            try {
                if (this.serverSocket != null && !this.serverSocket.isClosed()) {
                    this.serverSocket.close();
                }
                this.serverSocket = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.stop();
        this.log.debug("HTTPServerInvoker stopped.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void processRequest(Socket socket) {
        block38: {
            Exception e2222;
            FilterOutputStream dataOutput;
            FilterInputStream dataInput;
            block34: {
                block33: {
                    dataInput = null;
                    dataOutput = null;
                    FilterOutputStream bufferOutput = null;
                    Object response = null;
                    boolean isError = false;
                    String requestContentType = null;
                    try {
                        int ch;
                        dataInput = new DataInputStream(socket.getInputStream());
                        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                        while ((ch = dataInput.read()) >= 0) {
                            buffer.write(ch);
                            if (ch != 10) continue;
                        }
                        String methodType = null;
                        String path = null;
                        String httpVersion = null;
                        byte[] firstLineRaw = buffer.toByteArray();
                        if (firstLineRaw[firstLineRaw.length - 2] != 13) {
                            this.log.error("Error processing first line.  Should have ended in \r\n, but did not");
                            throw new RuntimeException("Error processing HTTP request type.  First line of request is invalid.");
                        }
                        String firstLine = new String(firstLineRaw).trim();
                        int startIndex = 0;
                        int endIndex = firstLine.indexOf(32);
                        methodType = firstLine.substring(startIndex, endIndex);
                        startIndex = endIndex + 1;
                        endIndex = firstLine.indexOf(32, startIndex);
                        path = firstLine.substring(startIndex, endIndex);
                        startIndex = endIndex + 1;
                        httpVersion = firstLine.substring(startIndex);
                        HashMap<String, String> metadata = new HashMap<String, String>();
                        Header[] headers = HttpParser.parseHeaders((InputStream)dataInput);
                        for (int x = 0; x < headers.length; ++x) {
                            String headerName = headers[x].getName();
                            String headerValue = headers[x].getValue();
                            metadata.put(headerName, headerValue);
                            if (!"Content-Type".equalsIgnoreCase(headerName)) continue;
                            requestContentType = headers[x].getValue();
                        }
                        UnMarshaller unmarshaller = MarshalFactory.getUnMarshaller("http");
                        Object obj = unmarshaller.read(dataInput, metadata);
                        InvocationRequest request = null;
                        request = obj instanceof InvocationRequest ? (InvocationRequest)obj : (this.isBinary(requestContentType) ? this.getInvocationRequest(metadata, obj) : this.createNewInvocationRequest(metadata, obj));
                        try {
                            response = this.invoke(request);
                        }
                        catch (Throwable ex) {
                            this.log.debug("Error thrown calling invoke on server invoker.", ex);
                            response = ex;
                            isError = true;
                        }
                        dataOutput = new DataOutputStream(socket.getOutputStream());
                        bufferOutput = new BufferedOutputStream(dataOutput, 1024);
                    }
                    catch (Throwable thr) {
                        this.log.debug("Error thrown processing request.  Probably error with processing headers.", thr);
                        response = thr instanceof Exception ? (Exception)thr : new Exception(thr);
                        isError = true;
                    }
                    if (bufferOutput != null) {
                        if (response == null) {
                            bufferOutput.write("HTTP/1.1 ".getBytes());
                            bufferOutput.write("200 JBoss Remoting: Request Processed Successfully".getBytes());
                            String contentType = "\r\nContent-Type: text/html";
                            bufferOutput.write(contentType.getBytes());
                            String contentLength = "\r\nContent-Length: 0";
                            bufferOutput.write(contentLength.getBytes());
                            ((BufferedOutputStream)bufferOutput).flush();
                        } else {
                            bufferOutput.write("HTTP/1.1 ".getBytes());
                            String status = isError ? "500 JBoss Remoting: Error occurred within target application." : "200 JBoss Remoting: Request Processed Succussfully";
                            bufferOutput.write(status.getBytes());
                            String contentType = "\r\nContent-Type: " + requestContentType;
                            bufferOutput.write(contentType.getBytes());
                            int iContentLength = this.getContentLength(response);
                            String contentLength = "\r\nContent-Length: " + iContentLength;
                            bufferOutput.write(contentLength.getBytes());
                            bufferOutput.write("\r\n\r\n".getBytes());
                            Marshaller marshaller = MarshalFactory.getMarshaller(this.getLocator(), this.getClass().getClassLoader());
                            if (marshaller == null) {
                                marshaller = MarshalFactory.getMarshaller("http");
                            }
                            marshaller.write(response, bufferOutput);
                        }
                        break block33;
                    }
                    if (isError) {
                        this.log.warn("Can not send error response due to output stream being null (due to previous error).");
                        break block33;
                    }
                    this.log.error("Can not send response due to output stream being null (even though there was not a previous error encountered).");
                }
                Object var21_27 = null;
                if (dataInput == null) break block34;
                try {
                    dataInput.close();
                }
                catch (Exception e2222) {
                    this.log.warn("Error closing resource.", e2222);
                }
            }
            if (dataOutput != null) {
                try {
                    dataOutput.close();
                }
                catch (Exception e2222) {
                    this.log.warn("Error closing resource.", e2222);
                }
            }
            try {
                socket.close();
            }
            catch (Exception e2222) {
                this.log.warn("Error closing resource.", e2222);
            }
            break block38;
            {
                catch (Exception e3) {
                    this.log.error("Error processing client request.", e3);
                    Object var21_28 = null;
                    if (dataInput != null) {
                        try {
                            dataInput.close();
                        }
                        catch (Exception e2222) {
                            this.log.warn("Error closing resource.", e2222);
                        }
                    }
                    if (dataOutput != null) {
                        try {
                            dataOutput.close();
                        }
                        catch (Exception e2222) {
                            this.log.warn("Error closing resource.", e2222);
                        }
                    }
                    try {
                        socket.close();
                    }
                    catch (Exception e2222) {
                        this.log.warn("Error closing resource.", e2222);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var21_29 = null;
                if (dataInput != null) {
                    try {
                        dataInput.close();
                    }
                    catch (Exception e2222) {
                        this.log.warn("Error closing resource.", e2222);
                    }
                }
                if (dataOutput != null) {
                    try {
                        dataOutput.close();
                    }
                    catch (Exception e2222) {
                        this.log.warn("Error closing resource.", e2222);
                    }
                }
                try {
                    socket.close();
                }
                catch (Exception e2222) {
                    this.log.warn("Error closing resource.", e2222);
                }
                throw throwable;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

