/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventExpose;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkFixed;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class Composite
extends Scrollable {
    public int embeddedHandle;
    int imHandle;
    int socketHandle;
    Layout layout;
    Control[] tabList;
    int layoutCount = 0;
    static final String NO_INPUT_METHOD = "org.eclipse.swt.internal.gtk.noInputMethod";

    Composite() {
    }

    public Composite(Composite parent, int style) {
        super(parent, style);
    }

    Control[] _getChildren() {
        int parentHandle = this.parentingHandle();
        int list = OS.gtk_container_get_children(parentHandle);
        if (list == 0) {
            return new Control[0];
        }
        int count = OS.g_list_length(list);
        Control[] children = new Control[count];
        int i = 0;
        int temp = list;
        while (temp != 0) {
            Widget widget;
            int handle = OS.g_list_data(temp);
            if (handle != 0 && (widget = this.display.getWidget(handle)) != null && widget != this && widget instanceof Control) {
                children[i++] = (Control)widget;
            }
            temp = OS.g_list_next(temp);
        }
        OS.g_list_free(list);
        if (i == count) {
            return children;
        }
        Control[] newChildren = new Control[i];
        System.arraycopy(children, 0, newChildren, 0, i);
        return newChildren;
    }

    Control[] _getTabList() {
        if (this.tabList == null) {
            return this.tabList;
        }
        int count = 0;
        int i = 0;
        while (i < this.tabList.length) {
            if (!this.tabList[i].isDisposed()) {
                ++count;
            }
            ++i;
        }
        if (count == this.tabList.length) {
            return this.tabList;
        }
        Control[] newList = new Control[count];
        int index = 0;
        int i2 = 0;
        while (i2 < this.tabList.length) {
            if (!this.tabList[i2].isDisposed()) {
                newList[index++] = this.tabList[i2];
            }
            ++i2;
        }
        this.tabList = newList;
        return this.tabList;
    }

    public void changed(Control[] changed) {
        this.checkWidget();
        if (changed == null) {
            this.error(5);
        }
        int i = 0;
        while (i < changed.length) {
            Control control = changed[i];
            if (control == null) {
                this.error(5);
            }
            if (control.isDisposed()) {
                this.error(5);
            }
            boolean ancestor = false;
            Composite composite = control.parent;
            while (composite != null) {
                boolean bl = ancestor = composite == this;
                if (ancestor) break;
                composite = composite.parent;
            }
            if (!ancestor) {
                this.error(32);
            }
            ++i;
        }
        i = 0;
        while (i < changed.length) {
            Control child = changed[i];
            Composite composite = child.parent;
            while (child != this) {
                if (composite.layout == null || !composite.layout.flushCache(child)) {
                    composite.state |= 0x400;
                }
                child = composite;
                composite = child.parent;
            }
            ++i;
        }
    }

    protected void checkSubclass() {
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size;
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        if (this.layout != null) {
            if (wHint == -1 || hHint == -1) {
                size = this.layout.computeSize(this, wHint, hHint, changed |= (this.state & 0x400) != 0);
                this.state &= 0xFFFFFBFF;
            } else {
                size = new Point(wHint, hHint);
            }
        } else {
            size = this.minimumSize(wHint, hHint, changed);
        }
        if (size.x == 0) {
            size.x = 64;
        }
        if (size.y == 0) {
            size.y = 64;
        }
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        return new Point(trim.width, trim.height);
    }

    Control[] computeTabList() {
        Control[] result = super.computeTabList();
        if (result.length == 0) {
            return result;
        }
        Control[] list = this.tabList != null ? this._getTabList() : this._getChildren();
        int i = 0;
        while (i < list.length) {
            Control child = list[i];
            Control[] childList = child.computeTabList();
            if (childList.length != 0) {
                Control[] newResult = new Control[result.length + childList.length];
                System.arraycopy(result, 0, newResult, 0, result.length);
                System.arraycopy(childList, 0, newResult, result.length, childList.length);
                result = newResult;
            }
            ++i;
        }
        return result;
    }

    void createHandle(int index) {
        this.state |= 0xA;
        boolean scrolled = (this.style & 0xB00) != 0;
        this.createHandle(index, scrolled);
    }

    void createHandle(int index, boolean scrolled) {
        if (scrolled) {
            int hadj;
            this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
            if (this.fixedHandle == 0) {
                this.error(2);
            }
            OS.gtk_fixed_set_has_window(this.fixedHandle, true);
            int vadj = OS.gtk_adjustment_new(0.0, 0.0, 100.0, 1.0, 10.0, 10.0);
            if (vadj == 0) {
                this.error(2);
            }
            if ((hadj = OS.gtk_adjustment_new(0.0, 0.0, 100.0, 1.0, 10.0, 10.0)) == 0) {
                this.error(2);
            }
            this.scrolledHandle = OS.gtk_scrolled_window_new(hadj, vadj);
            if (this.scrolledHandle == 0) {
                SWT.error(2);
            }
        }
        this.handle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.handle == 0) {
            SWT.error(2);
        }
        OS.gtk_fixed_set_has_window(this.handle, true);
        OS.GTK_WIDGET_SET_FLAGS(this.handle, 2048);
        if ((this.style & 0x1000000) == 0 && (this.state & 2) != 0 && (this.style & 0x80000) == 0 && this.display.getData(NO_INPUT_METHOD) == null) {
            this.imHandle = OS.gtk_im_multicontext_new();
            if (this.imHandle == 0) {
                this.error(2);
            }
        }
        if (scrolled) {
            OS.gtk_container_add(this.fixedHandle, this.scrolledHandle);
            boolean warnings = this.display.getWarnings();
            this.display.setWarnings(false);
            OS.gtk_container_add(this.scrolledHandle, this.handle);
            this.display.setWarnings(warnings);
            int hsp = (this.style & 0x100) != 0 ? 0 : 2;
            int vsp = (this.style & 0x200) != 0 ? 0 : 2;
            OS.gtk_scrolled_window_set_policy(this.scrolledHandle, hsp, vsp);
            if (this.hasBorder()) {
                OS.gtk_scrolled_window_set_shadow_type(this.scrolledHandle, 3);
            }
        }
        if ((this.style & 0x1000000) != 0) {
            this.socketHandle = OS.gtk_socket_new();
            if (this.socketHandle == 0) {
                SWT.error(2);
            }
            OS.gtk_container_add(this.handle, this.socketHandle);
        }
        if ((this.style & 0x100000) != 0) {
            OS.gtk_widget_set_redraw_on_allocate(this.handle, false);
        }
        if ((this.style & 0x40000) != 0) {
            OS.gtk_widget_set_double_buffered(this.handle, false);
            this.style &= 0xDFFFFFFF;
        }
    }

    void deregister() {
        super.deregister();
        if (this.socketHandle != 0) {
            this.display.removeWidget(this.socketHandle);
        }
    }

    void enableWidget(boolean enabled) {
        if ((this.state & 2) != 0) {
            return;
        }
        super.enableWidget(enabled);
    }

    Menu[] findMenus(Control control) {
        if (control == this) {
            return new Menu[0];
        }
        Menu[] result = super.findMenus(control);
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            Menu[] menuList = child.findMenus(control);
            if (menuList.length != 0) {
                Menu[] newResult = new Menu[result.length + menuList.length];
                System.arraycopy(result, 0, newResult, 0, result.length);
                System.arraycopy(menuList, 0, newResult, result.length, menuList.length);
                result = newResult;
            }
            ++i;
        }
        return result;
    }

    void fixChildren(Shell newShell, Shell oldShell, Decorations newDecorations, Decorations oldDecorations, Menu[] menus) {
        super.fixChildren(newShell, oldShell, newDecorations, oldDecorations, menus);
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].fixChildren(newShell, oldShell, newDecorations, oldDecorations, menus);
            ++i;
        }
    }

    void fixTabList(Control control) {
        if (this.tabList == null) {
            return;
        }
        int count = 0;
        int i = 0;
        while (i < this.tabList.length) {
            if (this.tabList[i] == control) {
                ++count;
            }
            ++i;
        }
        if (count == 0) {
            return;
        }
        Control[] newList = null;
        int length = this.tabList.length - count;
        if (length != 0) {
            newList = new Control[length];
            int index = 0;
            int i2 = 0;
            while (i2 < this.tabList.length) {
                if (this.tabList[i2] != control) {
                    newList[index++] = this.tabList[i2];
                }
                ++i2;
            }
        }
        this.tabList = newList;
    }

    void fixZOrder() {
        if ((this.state & 2) != 0) {
            return;
        }
        int parentHandle = this.parentingHandle();
        int parentWindow = OS.GTK_WIDGET_WINDOW(parentHandle);
        if (parentWindow == 0) {
            return;
        }
        int[] userData = new int[1];
        int windowList = OS.gdk_window_get_children(parentWindow);
        if (windowList != 0) {
            int windows = windowList;
            while (windows != 0) {
                int window = OS.g_list_data(windows);
                if (window != this.redrawWindow) {
                    OS.gdk_window_get_user_data(window, userData);
                    if (userData[0] == 0 || OS.G_OBJECT_TYPE(userData[0]) != this.display.gtk_fixed_get_type()) {
                        OS.gdk_window_lower(window);
                    }
                }
                windows = OS.g_list_next(windows);
            }
            OS.g_list_free(windowList);
        }
    }

    int focusHandle() {
        if (this.socketHandle != 0) {
            return this.socketHandle;
        }
        return super.focusHandle();
    }

    boolean forceFocus(int focusHandle) {
        if (this.socketHandle != 0) {
            OS.GTK_WIDGET_SET_FLAGS(focusHandle, 2048);
        }
        boolean result = super.forceFocus(focusHandle);
        if (this.socketHandle != 0) {
            OS.GTK_WIDGET_UNSET_FLAGS(focusHandle, 2048);
        }
        return result;
    }

    public Control[] getChildren() {
        this.checkWidget();
        return this._getChildren();
    }

    int getChildrenCount() {
        int list = OS.gtk_container_get_children(this.handle);
        if (list == 0) {
            return 0;
        }
        int count = OS.g_list_length(list);
        OS.g_list_free(list);
        return count;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        if ((this.state & 2) != 0) {
            if ((this.state & 0x800) != 0) {
                return new Rectangle(0, 0, 0, 0);
            }
            this.forceResize();
            int clientHandle = this.clientHandle();
            int width = OS.GTK_WIDGET_WIDTH(clientHandle);
            int height = OS.GTK_WIDGET_HEIGHT(clientHandle);
            return new Rectangle(0, 0, width, height);
        }
        return super.getClientArea();
    }

    public Layout getLayout() {
        this.checkWidget();
        return this.layout;
    }

    public boolean getLayoutDeferred() {
        this.checkWidget();
        return this.layoutCount > 0;
    }

    public Control[] getTabList() {
        this.checkWidget();
        Control[] tabList = this._getTabList();
        if (tabList == null) {
            int count = 0;
            Control[] list = this._getChildren();
            int i = 0;
            while (i < list.length) {
                if (list[i].isTabGroup()) {
                    ++count;
                }
                ++i;
            }
            tabList = new Control[count];
            int index = 0;
            int i2 = 0;
            while (i2 < list.length) {
                if (list[i2].isTabGroup()) {
                    tabList[index++] = list[i2];
                }
                ++i2;
            }
        }
        return tabList;
    }

    int gtk_button_press_event(int widget, int event) {
        int result = super.gtk_button_press_event(widget, event);
        if ((this.state & 2) != 0 && (this.style & 0x80000) == 0 && this.hooksKeys()) {
            GdkEventButton gdkEvent = new GdkEventButton();
            OS.memmove(gdkEvent, event, GdkEventButton.sizeof);
            if (gdkEvent.button == 1 && this.getChildrenCount() == 0) {
                this.setFocus();
            }
        }
        return result;
    }

    int gtk_expose_event(int widget, int eventPtr) {
        if ((this.state & 0x40) != 0) {
            return 0;
        }
        if ((this.state & 2) == 0) {
            return super.gtk_expose_event(widget, eventPtr);
        }
        if ((this.style & 0x200000) == 0) {
            return super.gtk_expose_event(widget, eventPtr);
        }
        if (!this.hooks(9) && !this.filters(9)) {
            return 0;
        }
        GdkEventExpose gdkEvent = new GdkEventExpose();
        OS.memmove(gdkEvent, eventPtr, GdkEventExpose.sizeof);
        int[] rectangles = new int[1];
        int[] n_rectangles = new int[1];
        OS.gdk_region_get_rectangles(gdkEvent.region, rectangles, n_rectangles);
        GdkRectangle rect = new GdkRectangle();
        int i = 0;
        while (i < n_rectangles[0]) {
            Event event = new Event();
            OS.memmove(rect, rectangles[0] + i * GdkRectangle.sizeof, GdkRectangle.sizeof);
            event.x = rect.x;
            event.y = rect.y;
            event.width = rect.width;
            event.height = rect.height;
            int damageRgn = OS.gdk_region_new();
            OS.gdk_region_union_with_rect(damageRgn, rect);
            GCData data = new GCData();
            data.damageRgn = damageRgn;
            GC gc = event.gc = GC.gtk_new(this, data);
            OS.gdk_gc_set_clip_region(gc.handle, damageRgn);
            this.sendEvent(9, event);
            gc.dispose();
            OS.gdk_region_destroy(damageRgn);
            event.gc = null;
            ++i;
        }
        OS.g_free(rectangles[0]);
        return 0;
    }

    int gtk_key_press_event(int widget, int event) {
        int result = super.gtk_key_press_event(widget, event);
        if (result != 0) {
            return result;
        }
        if ((this.state & 2) != 0 && this.socketHandle == 0) {
            GdkEventKey keyEvent = new GdkEventKey();
            OS.memmove(keyEvent, event, GdkEventKey.sizeof);
            int key = keyEvent.keyval;
            switch (key) {
                case 65293: 
                case 65421: {
                    return 1;
                }
            }
        }
        return result;
    }

    int gtk_focus(int widget, int directionType) {
        if (widget == this.socketHandle) {
            return 0;
        }
        return super.gtk_focus(widget, directionType);
    }

    int gtk_focus_in_event(int widget, int event) {
        int result = super.gtk_focus_in_event(widget, event);
        return (this.state & 2) != 0 ? 1 : result;
    }

    int gtk_focus_out_event(int widget, int event) {
        int result = super.gtk_focus_out_event(widget, event);
        return (this.state & 2) != 0 ? 1 : result;
    }

    int gtk_map(int widget) {
        this.fixZOrder();
        return 0;
    }

    int gtk_realize(int widget) {
        int window;
        int result = super.gtk_realize(widget);
        if ((this.style & 0x40000) != 0 && (window = OS.GTK_WIDGET_WINDOW(this.paintHandle())) != 0) {
            OS.gdk_window_set_back_pixmap(window, 0, false);
        }
        if (this.socketHandle != 0) {
            this.embeddedHandle = OS.gtk_socket_get_id(this.socketHandle);
        }
        return result;
    }

    int gtk_scroll_child(int widget, int scrollType, int horizontal) {
        OS.g_signal_stop_emission_by_name(widget, OS.scroll_child);
        return 1;
    }

    int gtk_style_set(int widget, int previousStyle) {
        int window;
        if ((this.style & 0x40000) != 0 && (window = OS.GTK_WIDGET_WINDOW(this.paintHandle())) != 0) {
            OS.gdk_window_set_back_pixmap(window, 0, false);
        }
        return 0;
    }

    boolean hasBorder() {
        return (this.style & 0x800) != 0;
    }

    void hookEvents() {
        super.hookEvents();
        if ((this.state & 2) != 0) {
            OS.gtk_widget_add_events(this.handle, 8);
            if (this.scrolledHandle != 0) {
                OS.g_signal_connect(this.scrolledHandle, OS.scroll_child, this.display.windowProc4, 35);
            }
            if ((this.style & 0x40000) != 0) {
                OS.g_signal_connect(this.handle, OS.style_set, this.display.windowProc3, 41);
            }
        }
    }

    boolean hooksKeys() {
        return this.hooks(1) || this.hooks(2);
    }

    int imHandle() {
        return this.imHandle;
    }

    public boolean isLayoutDeferred() {
        this.checkWidget();
        return this.layoutCount > 0 || this.parent.isLayoutDeferred();
    }

    boolean isTabGroup() {
        if ((this.state & 2) != 0) {
            return true;
        }
        return super.isTabGroup();
    }

    public void layout() {
        this.checkWidget();
        this.layout(true);
    }

    public void layout(boolean changed) {
        this.checkWidget();
        if (this.layout == null) {
            return;
        }
        this.layout(changed, false);
    }

    public void layout(boolean changed, boolean all) {
        this.checkWidget();
        if (this.layout == null && !all) {
            return;
        }
        this.markLayout(changed, all);
        this.updateLayout(all);
    }

    public void layout(Control[] changed) {
        this.checkWidget();
        if (changed == null) {
            this.error(5);
        }
        int i = 0;
        while (i < changed.length) {
            Control control = changed[i];
            if (control == null) {
                this.error(5);
            }
            if (control.isDisposed()) {
                this.error(5);
            }
            boolean ancestor = false;
            Composite composite = control.parent;
            while (composite != null) {
                boolean bl = ancestor = composite == this;
                if (ancestor) break;
                composite = composite.parent;
            }
            if (!ancestor) {
                this.error(32);
            }
            ++i;
        }
        int updateCount = 0;
        Composite[] update = new Composite[16];
        int i2 = 0;
        while (i2 < changed.length) {
            Control child = changed[i2];
            Composite composite = child.parent;
            while (child != this) {
                if (composite.layout != null) {
                    composite.state |= 0x200;
                    if (!composite.layout.flushCache(child)) {
                        composite.state |= 0x400;
                    }
                }
                if (updateCount == update.length) {
                    Composite[] newUpdate = new Composite[update.length + 16];
                    System.arraycopy(update, 0, newUpdate, 0, update.length);
                    update = newUpdate;
                }
                int n = updateCount++;
                Composite composite2 = composite;
                update[n] = composite2;
                child = composite2;
                composite = child.parent;
            }
            ++i2;
        }
        i2 = updateCount - 1;
        while (i2 >= 0) {
            update[i2].updateLayout(false);
            --i2;
        }
    }

    void markLayout(boolean changed, boolean all) {
        if (this.layout != null) {
            this.state |= 0x200;
            if (changed) {
                this.state |= 0x400;
            }
        }
        if (all) {
            Control[] children = this._getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].markLayout(changed, all);
                ++i;
            }
        }
    }

    void moveAbove(int child, int sibling) {
        if (child == sibling) {
            return;
        }
        int parentHandle = this.parentingHandle();
        GtkFixed fixed = new GtkFixed();
        OS.memmove(fixed, parentHandle);
        int children = fixed.children;
        if (children == 0) {
            return;
        }
        int[] data = new int[1];
        int[] widget = new int[1];
        int childData = 0;
        int childLink = 0;
        int siblingLink = 0;
        int temp = children;
        while (temp != 0) {
            OS.memmove(data, temp, OS.PTR_SIZEOF);
            OS.memmove(widget, data[0], OS.PTR_SIZEOF);
            if (child == widget[0]) {
                childLink = temp;
                childData = data[0];
            } else if (sibling == widget[0]) {
                siblingLink = temp;
            }
            if (childData != 0 && (sibling == 0 || siblingLink != 0)) break;
            temp = OS.g_list_next(temp);
        }
        children = OS.g_list_remove_link(children, childLink);
        if (siblingLink == 0 || OS.g_list_previous(siblingLink) == 0) {
            OS.g_list_free_1(childLink);
            children = OS.g_list_prepend(children, childData);
        } else {
            temp = OS.g_list_previous(siblingLink);
            OS.g_list_set_previous(childLink, temp);
            OS.g_list_set_next(temp, childLink);
            OS.g_list_set_next(childLink, siblingLink);
            OS.g_list_set_previous(siblingLink, childLink);
        }
        fixed.children = children;
        OS.memmove(parentHandle, fixed);
    }

    void moveBelow(int child, int sibling) {
        if (child == sibling) {
            return;
        }
        int parentHandle = this.parentingHandle();
        if (sibling == 0 && parentHandle == this.fixedHandle) {
            this.moveAbove(child, this.scrolledHandle != 0 ? this.scrolledHandle : this.handle);
            return;
        }
        GtkFixed fixed = new GtkFixed();
        OS.memmove(fixed, parentHandle);
        int children = fixed.children;
        if (children == 0) {
            return;
        }
        int[] data = new int[1];
        int[] widget = new int[1];
        int childData = 0;
        int childLink = 0;
        int siblingLink = 0;
        int temp = children;
        while (temp != 0) {
            OS.memmove(data, temp, OS.PTR_SIZEOF);
            OS.memmove(widget, data[0], OS.PTR_SIZEOF);
            if (child == widget[0]) {
                childLink = temp;
                childData = data[0];
            } else if (sibling == widget[0]) {
                siblingLink = temp;
            }
            if (childData != 0 && (sibling == 0 || siblingLink != 0)) break;
            temp = OS.g_list_next(temp);
        }
        children = OS.g_list_remove_link(children, childLink);
        if (siblingLink == 0 || OS.g_list_next(siblingLink) == 0) {
            OS.g_list_free_1(childLink);
            children = OS.g_list_append(children, childData);
        } else {
            temp = OS.g_list_next(siblingLink);
            OS.g_list_set_next(childLink, temp);
            OS.g_list_set_previous(temp, childLink);
            OS.g_list_set_previous(childLink, siblingLink);
            OS.g_list_set_next(siblingLink, childLink);
        }
        fixed.children = children;
        OS.memmove(parentHandle, fixed);
    }

    Point minimumSize(int wHint, int hHint, boolean changed) {
        Control[] children = this._getChildren();
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < children.length) {
            Rectangle rect = children[i].getBounds();
            width = Math.max(width, rect.x + rect.width);
            height = Math.max(height, rect.y + rect.height);
            ++i;
        }
        return new Point(width, height);
    }

    int parentingHandle() {
        if ((this.state & 2) != 0) {
            return this.handle;
        }
        return this.fixedHandle != 0 ? this.fixedHandle : this.handle;
    }

    void register() {
        super.register();
        if (this.socketHandle != 0) {
            this.display.addWidget(this.socketHandle, this);
        }
    }

    void releaseChildren() {
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child != null && !child.isDisposed()) {
                child.releaseResources();
            }
            ++i;
        }
    }

    void releaseWidget() {
        this.releaseChildren();
        super.releaseWidget();
        if (this.imHandle != 0) {
            OS.g_object_unref(this.imHandle);
        }
        this.imHandle = 0;
        this.layout = null;
    }

    void removeControl(Control control) {
        this.fixTabList(control);
    }

    void resizeHandle(int width, int height) {
        super.resizeHandle(width, height);
        if (this.socketHandle != 0) {
            OS.gtk_widget_set_size_request(this.socketHandle, width, height);
        }
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        int result = super.setBounds(x, y, width, height, move, resize);
        if ((result & 0x100) != 0 && this.layout != null) {
            this.markLayout(false, false);
            this.updateLayout(false);
        }
        return result;
    }

    public boolean setFocus() {
        this.checkWidget();
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child.getVisible() && child.setFocus()) {
                return true;
            }
            ++i;
        }
        return super.setFocus();
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
        this.layout = layout;
    }

    public void setLayoutDeferred(boolean defer) {
        if (!defer) {
            if (--this.layoutCount == 0 && !this.isLayoutDeferred()) {
                this.updateLayout(true);
            }
        } else {
            ++this.layoutCount;
        }
    }

    boolean setScrollBarVisible(ScrollBar bar, boolean visible) {
        boolean changed = super.setScrollBarVisible(bar, visible);
        if (changed && this.layout != null) {
            this.markLayout(false, false);
            this.updateLayout(false);
        }
        return changed;
    }

    boolean setTabGroupFocus(boolean next) {
        boolean takeFocus;
        if (this.isTabItem()) {
            return this.setTabItemFocus(next);
        }
        boolean bl = takeFocus = (this.style & 0x80000) == 0;
        if ((this.state & 2) != 0) {
            takeFocus = this.hooksKeys();
        }
        if (this.socketHandle != 0) {
            takeFocus = true;
        }
        if (takeFocus && this.setTabItemFocus(next)) {
            return true;
        }
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child.isTabItem() && child.setTabItemFocus(next)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean setTabItemFocus(boolean next) {
        if (!super.setTabItemFocus(next)) {
            return false;
        }
        if (this.socketHandle != 0) {
            int direction = next ? 0 : 1;
            OS.GTK_WIDGET_UNSET_FLAGS(this.socketHandle, 4096);
            OS.gtk_widget_child_focus(this.socketHandle, direction);
            OS.GTK_WIDGET_SET_FLAGS(this.socketHandle, 4096);
        }
        return true;
    }

    public void setTabList(Control[] tabList) {
        this.checkWidget();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                Control control = tabList[i];
                if (control == null) {
                    this.error(5);
                }
                if (control.isDisposed()) {
                    this.error(5);
                }
                if (control.parent != this) {
                    this.error(32);
                }
                ++i;
            }
            Control[] newList = new Control[tabList.length];
            System.arraycopy(tabList, 0, newList, 0, tabList.length);
            tabList = newList;
        }
        this.tabList = tabList;
    }

    void showWidget() {
        super.showWidget();
        if (this.socketHandle != 0) {
            OS.gtk_widget_show(this.socketHandle);
            this.embeddedHandle = OS.gtk_socket_get_id(this.socketHandle);
        }
    }

    boolean translateMnemonic(Event event, Control control) {
        if (super.translateMnemonic(event, control)) {
            return true;
        }
        if (control != null) {
            Control[] children = this._getChildren();
            int i = 0;
            while (i < children.length) {
                Control child = children[i];
                if (child.translateMnemonic(event, control)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    int traversalCode(int key, GdkEventKey event) {
        if ((this.state & 2) != 0) {
            if ((this.style & 0x80000) != 0) {
                return 0;
            }
            if (this.hooksKeys()) {
                return 0;
            }
        }
        return super.traversalCode(key, event);
    }

    boolean translateTraversal(GdkEventKey keyEvent) {
        if (this.socketHandle != 0) {
            return false;
        }
        return super.translateTraversal(keyEvent);
    }

    void updateLayout(boolean all) {
        if (this.isLayoutDeferred()) {
            return;
        }
        if ((this.state & 0x200) != 0) {
            boolean changed = (this.state & 0x400) != 0;
            this.state &= 0xFFFFF9FF;
            this.layout.layout(this, changed);
        }
        if (all) {
            Control[] children = this._getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].updateLayout(all);
                ++i;
            }
        }
    }
}

