/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.composite;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.bean.FacilityPath;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.composite.NumberVerifyListener;
import com.clustercontrol.composite.StringVerifyListener;
import com.clustercontrol.dialog.ScopeTreeDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.bean.JobCommandInfo;
import com.clustercontrol.util.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CommandComposite
extends Composite {
    protected Text m_scope = null;
    protected Text m_startCommand = null;
    protected Text m_stopCommand = null;
    protected Text m_user = null;
    protected Button m_scopeJobParam = null;
    protected Button m_scopeFixedValue = null;
    protected Button m_scopeSelect = null;
    protected Button m_allNode = null;
    protected Button m_retry = null;
    protected Button m_errorCondition = null;
    protected Text m_errorEndValue = null;
    protected Group m_errorEndConditionGroup = null;
    protected String m_facilityId = null;
    protected String m_facilityPath = null;
    protected JobCommandInfo m_execute = null;
    protected Shell m_shell = null;

    public CommandComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
        this.m_shell = this.getShell();
    }

    private void initialize() {
        RowLayout layout = new RowLayout();
        layout.type = 512;
        layout.spacing = 10;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.fill = true;
        this.setLayout((Layout)layout);
        Composite composite = null;
        RowLayout rowLayout = null;
        Label label = null;
        Group group = new Group((Composite)this, 0);
        group.setText(Messages.getString((String)"scope"));
        rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.marginWidth = 10;
        rowLayout.marginHeight = 10;
        group.setLayout((Layout)rowLayout);
        composite = new Composite((Composite)group, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        this.m_scopeJobParam = new Button(composite, 16);
        this.m_scopeJobParam.setText(String.valueOf(Messages.getString((String)"job.parameter")) + " : ");
        this.m_scopeJobParam.setLayoutData((Object)new RowData(100, 22));
        this.m_scopeJobParam.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    CommandComposite.this.m_scopeFixedValue.setSelection(false);
                    CommandComposite.this.m_scopeSelect.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        label = new Label(composite, 16384);
        label.setText("${FACILITY_ID}");
        label.setLayoutData((Object)new RowData(100, 15));
        composite = new Composite((Composite)group, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        this.m_scopeFixedValue = new Button(composite, 16);
        this.m_scopeFixedValue.setText(String.valueOf(Messages.getString((String)"fixed.value")) + " : ");
        this.m_scopeFixedValue.setLayoutData((Object)new RowData(100, 22));
        this.m_scopeFixedValue.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    CommandComposite.this.m_scopeJobParam.setSelection(false);
                    CommandComposite.this.m_scopeSelect.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_scope = new Text(composite, 2056);
        this.m_scope.setLayoutData((Object)new RowData(200, 15));
        this.m_scope.setText("");
        this.m_scopeSelect = new Button(composite, 0);
        this.m_scopeSelect.setText(Messages.getString((String)"refer"));
        this.m_scopeSelect.setLayoutData((Object)new RowData(80, 22));
        this.m_scopeSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScopeTreeDialog dialog = new ScopeTreeDialog(CommandComposite.this.m_shell);
                if (dialog.open() == 0) {
                    FacilityTreeItem selectItem = dialog.getSelectItem();
                    if (selectItem.getData().getType() == 2) {
                        CommandComposite.this.m_facilityPath = "";
                        CommandComposite.this.m_facilityId = "";
                    } else {
                        FacilityPath path = new FacilityPath(ClusterControlPlugin.getDefault().getSeparator());
                        CommandComposite.this.m_facilityPath = path.getPath(selectItem);
                        CommandComposite.this.m_facilityId = selectItem.getData().getFacilityId();
                    }
                    CommandComposite.this.m_scope.setText(CommandComposite.this.m_facilityPath);
                }
            }
        });
        group = new Group((Composite)this, 0);
        group.setText(Messages.getString((String)"scope.process"));
        rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.marginWidth = 10;
        rowLayout.marginHeight = 10;
        group.setLayout((Layout)rowLayout);
        this.m_allNode = new Button((Composite)group, 16);
        this.m_allNode.setText(Messages.getString((String)"scope.process.all.nodes"));
        this.m_allNode.setLayoutData((Object)new RowData(350, 22));
        this.m_retry = new Button((Composite)group, 16);
        this.m_retry.setText(Messages.getString((String)"scope.process.retry.nodes"));
        this.m_retry.setLayoutData((Object)new RowData(350, 22));
        composite = new Composite((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        label = new Label(composite, 0);
        label.setText(String.valueOf(Messages.getString((String)"start.command")) + " : ");
        label.setLayoutData((Object)new RowData(100, 15));
        this.m_startCommand = new Text(composite, 2048);
        this.m_startCommand.setLayoutData((Object)new RowData(200, 15));
        this.m_startCommand.addVerifyListener((VerifyListener)new StringVerifyListener(1024));
        composite = new Composite((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        label = new Label(composite, 0);
        label.setText(String.valueOf(Messages.getString((String)"stop.command")) + " : ");
        label.setLayoutData((Object)new RowData(100, 15));
        this.m_stopCommand = new Text(composite, 2048);
        this.m_stopCommand.setLayoutData((Object)new RowData(200, 15));
        this.m_stopCommand.addVerifyListener((VerifyListener)new StringVerifyListener(1024));
        composite = new Composite((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        label = new Label(composite, 0);
        label.setText(String.valueOf(Messages.getString((String)"effective.user")) + " : ");
        label.setLayoutData((Object)new RowData(100, 15));
        this.m_user = new Text(composite, 2048);
        this.m_user.setLayoutData((Object)new RowData(200, 15));
        this.m_user.addVerifyListener((VerifyListener)new StringVerifyListener(64));
        composite = new Composite((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 512;
        composite.setLayout((Layout)rowLayout);
        this.m_errorCondition = new Button(composite, 32);
        this.m_errorCondition.setText(Messages.getString((String)"command.error.ended"));
        this.m_errorCondition.setLayoutData((Object)new RowData(220, 22));
        this.m_errorCondition.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    CommandComposite.this.m_errorEndConditionGroup.setEnabled(true);
                    CommandComposite.this.m_errorEndValue.setEnabled(true);
                } else {
                    CommandComposite.this.m_errorEndConditionGroup.setEnabled(false);
                    CommandComposite.this.m_errorEndValue.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_errorEndConditionGroup = new Group((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.marginWidth = 10;
        rowLayout.marginHeight = 10;
        rowLayout.spacing = 10;
        this.m_errorEndConditionGroup.setLayout((Layout)rowLayout);
        composite = new Composite((Composite)this.m_errorEndConditionGroup, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        Label skipEndValueTitle = new Label(composite, 16384);
        skipEndValueTitle.setText(String.valueOf(Messages.getString((String)"end.value")) + " : ");
        skipEndValueTitle.setLayoutData((Object)new RowData(80, 15));
        this.m_errorEndValue = new Text(composite, 2048);
        this.m_errorEndValue.setLayoutData((Object)new RowData(100, 15));
        this.m_errorEndValue.addVerifyListener((VerifyListener)new NumberVerifyListener(Short.MIN_VALUE, Short.MAX_VALUE));
    }

    public void reflectCommandInfo() {
        if (this.m_execute instanceof JobCommandInfo) {
            this.m_facilityPath = this.m_execute.getScope();
            this.m_facilityId = this.m_execute.getFacilityID();
            if (this.m_facilityId.equals("${FACILITY_ID}")) {
                this.m_facilityId = "";
                this.m_facilityPath = "";
                this.m_scope.setText(this.m_facilityPath);
                this.m_scopeJobParam.setSelection(true);
                this.m_scopeFixedValue.setSelection(false);
            } else {
                if (this.m_facilityPath != null && this.m_facilityPath.length() > 0) {
                    this.m_scope.setText(this.m_facilityPath);
                }
                this.m_scopeJobParam.setSelection(false);
                this.m_scopeFixedValue.setSelection(true);
            }
            if (this.m_execute.getProcessingMethod() == 0) {
                this.m_allNode.setSelection(true);
            } else {
                this.m_retry.setSelection(true);
            }
            if (this.m_execute.getStartCommand() != null && this.m_execute.getStartCommand().length() > 0) {
                this.m_startCommand.setText(this.m_execute.getStartCommand());
            }
            if (this.m_execute.getStopCommand() != null && this.m_execute.getStopCommand().length() > 0) {
                this.m_stopCommand.setText(this.m_execute.getStopCommand());
            }
            if (this.m_execute.getUser() != null && this.m_execute.getUser().length() > 0) {
                this.m_user.setText(this.m_execute.getUser());
            }
            this.m_errorCondition.setSelection(YesNoConstant.typeToBoolean((int)this.m_execute.getErrorEndFlg()));
            this.m_errorEndValue.setText(String.valueOf(this.m_execute.getErrorEndValue()));
        } else {
            this.m_scopeJobParam.setSelection(false);
            this.m_scopeFixedValue.setSelection(true);
            this.m_scope.setText("");
            this.m_allNode.setSelection(true);
            this.m_startCommand.setText("");
            this.m_stopCommand.setText("");
            this.m_user.setText("");
            this.m_errorCondition.setSelection(false);
            this.m_errorEndValue.setText(String.valueOf(0));
        }
        if (this.m_scopeJobParam.getSelection()) {
            this.m_scopeSelect.setEnabled(false);
        } else {
            this.m_scopeSelect.setEnabled(true);
        }
        if (this.m_errorCondition.getSelection()) {
            this.m_errorEndConditionGroup.setEnabled(true);
            this.m_errorEndValue.setEnabled(true);
        } else {
            this.m_errorEndConditionGroup.setEnabled(false);
            this.m_errorEndValue.setEnabled(false);
        }
    }

    public void setCommandInfo(JobCommandInfo execute) {
        this.m_execute = execute;
    }

    public JobCommandInfo getCommandInfo() {
        return this.m_execute;
    }

    public ValidateResult createCommandInfo() {
        block11: {
            ValidateResult result = null;
            this.m_execute = new JobCommandInfo();
            if (this.m_scopeJobParam.getSelection()) {
                this.m_execute.setFacilityID("${FACILITY_ID}");
                this.m_execute.setScope("");
            } else if (this.m_facilityId != null && this.m_facilityId.length() > 0) {
                this.m_execute.setFacilityID(this.m_facilityId);
                this.m_execute.setScope(this.m_facilityPath);
            } else {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.hinemos.3"));
                return result;
            }
            if (this.m_allNode.getSelection()) {
                this.m_execute.setProcessingMethod(0);
            } else {
                this.m_execute.setProcessingMethod(1);
            }
            if (this.m_startCommand.getText().length() <= 0) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.3"));
                return result;
            }
            this.m_execute.setStartCommand(this.m_startCommand.getText());
            if (this.m_stopCommand.getText().length() <= 0) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.4"));
                return result;
            }
            this.m_execute.setStopCommand(this.m_stopCommand.getText());
            if (this.m_user.getText().length() <= 0) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.5"));
                return result;
            }
            this.m_execute.setUser(this.m_user.getText());
            this.m_execute.setErrorEndFlg(YesNoConstant.booleanToType((boolean)this.m_errorCondition.getSelection()));
            try {
                this.m_execute.setErrorEndValue(Integer.parseInt(this.m_errorEndValue.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                if (this.m_execute.getErrorEndValue() != 1) break block11;
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.21"));
                return result;
            }
        }
        return null;
    }
}

