/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.ui.views.markers.internal.IFilter;
import org.eclipse.ui.views.markers.internal.IItemsChangedListener;
import org.eclipse.ui.views.markers.internal.ITableViewContentProvider;

public class MarkerRegistry
implements IResourceChangeListener,
ITableViewContentProvider {
    private IFilter filter;
    private IResource input;
    private String[] types = new String[0];
    private ListenerList listeners = new ListenerList();

    public void dispose() {
        this.listeners.clear();
        this.setInput(null);
    }

    public Object[] getElements() {
        Object[] elements = this.getUnfilteredElements();
        if (this.filter != null) {
            Object[] filteredItems = this.filter.filter(elements);
            return filteredItems;
        }
        return elements;
    }

    public Object[] getUnfilteredElements() {
        if (this.input == null) {
            return new Object[0];
        }
        ArrayList<IMarker> elements = new ArrayList<IMarker>();
        int i = 0;
        while (i < this.types.length) {
            try {
                IMarker[] newMarkers = this.input.findMarkers(this.types[i], true, 2);
                elements.addAll(Arrays.asList(newMarkers));
            }
            catch (CoreException coreException) {}
            ++i;
        }
        return elements.toArray();
    }

    public IFilter getFilter() {
        return this.filter;
    }

    public IResource getInput() {
        return this.input;
    }

    public void setFilter(IFilter filter) {
        if (this.filter == null || !this.filter.equals(filter)) {
            this.filter = filter;
        }
    }

    public void setInput(IResource resource) {
        if (this.input != null) {
            if (this.input.equals((Object)resource)) {
                return;
            }
            this.input.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }
        this.input = resource;
        if (this.input != null) {
            resource.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        }
    }

    public String[] getTypes() {
        return this.types;
    }

    public void setTypes(String[] types) {
        this.types = types == null ? new String[0] : types;
    }

    public void setType(String type) {
        this.setTypes(new String[]{type});
    }

    public void resourceChanged(IResourceChangeEvent event) {
        ArrayList additions = new ArrayList();
        ArrayList removals = new ArrayList();
        ArrayList changes = new ArrayList();
        IResourceDelta delta = event.getDelta();
        if (delta == null) {
            return;
        }
        this.getMarkerDeltas(delta, additions, removals, changes);
        this.filterList(additions);
        this.filterList(changes);
        this.notifyListeners(additions, removals, changes);
    }

    private void getMarkerDeltas(IResourceDelta delta, List additions, List removals, List changes) {
        IMarkerDelta[] markerDeltas = delta.getMarkerDeltas();
        int i = 0;
        while (i < markerDeltas.length) {
            IMarkerDelta markerDelta = markerDeltas[i];
            IMarker marker = markerDelta.getMarker();
            switch (markerDelta.getKind()) {
                case 1: {
                    boolean added = false;
                    int j = 0;
                    while (j < this.types.length && !added) {
                        if (markerDelta.isSubtypeOf(this.types[j])) {
                            additions.add(marker);
                            added = true;
                        }
                        ++j;
                    }
                    break;
                }
                case 2: {
                    boolean added = false;
                    int j = 0;
                    while (j < this.types.length && !added) {
                        if (markerDelta.isSubtypeOf(this.types[j])) {
                            removals.add(marker);
                            added = true;
                        }
                        ++j;
                    }
                    break;
                }
                case 4: {
                    boolean added = false;
                    int j = 0;
                    while (j < this.types.length && !added) {
                        if (markerDelta.isSubtypeOf(this.types[j])) {
                            changes.add(marker);
                            added = true;
                        }
                        ++j;
                    }
                    break;
                }
            }
            ++i;
        }
        IResourceDelta[] children = delta.getAffectedChildren();
        int i2 = 0;
        while (i2 < children.length) {
            this.getMarkerDeltas(children[i2], additions, removals, changes);
            ++i2;
        }
    }

    private void notifyListeners(List additions, List removals, List changes) {
        Object[] listeners = this.listeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IItemsChangedListener listener = (IItemsChangedListener)listeners[i];
            listener.itemsChanged(additions, removals, changes);
            ++i;
        }
    }

    public void addItemsChangedListener(IItemsChangedListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeItemsChangedListener(IItemsChangedListener listener) {
        this.listeners.remove((Object)listener);
    }

    public int getItemCount() {
        return this.getElements().length;
    }

    public int getRawItemCount() {
        return this.getUnfilteredElements().length;
    }

    private void filterList(List list) {
        if (this.filter == null || list == null) {
            return;
        }
        int i = 0;
        while (i < list.size()) {
            if (this.filter.select(list.get(i))) {
                ++i;
                continue;
            }
            list.remove(i);
        }
    }
}

