/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.iiop.rmi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jboss.iiop.rmi.AbstractAnalysis;
import org.jboss.iiop.rmi.AttributeAnalysis;
import org.jboss.iiop.rmi.ContainerAnalysis;
import org.jboss.iiop.rmi.OperationAnalysis;
import org.jboss.iiop.rmi.RMIIIOPViolationException;
import org.jboss.iiop.rmi.RmiIdlUtil;
import org.jboss.iiop.rmi.WorkCacheManager;
import org.jboss.logging.Logger;

public class InterfaceAnalysis
extends ContainerAnalysis {
    Map operationAnalysisMap;
    private static final Logger logger = Logger.getLogger(class$org$jboss$iiop$rmi$InterfaceAnalysis == null ? (class$org$jboss$iiop$rmi$InterfaceAnalysis = InterfaceAnalysis.class$("org.jboss.iiop.rmi.InterfaceAnalysis")) : class$org$jboss$iiop$rmi$InterfaceAnalysis);
    private static WorkCacheManager cache = new WorkCacheManager(class$org$jboss$iiop$rmi$InterfaceAnalysis == null ? (class$org$jboss$iiop$rmi$InterfaceAnalysis = InterfaceAnalysis.class$("org.jboss.iiop.rmi.InterfaceAnalysis")) : class$org$jboss$iiop$rmi$InterfaceAnalysis);
    private boolean abstractInterface;
    private String[] allTypeIds;
    static /* synthetic */ Class class$org$jboss$iiop$rmi$InterfaceAnalysis;

    public static InterfaceAnalysis getInterfaceAnalysis(Class cls) throws RMIIIOPViolationException {
        return (InterfaceAnalysis)cache.getAnalysis(cls);
    }

    protected InterfaceAnalysis(Class cls) {
        super(cls);
        logger.debug("new InterfaceAnalysis: " + cls.getName());
    }

    protected void doAnalyze() throws RMIIIOPViolationException {
        super.doAnalyze();
        this.calculateOperationAnalysisMap();
        this.fixupCaseNames();
    }

    public boolean isAbstractInterface() {
        return this.abstractInterface;
    }

    public boolean isRmiIdlRemoteInterface() {
        return !this.abstractInterface;
    }

    public String[] getAllTypeIds() {
        if (this.allTypeIds == null) {
            logger.debug(this.cls + " null allTypeIds");
        }
        return (String[])this.allTypeIds.clone();
    }

    protected ArrayList getContainedEntries() {
        int i;
        ArrayList<AbstractAnalysis> ret = new ArrayList<AbstractAnalysis>(this.constants.length + this.attributes.length + this.operations.length);
        for (i = 0; i < this.constants.length; ++i) {
            ret.add(this.constants[i]);
        }
        for (i = 0; i < this.attributes.length; ++i) {
            ret.add(this.attributes[i]);
        }
        for (i = 0; i < this.operations.length; ++i) {
            ret.add(this.operations[i]);
        }
        return ret;
    }

    protected void analyzeOperations() throws RMIIIOPViolationException {
        int i;
        logger.debug(this.cls + " analyzeOperations");
        if (!this.cls.isInterface()) {
            throw new IllegalArgumentException("Class \"" + this.cls.getName() + "\" is not an interface.");
        }
        this.abstractInterface = RmiIdlUtil.isAbstractInterface(this.cls);
        this.calculateAllTypeIds();
        int operationCount = 0;
        for (i = 0; i < this.methods.length; ++i) {
            if ((this.m_flags[i] & 0xE) != 0) continue;
            ++operationCount;
        }
        this.operations = new OperationAnalysis[operationCount];
        operationCount = 0;
        for (i = 0; i < this.methods.length; ++i) {
            if ((this.m_flags[i] & 0xE) != 0) continue;
            this.operations[operationCount] = new OperationAnalysis(this.methods[i]);
            ++operationCount;
        }
        logger.debug(this.cls + " analyzeOperations operations=" + this.operations.length);
    }

    protected void calculateOperationAnalysisMap() {
        OperationAnalysis oa;
        int i;
        this.operationAnalysisMap = new HashMap();
        for (i = 0; i < this.operations.length; ++i) {
            oa = this.operations[i];
            this.operationAnalysisMap.put(oa.getIDLName(), oa);
        }
        for (i = 0; i < this.attributes.length; ++i) {
            AttributeAnalysis attr = this.attributes[i];
            oa = attr.getAccessorAnalysis();
            if (oa == null) continue;
            this.operationAnalysisMap.put(oa.getIDLName(), oa);
            oa = attr.getMutatorAnalysis();
            if (oa == null) continue;
            this.operationAnalysisMap.put(oa.getIDLName(), oa);
        }
    }

    protected void calculateAllTypeIds() {
        if (!this.isRmiIdlRemoteInterface()) {
            this.allTypeIds = new String[0];
        } else {
            int i;
            ArrayList<String> a = new ArrayList<String>();
            InterfaceAnalysis[] intfs = this.getInterfaces();
            for (i = 0; i < intfs.length; ++i) {
                String[] ss = intfs[i].getAllTypeIds();
                for (int j = 0; j < ss.length; ++j) {
                    if (a.contains(ss[j])) continue;
                    a.add(ss[j]);
                }
            }
            this.allTypeIds = new String[a.size() + 1];
            this.allTypeIds[0] = this.getRepositoryId();
            for (i = 1; i <= a.size(); ++i) {
                this.allTypeIds[i] = (String)a.get(a.size() - i);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

