/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.registry.ConfigurationElement;
import org.eclipse.core.internal.registry.ConfigurationElementHandle;
import org.eclipse.core.internal.registry.Contribution;
import org.eclipse.core.internal.registry.ExtensionHandle;
import org.eclipse.core.internal.registry.ExtensionPoint;
import org.eclipse.core.internal.registry.ExtensionPointHandle;
import org.eclipse.core.internal.registry.HashtableOfInt;
import org.eclipse.core.internal.registry.KeyedElement;
import org.eclipse.core.internal.registry.KeyedHashSet;
import org.eclipse.core.internal.registry.RegistryObjectManager;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Messages;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Status;

public class TableWriter {
    private static final byte fileError = 0;
    static File mainDataFile;
    static File extraDataFile;
    static File tableFile;
    static File contributionsFile;
    static File orphansFile;
    DataOutputStream mainOutput;
    DataOutputStream extraOutput;
    FileOutputStream mainFileOutput = null;
    FileOutputStream extraFileOutput = null;
    private HashtableOfInt offsets;

    static void setMainDataFile(File main) {
        mainDataFile = main;
    }

    static void setExtraDataFile(File extra) {
        extraDataFile = extra;
    }

    static void setTableFile(File table) {
        tableFile = table;
    }

    static void setContributionsFile(File fileName) {
        contributionsFile = fileName;
    }

    static void setOrphansFile(File orphan) {
        orphansFile = orphan;
    }

    private int getExtraDataPosition() {
        return this.extraOutput.size();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean saveCache(RegistryObjectManager objectManager, long timestamp) {
        try {
            if (!this.openFiles()) {
                Object var5_3 = null;
                this.closeFiles();
                return false;
            }
            try {
                this.saveExtensionRegistry(objectManager, timestamp);
            }
            catch (IOException io) {
                InternalPlatform.getDefault().log(new Status(4, "org.eclipse.core.runtime", 0, Messages.meta_registryCacheWriteProblems, io));
                Object var5_4 = null;
                this.closeFiles();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.closeFiles();
            throw throwable;
        }
        {
            Object var5_6 = null;
            this.closeFiles();
            return true;
        }
    }

    private boolean openFiles() {
        try {
            this.mainFileOutput = new FileOutputStream(mainDataFile);
            this.mainOutput = new DataOutputStream(new BufferedOutputStream(this.mainFileOutput));
            this.extraFileOutput = new FileOutputStream(extraDataFile);
            this.extraOutput = new DataOutputStream(new BufferedOutputStream(this.extraFileOutput));
        }
        catch (FileNotFoundException e) {
            if (this.mainFileOutput != null) {
                try {
                    this.mainFileOutput.close();
                }
                catch (IOException iOException) {}
            }
            InternalPlatform.getDefault().log(new Status(4, "org.eclipse.core.runtime", 0, Messages.meta_unableToCreateCache, e));
            return false;
        }
        return true;
    }

    private void closeFiles() {
        try {
            if (this.mainOutput != null) {
                this.mainOutput.flush();
                if (this.mainFileOutput.getFD().valid()) {
                    this.mainFileOutput.getFD().sync();
                }
                this.mainOutput.close();
            }
        }
        catch (IOException e) {
            InternalPlatform.getDefault().log(new Status(4, "org.eclipse.core.runtime", 0, Messages.meta_registryCacheWriteProblems, e));
            e.printStackTrace();
        }
        try {
            if (this.extraOutput != null) {
                this.extraOutput.flush();
                if (this.extraFileOutput.getFD().valid()) {
                    this.extraFileOutput.getFD().sync();
                }
                this.extraOutput.close();
            }
        }
        catch (IOException e) {
            InternalPlatform.getDefault().log(new Status(4, "org.eclipse.core.runtime", 0, Messages.meta_registryCacheWriteProblems, e));
            e.printStackTrace();
        }
    }

    private void saveExtensionRegistry(RegistryObjectManager objectManager, long timestamp) throws IOException {
        ExtensionPointHandle[] points = objectManager.getExtensionPointsHandles();
        this.offsets = new HashtableOfInt(objectManager.getNextId());
        int i = 0;
        while (i < points.length) {
            this.saveExtensionPoint(points[i]);
            ++i;
        }
        this.saveOrphans(objectManager);
        this.saveNamespaces(objectManager.getContributions());
        this.closeFiles();
        this.saveTables(objectManager, timestamp);
    }

    private void saveNamespaces(KeyedHashSet[] contributions) throws IOException {
        Contribution elt;
        FileOutputStream fosNamespace = new FileOutputStream(contributionsFile);
        DataOutputStream outputNamespace = new DataOutputStream(new BufferedOutputStream(fosNamespace));
        KeyedElement[] newElements = contributions[0].elements();
        KeyedElement[] formerElements = contributions[1].elements();
        outputNamespace.writeInt(newElements.length + formerElements.length);
        int i = 0;
        while (i < newElements.length) {
            elt = (Contribution)newElements[i];
            outputNamespace.writeLong(elt.getContributingBundle().getBundleId());
            this.saveArray(elt.getRawChildren(), outputNamespace);
            ++i;
        }
        i = 0;
        while (i < formerElements.length) {
            elt = (Contribution)formerElements[i];
            outputNamespace.writeLong(elt.getContributingBundle().getBundleId());
            this.saveArray(elt.getRawChildren(), outputNamespace);
            ++i;
        }
        outputNamespace.flush();
        fosNamespace.getFD().sync();
        outputNamespace.close();
    }

    private void saveTables(RegistryObjectManager objectManager, long registryTimeStamp) throws IOException {
        FileOutputStream fosTable = new FileOutputStream(tableFile);
        DataOutputStream outputTable = new DataOutputStream(new BufferedOutputStream(fosTable));
        this.writeCacheHeader(outputTable, registryTimeStamp);
        outputTable.writeInt(objectManager.getNextId());
        this.offsets.save(outputTable);
        objectManager.getExtensionPoints().save(outputTable);
        outputTable.flush();
        fosTable.getFD().sync();
        outputTable.close();
    }

    private void writeCacheHeader(DataOutputStream output, long registryTimeStamp) throws IOException {
        output.writeInt(1);
        output.writeLong(InternalPlatform.getDefault().getStateTimeStamp());
        output.writeLong(registryTimeStamp);
        output.writeLong(mainDataFile.length());
        output.writeLong(extraDataFile.length());
        output.writeLong(contributionsFile.length());
        output.writeLong(orphansFile.length());
        InternalPlatform info = InternalPlatform.getDefault();
        output.writeUTF(info.getOS());
        output.writeUTF(info.getWS());
        output.writeUTF(info.getNL());
    }

    private void saveArray(int[] array, DataOutputStream out) throws IOException {
        if (array == null) {
            out.writeInt(0);
            return;
        }
        out.writeInt(array.length);
        int i = 0;
        while (i < array.length) {
            out.writeInt(array[i]);
            ++i;
        }
    }

    private void saveExtensionPoint(ExtensionPointHandle xpt) throws IOException {
        this.offsets.put(xpt.getId(), this.mainOutput.size());
        this.mainOutput.writeInt(xpt.getId());
        this.saveArray(xpt.getObject().getRawChildren(), this.mainOutput);
        this.mainOutput.writeInt(this.getExtraDataPosition());
        this.saveExtensionPointData(xpt);
        this.saveExtensions(xpt.getExtensions(), this.mainOutput);
    }

    private void saveExtension(ExtensionHandle ext, DataOutputStream outputStream) throws IOException {
        this.offsets.put(ext.getId(), outputStream.size());
        outputStream.writeInt(ext.getId());
        this.writeStringOrNull(ext.getSimpleIdentifier(), outputStream);
        this.writeStringOrNull(ext.getNamespace(), outputStream);
        this.saveArray(ext.getObject().getRawChildren(), outputStream);
        outputStream.writeInt(this.getExtraDataPosition());
        this.saveExtensionData(ext);
    }

    private void writeStringArray(String[] array, DataOutputStream outputStream) throws IOException {
        outputStream.writeInt(array == null ? 0 : array.length);
        int i = 0;
        while (i < (array == null ? 0 : array.length)) {
            this.writeStringOrNull(array[i], outputStream);
            ++i;
        }
    }

    private void saveConfigurationElement(ConfigurationElementHandle element, DataOutputStream outputStream, DataOutputStream extraOutputStream, int depth) throws IOException {
        DataOutputStream currentOutput = outputStream;
        if (depth > 2) {
            currentOutput = extraOutputStream;
        }
        this.offsets.put(element.getId(), currentOutput.size());
        currentOutput.writeInt(element.getId());
        ConfigurationElement actualCe = (ConfigurationElement)element.getObject();
        currentOutput.writeLong(actualCe.getContributingBundle().getBundleId());
        this.writeStringOrNull(actualCe.getName(), currentOutput);
        currentOutput.writeInt(actualCe.parentId);
        currentOutput.writeByte(actualCe.parentType);
        currentOutput.writeInt(depth > 1 ? extraOutputStream.size() : -1);
        this.writeStringArray(actualCe.getPropertiesAndValue(), currentOutput);
        this.saveArray(actualCe.getRawChildren(), currentOutput);
        ConfigurationElementHandle[] childrenCEs = (ConfigurationElementHandle[])element.getChildren();
        int i = 0;
        while (i < childrenCEs.length) {
            this.saveConfigurationElement(childrenCEs[i], outputStream, extraOutputStream, depth + 1);
            ++i;
        }
    }

    private void saveExtensions(IExtension[] exts, DataOutputStream outputStream) throws IOException {
        int i = 0;
        while (i < exts.length) {
            this.saveExtension((ExtensionHandle)exts[i], outputStream);
            ++i;
        }
        i = 0;
        while (i < exts.length) {
            IConfigurationElement[] ces = exts[i].getConfigurationElements();
            outputStream.writeInt(ces.length);
            int j = 0;
            while (j < ces.length) {
                this.saveConfigurationElement((ConfigurationElementHandle)ces[j], outputStream, this.extraOutput, 1);
                ++j;
            }
            ++i;
        }
    }

    private void saveExtensionPointData(ExtensionPointHandle xpt) throws IOException {
        this.writeStringOrNull(xpt.getLabel(), this.extraOutput);
        this.writeStringOrNull(xpt.getSchemaReference(), this.extraOutput);
        this.writeStringOrNull(xpt.getUniqueIdentifier(), this.extraOutput);
        this.writeStringOrNull(xpt.getNamespace(), this.extraOutput);
        this.extraOutput.writeLong(((ExtensionPoint)xpt.getObject()).getBundleId());
    }

    private void saveExtensionData(ExtensionHandle extension) throws IOException {
        this.writeStringOrNull(extension.getLabel(), this.extraOutput);
        this.writeStringOrNull(extension.getExtensionPointUniqueIdentifier(), this.extraOutput);
    }

    private void writeStringOrNull(String string, DataOutputStream out) throws IOException {
        if (string == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeUTF(string);
        }
    }

    private void saveOrphans(RegistryObjectManager objectManager) throws IOException {
        Map.Entry entry;
        Map orphans = objectManager.getOrphanExtensions();
        FileOutputStream fosOrphan = new FileOutputStream(orphansFile);
        DataOutputStream outputOrphan = new DataOutputStream(new BufferedOutputStream(fosOrphan));
        outputOrphan.writeInt(orphans.size());
        Set elements = orphans.entrySet();
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            outputOrphan.writeUTF((String)entry.getKey());
            this.saveArray((int[])entry.getValue(), outputOrphan);
        }
        iter = elements.iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            this.mainOutput.writeInt(((int[])entry.getValue()).length);
            this.saveExtensions((IExtension[])objectManager.getHandles((int[])entry.getValue(), (byte)2), this.mainOutput);
        }
        outputOrphan.flush();
        fosOrphan.getFD().sync();
        outputOrphan.close();
    }
}

