/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.preference;

import com.clustercontrol.performance.PerformancePlugin;
import com.clustercontrol.performance.util.RealtimeCollectorInfo;
import com.clustercontrol.performance.util.RealtimeCollectorItemInfo;
import java.io.IOException;
import java.sql.Date;
import java.util.ArrayList;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PerformancePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String EJB_URL = "ejbUrl";
    public static final String COLLECTOR_ID = "collectorID";
    public static final String PATH_LABEL = "pathLabel";
    public static final String PERF_FACILITY_ID = "facilityId";
    public static final String PERF_SUB_SCOPE_NUM = "subScopeNum";
    public static final String PERF_GRAPH_NUM = "graphNum";
    public static final String[] PERF_SUB_SCOPE_FACILITY_ID = new String[]{"subScopeFacilityId01", "subScopeFacilityId02", "subScopeFacilityId03", "subScopeFacilityId04", "subScopeFacilityId05", "subScopeFacilityId06", "subScopeFacilityId07", "subScopeFacilityId08", "subScopeFacilityId09", "subScopeFacilityId10"};
    public static final String[] PERF_SUB_SCOPE_FACILITY_NAME = new String[]{"subScopeFacilityName01", "subScopeFacilityName02", "subScopeFacilityName03", "subScopeFacilityName04", "subScopeFacilityName05", "subScopeFacilityName06", "subScopeFacilityName07", "subScopeFacilityName08", "subScopeFacilityName09", "subScopeFacilityName10"};
    public static final String PERF_GRAPH_START_TIME = "graphStartTime";
    public static final String PERF_GRAPH_END_TIME = "graphEndTime";
    public static final String PERF_GRAPH_PLOT_NUM = "graphPlotNum";
    public static final String[][] PERF_ITEM_INFO = new String[][]{{"itemInfo11", "itemInfo12", "itemInfo13", "itemInfo14", "itemInfo15"}, {"itemInfo21", "itemInfo22", "itemInfo23", "itemInfo24", "itemInfo25"}, {"itemInfo31", "itemInfo32", "itemInfo33", "itemInfo34", "itemInfo35"}, {"itemInfo41", "itemInfo42", "itemInfo43", "itemInfo44", "itemInfo45"}};
    public static final String[][] PERF_ITEM_FOR_BOOLEAN = new String[][]{{"itemInfoForBoolean11"}, {"itemInfoForBoolean12"}, {"itemInfoForBoolean13"}, {"itemInfoForBoolean14"}};

    protected PerformancePreferencePage(int style) {
        super(style);
    }

    public PerformancePreferencePage() {
        super(1);
        this.setPreferenceStore(PerformancePlugin.getDefault().getPreferenceStore());
    }

    private void initializeDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setDefault(COLLECTOR_ID, "");
        store.setDefault(PATH_LABEL, "");
        store.setDefault(PERF_FACILITY_ID, "");
        store.setDefault(PERF_GRAPH_NUM, 4);
        store.setDefault(PERF_SUB_SCOPE_NUM, "");
        int i = 0;
        while (i < 10) {
            store.setDefault(PERF_SUB_SCOPE_FACILITY_ID[i], "");
            store.setDefault(PERF_SUB_SCOPE_FACILITY_NAME[i], "");
            ++i;
        }
        store.setDefault(PERF_GRAPH_START_TIME, "");
        store.setDefault(PERF_GRAPH_END_TIME, "");
        store.setDefault(PERF_GRAPH_PLOT_NUM, "");
        i = 0;
        while (i < store.getDefaultInt(PERF_GRAPH_NUM)) {
            store.setDefault(PERF_ITEM_INFO[i][0], "");
            store.setDefault(PERF_ITEM_INFO[i][1], "");
            store.setDefault(PERF_ITEM_INFO[i][2], "");
            store.setDefault(PERF_ITEM_INFO[i][3], "");
            store.setDefault(PERF_ITEM_INFO[i][4], "");
            store.setDefault(PERF_ITEM_FOR_BOOLEAN[i][0], "");
            ++i;
        }
    }

    public void createFieldEditors() {
    }

    public void setCollectorId(String collectorId) {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue(COLLECTOR_ID, collectorId);
    }

    public String getCollectorId() {
        IPreferenceStore store = this.getPreferenceStore();
        return store.getString(COLLECTOR_ID);
    }

    public void setPathLabel(String pathLabel) {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue(PATH_LABEL, pathLabel);
    }

    public String getPathLabel() {
        IPreferenceStore store = this.getPreferenceStore();
        return store.getString(PATH_LABEL);
    }

    public void setRealtimeCollectorInfo(RealtimeCollectorInfo info) {
        IPreferenceStore store = this.getPreferenceStore();
        ArrayList list = info.getSubScopeFacilityName();
        store.setValue(PERF_FACILITY_ID, info.getFacilityId());
        store.setValue(PERF_GRAPH_NUM, info.getGraphNum());
        store.setValue(PERF_SUB_SCOPE_NUM, info.getSubScopeNum());
        int i = 0;
        while (i < info.getSubScopeNum()) {
            store.setValue(PERF_SUB_SCOPE_FACILITY_ID[i], info.getSubScopeFacilityId(i));
            store.setValue(PERF_SUB_SCOPE_FACILITY_NAME[i], (String)list.get(i));
            ++i;
        }
        store.setValue(PERF_GRAPH_START_TIME, info.getGraphStartTime().getTime());
        store.setValue(PERF_GRAPH_END_TIME, info.getGraphEndTime().getTime());
        store.setValue(PERF_GRAPH_PLOT_NUM, info.getGraphPlotNum());
    }

    public RealtimeCollectorInfo getRealtimeCollectorInfo(RealtimeCollectorInfo info) {
        IPreferenceStore store = this.getPreferenceStore();
        ArrayList<String> subScopeFacilityId = new ArrayList<String>();
        ArrayList<String> subScopeFacilityName = new ArrayList<String>();
        info.setFacilityId(store.getString(PERF_FACILITY_ID));
        info.setGraphNum(store.getInt(PERF_GRAPH_NUM));
        int i = 0;
        while (i < store.getInt(PERF_SUB_SCOPE_NUM)) {
            subScopeFacilityId.add(store.getString(PERF_SUB_SCOPE_FACILITY_ID[i]));
            subScopeFacilityName.add(store.getString(PERF_SUB_SCOPE_FACILITY_NAME[i]));
            ++i;
        }
        info.setSubScopeFacilityId(subScopeFacilityId);
        info.setSubScopeFacilityName(subScopeFacilityName);
        info.setSubScopeNum(store.getInt(PERF_SUB_SCOPE_NUM));
        Date date_start = new Date(store.getLong(PERF_GRAPH_START_TIME));
        Date date_end = new Date(store.getLong(PERF_GRAPH_END_TIME));
        info.setGraphStartTime(date_start);
        info.setGraphEndTime(date_end);
        info.setGraphPlotNum(store.getInt(PERF_GRAPH_PLOT_NUM));
        return info;
    }

    public void setRealtimeCollectorItemInfo(RealtimeCollectorItemInfo itemInfo) {
        IPreferenceStore store = this.getPreferenceStore();
        int i = 0;
        while (i < store.getInt(PERF_GRAPH_NUM)) {
            store.setValue(PERF_ITEM_INFO[i][0], itemInfo.getItemCode(i));
            store.setValue(PERF_ITEM_INFO[i][1], itemInfo.getDisplayType(i));
            store.setValue(PERF_ITEM_INFO[i][2], itemInfo.getDeviceIndex(i));
            store.setValue(PERF_ITEM_INFO[i][3], itemInfo.getItemId(i));
            if (itemInfo.getDeviceName(i) != null) {
                store.setValue(PERF_ITEM_INFO[i][4], itemInfo.getDeviceName(i));
            }
            store.setValue(PERF_ITEM_FOR_BOOLEAN[i][0], itemInfo.getItemDetailed(i));
            ++i;
        }
    }

    public RealtimeCollectorItemInfo getRealtimeCollectorItemInfo(RealtimeCollectorItemInfo itemInfo) {
        IPreferenceStore store = this.getPreferenceStore();
        int i = 0;
        while (i < 4) {
            itemInfo.setItemInfo(i, store.getString(PERF_ITEM_INFO[i][0]), store.getString(PERF_ITEM_INFO[i][1]), store.getString(PERF_ITEM_INFO[i][2]), store.getString(PERF_ITEM_INFO[i][3]), store.getString(PERF_ITEM_INFO[i][4]), store.getBoolean(PERF_ITEM_FOR_BOOLEAN[i][0]));
            ++i;
        }
        return itemInfo;
    }

    public boolean savePreference() {
        IPreferenceStore store = this.getPreferenceStore();
        if (store != null && store.needsSaving() && store instanceof IPersistentPreferenceStore) {
            try {
                ((IPersistentPreferenceStore)store).save();
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return true;
    }

    public void init(IWorkbench workbench) {
    }
}

