/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.collectiverun.composite;

import com.clustercontrol.collectiverun.action.GetTree;
import com.clustercontrol.collectiverun.bean.TreeItem;
import com.clustercontrol.collectiverun.composite.TreeContentProvider;
import com.clustercontrol.collectiverun.composite.TreeLabelProvider;
import com.clustercontrol.collectiverun.composite.TreeViewerSorter;
import com.clustercontrol.collectiverun.composite.action.CopyTreeItemAction;
import com.clustercontrol.collectiverun.composite.action.CreateTreeItemSelectionListener;
import com.clustercontrol.collectiverun.composite.action.DeleteTreeItemSelectionListener;
import com.clustercontrol.collectiverun.composite.action.UpDownTreeItemSelectionListener;
import com.clustercontrol.collectiverun.composite.action.UpdateTreeItemSelectionListener;
import com.clustercontrol.util.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;

public class TreeComposite
extends Composite {
    private TreeViewer m_viewer = null;
    private TreeItem selectItem = null;
    private TreeItem createItem = null;
    private TreeItem updateItem = null;

    public TreeComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(5, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        GridData gridData = null;
        Tree tree = new Tree((Composite)this, 2052);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 5;
        tree.setLayoutData((Object)gridData);
        Button buttonCreate = new Button((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        buttonCreate.setLayoutData((Object)gridData);
        buttonCreate.setText(Messages.getString((String)"create"));
        buttonCreate.addSelectionListener((SelectionListener)new CreateTreeItemSelectionListener(this));
        Button buttonDelete = new Button((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        buttonDelete.setLayoutData((Object)gridData);
        buttonDelete.setText(Messages.getString((String)"delete"));
        buttonDelete.addSelectionListener((SelectionListener)new DeleteTreeItemSelectionListener(this));
        Button buttonUp = new Button((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        buttonUp.setLayoutData((Object)gridData);
        buttonUp.setText(Messages.getString((String)"up"));
        buttonUp.addSelectionListener((SelectionListener)new UpDownTreeItemSelectionListener(this, true));
        Button buttonDown = new Button((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        buttonDown.setLayoutData((Object)gridData);
        buttonDown.setText(Messages.getString((String)"down"));
        buttonDown.addSelectionListener((SelectionListener)new UpDownTreeItemSelectionListener(this, false));
        Button buttonUpdate = new Button((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        buttonUpdate.setLayoutData((Object)gridData);
        buttonUpdate.setText(Messages.getString((String)"update"));
        buttonUpdate.addSelectionListener((SelectionListener)new UpdateTreeItemSelectionListener(this));
        this.m_viewer = new TreeViewer(tree);
        this.m_viewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.m_viewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        this.m_viewer.setSorter((ViewerSorter)new TreeViewerSorter());
        this.createContextMenu();
        this.update();
    }

    public TreeViewer getTreeViewer() {
        return this.m_viewer;
    }

    public Tree getTree() {
        return this.m_viewer.getTree();
    }

    public void update() {
        TreeItem tree = null;
        this.selectItem = null;
        this.createItem = null;
        this.updateItem = null;
        GetTree getTree = new GetTree();
        tree = getTree.getTree();
        this.m_viewer.setInput((Object)tree);
        this.m_viewer.expandToLevel(2);
    }

    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TreeComposite.this.fillContextMenu(manager);
            }
        });
        Menu treeMenu = menuManager.createContextMenu((Control)this.getTree());
        this.getTree().setMenu(treeMenu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        CopyTreeItemAction copyAction = new CopyTreeItemAction(this);
        manager.add((IAction)copyAction);
        TreeItem select = this.getSelectItem();
        if (select instanceof TreeItem) {
            if (select.getInfo().getType() == -1 || select.getInfo().getType() == -2 || select.getInfo().getType() == -3 || this.createItem != null || this.updateItem != null) {
                copyAction.setEnabled(false);
            } else {
                copyAction.setEnabled(true);
            }
        }
    }

    public TreeItem getSelectItem() {
        return this.selectItem;
    }

    public void setSelectItem(TreeItem selectItem) {
        this.selectItem = selectItem;
    }

    public TreeItem getCreateItem() {
        return this.createItem;
    }

    public void setCreateItem(TreeItem createItem) {
        this.createItem = createItem;
    }

    public TreeItem getUpdateItem() {
        return this.updateItem;
    }

    public void setUpdateItem(TreeItem updateItem) {
        this.updateItem = updateItem;
    }
}

