/*
 * Decompiled with CFR 0.152.
 */
package org.vafada.swtcalendar;

import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Locale;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.vafada.swtcalendar.SWTDayChooser;

public class SWTMonthChooser
extends Composite {
    private SWTDayChooser dayChooser;
    private Combo comboBox;
    private Locale locale = Locale.getDefault();

    public SWTMonthChooser(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.comboBox = new Combo((Composite)this, 12);
        this.initNames();
        this.setMonth(Calendar.getInstance().get(2));
        this.setFont(parent.getFont());
    }

    private void initNames() {
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this.locale);
        String[] monthNames = dateFormatSymbols.getMonths();
        int month = this.comboBox.getSelectionIndex();
        if (this.comboBox.getItemCount() > 0) {
            this.comboBox.removeAll();
        }
        int i = 0;
        while (i < monthNames.length) {
            String name = monthNames[i];
            if (name.length() > 0) {
                this.comboBox.add(name);
            }
            ++i;
        }
        if (month < 0) {
            month = 0;
        } else if (month >= this.comboBox.getItemCount()) {
            month = this.comboBox.getItemCount() - 1;
        }
        this.comboBox.select(month);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.comboBox.addSelectionListener(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.comboBox.removeSelectionListener(listener);
    }

    public void setMonth(int newMonth) {
        this.comboBox.select(newMonth);
    }

    public int getMonth() {
        return this.comboBox.getSelectionIndex();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.initNames();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.comboBox.setFont(this.getFont());
    }
}

