/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.composite;

import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.jobmanagement.action.GetJobList;
import com.clustercontrol.jobmanagement.action.GetJobTableDefine;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class JobListComposite
extends Composite {
    protected CommonTableViewer m_viewer = null;
    protected Label m_path = null;
    protected JobTreeItem m_jobTreeItem = null;
    protected JobTreeItem m_selectJobTreeItem = null;

    public JobListComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.m_path = new Label((Composite)this, 16384);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.m_path.setLayoutData((Object)gridData);
        Table table = new Table((Composite)this, 66308);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData((Object)gridData);
        this.m_viewer = new CommonTableViewer(table);
        this.m_viewer.createTableColumn(GetJobTableDefine.get(), 0, 1);
    }

    public TableViewer getTableViewer() {
        return this.m_viewer;
    }

    public Table getTable() {
        return this.m_viewer.getTable();
    }

    public void update(JobTreeItem item) {
        if (item instanceof JobTreeItem) {
            this.m_path.setText(String.valueOf(Messages.getString((String)"job")) + " : " + item.getPath());
        } else {
            this.m_path.setText(String.valueOf(Messages.getString((String)"job")) + " : ");
        }
        this.m_jobTreeItem = item;
        this.m_selectJobTreeItem = null;
        ArrayList jobInfo = null;
        GetJobList getJobList = new GetJobList();
        jobInfo = getJobList.getJobList(item);
        this.m_viewer.setInput((Object)jobInfo);
    }

    public JobTreeItem getSelectJobTreeItem() {
        return this.m_selectJobTreeItem;
    }

    public void setSelectJobTreeItem(JobTreeItem jobTreeItem) {
        this.m_selectJobTreeItem = jobTreeItem;
    }

    public JobTreeItem getJobTreeItem() {
        return this.m_jobTreeItem;
    }

    public void setJobTreeItem(JobTreeItem jobTreeItem) {
        this.m_jobTreeItem = jobTreeItem;
    }
}

