/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.composite;

import com.clustercontrol.performance.util.CollectorItemCodeFactory;
import com.clustercontrol.performance.util.Messages;
import com.clustercontrol.performance.util.RealtimeCollectorInfo;
import com.clustercontrol.performance.util.RealtimeCollectorItemInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class RealtimeGraphComposite
extends Composite {
    private Composite[] graphComposite = null;
    public TimeSeries[] m_timeseries;
    public ChartPanel chartPanel = null;
    private Label infoLabel;
    private boolean isCollect = false;
    private RealtimeCollectorInfo collectorInfo = null;
    private RealtimeCollectorItemInfo collectorItemInfo = null;
    private ValueAxis valueaxis = null;
    private int graphPlotNum = 0;
    private int interval = 0;
    private JFreeChart[] jfreechart = null;
    private Frame graphFrame = null;
    static /* synthetic */ Class class$0;

    public RealtimeGraphComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        this.graphComposite = new Composite[4];
        this.jfreechart = new JFreeChart[4];
    }

    public void addGraph(int graphId, String itemCode, String deviceName, int subScopeNum, String displayType, int interval, boolean isXRangeAuto, int graphPlotNum) {
        this.isCollect = false;
        this.graphPlotNum = graphPlotNum;
        this.interval = interval;
        if (!displayType.equals("NonDisplay")) {
            this.createGraphComposite(graphId, itemCode, deviceName, subScopeNum, displayType, interval, isXRangeAuto, graphPlotNum);
        }
    }

    private void createGraphComposite(int graphId, String itemCode, String deviceName, int subScopeNum, String displayType, int interval, boolean isXRangeAuto, int graphPlotNum) {
        if (!this.collectorItemInfo.hasDevice(graphId)) {
            this.graphComposite[graphId] = new Composite((Composite)this, 0);
            this.infoLabel = new Label(this.graphComposite[graphId], 0x1000000);
            this.infoLabel.setText(String.valueOf(Messages.getString("DEVICE")) + " \"" + this.collectorItemInfo.getDeviceName(graphId) + "\" " + Messages.getString("NOT_EXIST"));
        } else if (displayType.equals("SubScope") && subScopeNum == 0) {
            this.graphComposite[graphId] = new Composite((Composite)this, 0);
            this.infoLabel = new Label(this.graphComposite[graphId], 0x1000000);
            this.infoLabel.setText(Messages.getString("NOT_EXIST_SUBSCOPE"));
        } else if (displayType.equals("SubScope") && subScopeNum > 10) {
            this.graphComposite[graphId] = new Composite((Composite)this, 0);
            this.infoLabel = new Label(this.graphComposite[graphId], 0);
            this.infoLabel.setText(Messages.getString("MSG_SUB_SCOPE_COUNTS_OVER_10"));
        } else {
            this.graphComposite[graphId] = new Composite((Composite)this, 0x1000000);
            this.setJFreeChart(graphId, interval, displayType, itemCode, deviceName, isXRangeAuto, graphPlotNum);
            this.graphFrame = SWT_AWT.new_Frame((Composite)this.graphComposite[graphId]);
            this.graphFrame.add((Component)this.chartPanel);
            this.isCollect = true;
        }
        GridData graphGridData = new GridData();
        graphGridData.horizontalAlignment = 4;
        graphGridData.verticalAlignment = 4;
        graphGridData.grabExcessHorizontalSpace = true;
        graphGridData.grabExcessVerticalSpace = true;
        GridLayout graphLayout = new GridLayout(1, true);
        this.graphComposite[graphId].setLayout((Layout)graphLayout);
        graphLayout.marginHeight = 0;
        graphLayout.marginWidth = 0;
        this.graphComposite[graphId].setLayoutData((Object)graphGridData);
    }

    private void setJFreeChart(int graphId, int interval, String displayType, String itemCode, String deviceName, boolean isXRangeAuto, int graphPlotNum) {
        List graphObjectList = new ArrayList();
        if (displayType.equals("SelectedScope")) {
            graphObjectList.add(0, itemCode);
        } else if (displayType.equals("SubScope")) {
            graphObjectList = this.collectorInfo.getSubScopeFacilityName();
        } else if (displayType.equals("Detail")) {
            graphObjectList = CollectorItemCodeFactory.getSubItemCode(itemCode);
        }
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection();
        int graphNum = 0;
        graphNum = graphObjectList.size() > 10 ? 10 : graphObjectList.size();
        this.m_timeseries = new TimeSeries[graphNum];
        String displayNoteName = null;
        if (graphNum > 0) {
            int i = 0;
            while (i < graphNum) {
                if (displayType.equals("SubScope")) {
                    displayNoteName = graphObjectList.get(i).toString();
                } else if (displayType.equals("Detail")) {
                    displayNoteName = CollectorItemCodeFactory.getItemName(graphObjectList.get(i).toString());
                } else if (displayType.equals("SelectedScope")) {
                    displayNoteName = graphObjectList.get(i).toString();
                }
                this.m_timeseries[i] = new TimeSeries(displayNoteName, Second.class);
                this.m_timeseries[i].setMaximumItemCount(200);
                timeSeriesCollection.addSeries(this.m_timeseries[i]);
                ++i;
            }
        }
        this.chartPanel = new ChartPanel(this.createChart(graphId, itemCode, deviceName, displayType, (XYDataset)timeSeriesCollection, interval, isXRangeAuto, graphPlotNum));
    }

    private JFreeChart createChart(int graphId, String itemCode, String deviceName, String displayType, XYDataset xydataset, int interval, boolean isXRangeAuto, int graphPlotNum) {
        String displayTypeName = Messages.getString("NULL");
        boolean displayNote = false;
        if (displayType.equals("SelectedScope")) {
            displayTypeName = Messages.getString("SCOPE_REPRESENTING_VALUE");
        } else if (displayType.equals("Detail")) {
            displayTypeName = Messages.getString("DETAIL_SCOPE_REPRESENTING_VALUE");
            displayNote = true;
        } else if (displayType.equals("SubScope")) {
            displayTypeName = Messages.getString("SUB_SCOPE_REP_VAL");
            displayNote = true;
        }
        String displayName = null;
        displayName = String.valueOf(CollectorItemCodeFactory.getFullItemName(itemCode, deviceName)) + " " + displayTypeName;
        this.jfreechart[graphId] = ChartFactory.createTimeSeriesChart((String)displayName, (String)Messages.getString("TIME"), (String)CollectorItemCodeFactory.getMeasure(itemCode), (XYDataset)xydataset, (boolean)displayNote, (boolean)true, (boolean)false);
        XYPlot xyplot = this.jfreechart[graphId].getXYPlot();
        this.valueaxis = xyplot.getDomainAxis();
        this.valueaxis.setAutoRange(true);
        if (!isXRangeAuto) {
            this.valueaxis.setFixedAutoRange((double)interval * 1000.0 * (double)graphPlotNum);
        }
        this.valueaxis = xyplot.getRangeAxis();
        if (CollectorItemCodeFactory.isRangeFixed(itemCode)) {
            this.valueaxis.setRange(0.0, 100.0);
        }
        if (displayType.equals("Detail")) {
            XYAreaRenderer xyRenderer = new XYAreaRenderer();
            xyplot.setRenderer((XYItemRenderer)xyRenderer);
        } else if (displayType.equals("SubScope")) {
            XYItemRenderer xyRenderer = xyplot.getRenderer();
            xyRenderer.setSeriesPaint(0, (Paint)Color.BLACK);
            xyRenderer.setSeriesPaint(1, (Paint)Color.BLUE);
            xyRenderer.setSeriesPaint(2, (Paint)Color.GREEN);
            xyRenderer.setSeriesPaint(3, (Paint)Color.PINK);
            xyRenderer.setSeriesPaint(4, (Paint)Color.CYAN);
            xyRenderer.setSeriesPaint(5, (Paint)Color.LIGHT_GRAY);
            xyRenderer.setSeriesPaint(6, (Paint)Color.MAGENTA);
            xyRenderer.setSeriesPaint(7, (Paint)Color.ORANGE);
            xyRenderer.setSeriesPaint(8, (Paint)Color.YELLOW);
            xyRenderer.setSeriesPaint(9, (Paint)Color.GRAY);
        }
        return this.jfreechart[graphId];
    }

    public boolean isCollect() {
        return this.isCollect;
    }

    public void setCollectorInfo(RealtimeCollectorInfo collectorInfo) {
        this.collectorInfo = collectorInfo;
    }

    public void setCollectorItemInfo(RealtimeCollectorItemInfo collectorItemInfo) {
        this.collectorItemInfo = collectorItemInfo;
    }

    public void setValueaxisRange(double graphPlotNum, int interval) {
        int i = 0;
        while (i < this.collectorInfo.getGraphNum()) {
            if (this.collectorItemInfo.isCollect(i) && this.jfreechart[i] != null) {
                XYPlot xyplot = this.jfreechart[i].getXYPlot();
                this.valueaxis = xyplot.getDomainAxis();
                if (graphPlotNum != this.valueaxis.getFixedAutoRange() * (double)interval * 1000.0) {
                    if (graphPlotNum == 0.0) {
                        this.valueaxis.setAutoRange(true);
                    } else if (graphPlotNum > 0.0 && interval == this.interval) {
                        this.valueaxis.setFixedAutoRange((double)interval * 1000.0 * graphPlotNum);
                    }
                } else if (interval != this.interval && interval > 0) {
                    this.valueaxis.setFixedAutoRange((double)interval * 1000.0 * graphPlotNum);
                    this.interval = interval;
                }
            }
            ++i;
        }
    }
}

