/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.callback;

import java.util.HashMap;
import javax.persistence.EntityListener;
import javax.persistence.PersistenceException;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import org.hibernate.ejb.callback.Callback;
import org.hibernate.ejb.callback.CallbackResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityCallbackHandler {
    private HashMap<Class, Callback> preCreates = new HashMap();
    private HashMap<Class, Callback> postCreates = new HashMap();
    private HashMap<Class, Callback> preRemoves = new HashMap();
    private HashMap<Class, Callback> postRemoves = new HashMap();
    private HashMap<Class, Callback> preUpdates = new HashMap();
    private HashMap<Class, Callback> postUpdates = new HashMap();
    private HashMap<Class, Callback> postLoads = new HashMap();

    public void add(Class entity) {
        this.addCallback(entity, this.preCreates, PrePersist.class);
        this.addCallback(entity, this.postCreates, PostPersist.class);
        this.addCallback(entity, this.preRemoves, PreRemove.class);
        this.addCallback(entity, this.postRemoves, PostRemove.class);
        this.addCallback(entity, this.preUpdates, PreUpdate.class);
        this.addCallback(entity, this.postUpdates, PostUpdate.class);
        this.addCallback(entity, this.postLoads, PostLoad.class);
    }

    public boolean preCreate(Object bean) {
        return this.callback(this.preCreates.get(bean.getClass()), bean);
    }

    public boolean postCreate(Object bean) {
        return this.callback(this.postCreates.get(bean.getClass()), bean);
    }

    public boolean preRemove(Object bean) {
        return this.callback(this.preRemoves.get(bean.getClass()), bean);
    }

    public boolean postRemove(Object bean) {
        return this.callback(this.postRemoves.get(bean.getClass()), bean);
    }

    public boolean preUpdate(Object bean) {
        return this.callback(this.preUpdates.get(bean.getClass()), bean);
    }

    public boolean postUpdate(Object bean) {
        return this.callback(this.postUpdates.get(bean.getClass()), bean);
    }

    public boolean postLoad(Object bean) {
        return this.callback(this.postLoads.get(bean.getClass()), bean);
    }

    private boolean callback(Callback callback, Object bean) {
        if (callback != null) {
            callback.invoke(bean);
            return true;
        }
        return false;
    }

    private void addCallback(Class entity, HashMap<Class, Callback> map, Class annotation) {
        Callback callback = null;
        for (Class clazz = entity; callback == null && clazz != null; clazz = clazz.getSuperclass()) {
            callback = this.resolveCallback(clazz, annotation);
            if (callback == null) continue;
            map.put(entity, callback);
            break;
        }
    }

    private Callback resolveCallback(Class entity, Class annotation) {
        Class listener = null;
        EntityListener cl = entity.getAnnotation(EntityListener.class);
        try {
            if (cl != null) {
                listener = cl.value();
            }
            return CallbackResolver.resolveCallback(entity, annotation, listener);
        }
        catch (ClassNotFoundException e) {
            throw new PersistenceException("Could not load CallbackListener class " + cl.value() + " for bean " + entity.getName());
        }
        catch (Exception e) {
            throw new PersistenceException(e.getCause());
        }
    }
}

