/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb;

import java.util.Iterator;
import java.util.Properties;
import org.hibernate.ejb.EJB3AutoFlushEventListener;
import org.hibernate.ejb.EJB3FlushEventListener;
import org.hibernate.ejb.Ejb3Configuration;
import org.hibernate.ejb.callback.EJB3DeleteEventListener;
import org.hibernate.ejb.callback.EJB3FlushEntityEventListener;
import org.hibernate.ejb.callback.EJB3MergeEventListener;
import org.hibernate.ejb.callback.EJB3PersistEventListener;
import org.hibernate.ejb.callback.EJB3PostDeleteEventListener;
import org.hibernate.ejb.callback.EJB3PostInsertEventListener;
import org.hibernate.ejb.callback.EJB3PostLoadEventListener;
import org.hibernate.ejb.callback.EJB3PostUpdateEventListener;
import org.hibernate.ejb.callback.EJB3SaveEventListener;
import org.hibernate.ejb.callback.EJB3SaveOrUpdateEventListener;
import org.hibernate.ejb.callback.EntityCallbackHandler;
import org.hibernate.event.AutoFlushEventListener;
import org.hibernate.event.DeleteEventListener;
import org.hibernate.event.EventListeners;
import org.hibernate.event.FlushEntityEventListener;
import org.hibernate.event.FlushEventListener;
import org.hibernate.event.MergeEventListener;
import org.hibernate.event.PersistEventListener;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostLoadEventListener;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.event.PreDeleteEventListener;
import org.hibernate.event.PreInsertEventListener;
import org.hibernate.event.PreLoadEventListener;
import org.hibernate.event.PreUpdateEventListener;
import org.hibernate.event.SaveOrUpdateEventListener;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.secure.JACCPreDeleteEventListener;
import org.hibernate.secure.JACCPreInsertEventListener;
import org.hibernate.secure.JACCPreLoadEventListener;
import org.hibernate.secure.JACCPreUpdateEventListener;
import org.hibernate.validator.event.ValidateEventListener;

public class EventListenerConfigurator {
    private Properties properties;
    private Ejb3Configuration configuration;
    private boolean isValidator;
    private boolean isSecurity;

    public void setConfiguration(Ejb3Configuration configuration) {
        this.configuration = configuration;
    }

    public void setValidator(boolean validator) {
        this.isValidator = validator;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
        if (properties.containsKey("hibernate.jacc.enabled")) {
            this.isSecurity = true;
        }
    }

    public void configure() {
        int listenerIndex;
        PreInsertEventListener[] listeners;
        int eventNbr;
        ValidateEventListener validateEventListener = null;
        if (this.isValidator) {
            validateEventListener = new ValidateEventListener();
        }
        EntityCallbackHandler callbackHandler = new EntityCallbackHandler();
        this.configuration.buildMappings();
        Iterator classes = this.configuration.getClassMappings();
        while (classes.hasNext()) {
            PersistentClass clazz = (PersistentClass)classes.next();
            callbackHandler.add(clazz.getMappedClass());
        }
        EventListeners listenerConfig = this.configuration.getEventListeners();
        listenerConfig.setFlushEventListeners(new FlushEventListener[]{EJB3FlushEventListener.INSTANCE});
        listenerConfig.setAutoFlushEventListeners(new AutoFlushEventListener[]{EJB3AutoFlushEventListener.INSTANCE});
        listenerConfig.setDeleteEventListeners(new DeleteEventListener[]{new EJB3DeleteEventListener(callbackHandler)});
        listenerConfig.setFlushEntityEventListeners(new FlushEntityEventListener[]{new EJB3FlushEntityEventListener(callbackHandler)});
        listenerConfig.setMergeEventListeners(new MergeEventListener[]{new EJB3MergeEventListener(callbackHandler)});
        listenerConfig.setPersistEventListeners(new PersistEventListener[]{new EJB3PersistEventListener(callbackHandler)});
        listenerConfig.setSaveEventListeners(new SaveOrUpdateEventListener[]{new EJB3SaveEventListener(callbackHandler)});
        listenerConfig.setSaveOrUpdateEventListeners(new SaveOrUpdateEventListener[]{new EJB3SaveOrUpdateEventListener(callbackHandler)});
        if (this.isSecurity || this.isValidator) {
            eventNbr = this.isSecurity && this.isValidator ? 2 : (this.isSecurity || this.isValidator ? 1 : 0);
            listeners = new PreInsertEventListener[eventNbr];
            listenerIndex = 0;
            if (this.isSecurity) {
                listeners[listenerIndex] = new JACCPreInsertEventListener();
                ++listenerIndex;
            }
            if (this.isValidator) {
                listeners[listenerIndex] = validateEventListener;
                ++listenerIndex;
            }
            listenerConfig.setPreInsertEventListeners(listeners);
        }
        if (this.isSecurity || this.isValidator) {
            eventNbr = this.isSecurity && this.isValidator ? 2 : (this.isSecurity || this.isValidator ? 1 : 0);
            listeners = new PreUpdateEventListener[eventNbr];
            listenerIndex = 0;
            if (this.isSecurity) {
                listeners[listenerIndex] = new JACCPreUpdateEventListener();
                ++listenerIndex;
            }
            if (this.isValidator) {
                listeners[listenerIndex] = validateEventListener;
                ++listenerIndex;
            }
            listenerConfig.setPreUpdateEventListeners((PreUpdateEventListener[])listeners);
        }
        if (this.isSecurity) {
            PreDeleteEventListener[] listeners2 = new PreDeleteEventListener[1];
            int listenerIndex2 = 0;
            listeners2[listenerIndex2] = new JACCPreDeleteEventListener();
            ++listenerIndex2;
            listenerConfig.setPreDeleteEventListeners(listeners2);
        }
        if (this.isSecurity) {
            PreLoadEventListener[] listeners3 = new PreLoadEventListener[1];
            int listenerIndex3 = 0;
            listeners3[listenerIndex3] = new JACCPreLoadEventListener();
            ++listenerIndex3;
            listenerConfig.setPreLoadEventListeners(listeners3);
        }
        listenerConfig.setPostDeleteEventListeners(new PostDeleteEventListener[]{new EJB3PostDeleteEventListener(callbackHandler)});
        listenerConfig.setPostInsertEventListeners(new PostInsertEventListener[]{new EJB3PostInsertEventListener(callbackHandler)});
        listenerConfig.setPostLoadEventListeners(new PostLoadEventListener[]{new EJB3PostLoadEventListener(callbackHandler)});
        listenerConfig.setPostUpdateEventListeners(new PostUpdateEventListener[]{new EJB3PostUpdateEventListener(callbackHandler)});
    }
}

