/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.providers.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.holders.Holder;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPHeaderElement;
import org.jboss.axis.AxisFault;
import org.jboss.axis.Constants;
import org.jboss.axis.Message;
import org.jboss.axis.MessageContext;
import org.jboss.axis.MessagePart;
import org.jboss.axis.description.OperationDesc;
import org.jboss.axis.description.ParameterDesc;
import org.jboss.axis.description.ServiceDesc;
import org.jboss.axis.enums.Style;
import org.jboss.axis.enums.Use;
import org.jboss.axis.handlers.soap.SOAPService;
import org.jboss.axis.message.RPCElement;
import org.jboss.axis.message.RPCHeaderParam;
import org.jboss.axis.message.RPCParam;
import org.jboss.axis.message.RPCParamElementImpl;
import org.jboss.axis.message.SOAPBodyElementAxisImpl;
import org.jboss.axis.message.SOAPElementAxisImpl;
import org.jboss.axis.message.SOAPEnvelopeAxisImpl;
import org.jboss.axis.providers.java.RPCProvider;
import org.jboss.axis.soap.SOAPConstants;
import org.jboss.axis.utils.JavaUtils;
import org.jboss.axis.utils.Messages;
import org.jboss.logging.Logger;
import org.w3c.dom.Element;

public class RPCInvocation {
    private static Logger log = Logger.getLogger((String)RPCInvocation.class.getName());
    private RPCProvider rpcProvider;
    private MessageContext messageContext;
    private SOAPEnvelopeAxisImpl requestEnvelope;
    private SOAPEnvelopeAxisImpl responseEnvelope;
    private Object targetObject;
    private OperationDesc opDesc;
    private Object[] argValues;
    private Object returnValue;
    private RPCElement body;
    private List outParams;
    private boolean responsePrepared;
    static /* synthetic */ Class class$javax$activation$DataHandler;
    static /* synthetic */ Class class$javax$xml$rpc$holders$Holder;

    public RPCInvocation(RPCProvider rpcProvider, MessageContext messageContext, SOAPEnvelopeAxisImpl reqEnv, SOAPEnvelopeAxisImpl resEnv, Object targetObject) {
        this.rpcProvider = rpcProvider;
        this.messageContext = messageContext;
        this.requestEnvelope = reqEnv;
        this.responseEnvelope = resEnv;
        this.targetObject = targetObject;
    }

    public RPCInvocation(RPCInvocation invocation) {
        this.rpcProvider = invocation.rpcProvider;
        this.messageContext = invocation.messageContext;
        this.requestEnvelope = invocation.requestEnvelope;
        this.responseEnvelope = invocation.responseEnvelope;
        this.targetObject = invocation.targetObject;
        this.responsePrepared = invocation.responsePrepared;
    }

    public RPCProvider getProvider() {
        return this.rpcProvider;
    }

    public void prepareFromRequestEnvelope() {
        log.debug((Object)("Enter: prepareFromRequestEnvelope\n" + this.requestEnvelope));
        SOAPService service = this.messageContext.getService();
        ServiceDesc serviceDesc = service.getServiceDescription();
        this.opDesc = this.messageContext.getOperation();
        try {
            ParameterDesc firstInParam;
            Vector bodies = this.requestEnvelope.getBodyElements();
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage("bodyElems00", "" + bodies.size()));
                log.debug((Object)Messages.getMessage("bodyIs00", "" + bodies.get(0)));
            }
            for (int bNum = 0; this.body == null && bNum < bodies.size(); ++bNum) {
                if (!(bodies.get(bNum) instanceof RPCElement)) {
                    ParameterDesc param;
                    SOAPBodyElementAxisImpl bodyEl = (SOAPBodyElementAxisImpl)bodies.get(bNum);
                    if (!bodyEl.isRoot() || this.opDesc == null || bodyEl.getID() != null || (param = this.opDesc.getParameter(bNum)) == null) continue;
                    Object val = bodyEl.getValueAsType(param.getTypeQName());
                    this.body = new RPCElement("", this.opDesc.getName(), new Object[]{val});
                    continue;
                }
                this.body = (RPCElement)bodies.get(bNum);
            }
            if (this.body == null) {
                if (!serviceDesc.getStyle().equals(Style.DOCUMENT)) {
                    throw new JAXRPCException(Messages.getMessage("noBody00"));
                }
                ArrayList ops = serviceDesc.getOperations();
                Iterator iterator = ops.iterator();
                while (iterator.hasNext()) {
                    OperationDesc desc = (OperationDesc)iterator.next();
                    if (desc.getNumInParams() != 0) continue;
                    this.messageContext.setOperation(desc);
                    this.body = new RPCElement(desc.getName());
                    break;
                }
                if (this.body == null) {
                    throw new JAXRPCException(Messages.getMessage("noBody00"));
                }
            }
            String methodName = this.body.getMethodName();
            Vector args = this.body.getParams();
            int numArgs = args.size();
            this.opDesc = this.messageContext.getOperation();
            if (this.opDesc == null) {
                QName qname = new QName(this.body.getNamespaceURI(), this.body.getName());
                this.opDesc = this.getOperation(serviceDesc, qname);
            }
            if (this.opDesc == null) {
                Vector headers = this.requestEnvelope.getHeaders();
                for (int i = 0; i < headers.size(); ++i) {
                    SOAPHeaderElement header = (SOAPHeaderElement)headers.elementAt(i);
                    if (!header.getMustUnderstand()) continue;
                    AxisFault fault = new AxisFault(Messages.getMessage("noSuchOperation", methodName));
                    fault.setFaultCode(Constants.FAULT_MUSTUNDERSTAND);
                    throw new JAXRPCException((Throwable)fault);
                }
                throw new JAXRPCException(Messages.getMessage("noSuchOperation", methodName));
            }
            this.argValues = new Object[this.opDesc.getNumParams()];
            this.outParams = new ArrayList();
            boolean isGenericDocumentEndpoint = false;
            Style style = serviceDesc.getStyle();
            Use use = serviceDesc.getUse();
            if (style.equals(Style.DOCUMENT) && use.equals(Use.LITERAL) && this.opDesc.getInParams().size() == 1 && Element.class.isAssignableFrom((firstInParam = (ParameterDesc)this.opDesc.getInParams().get(0)).getJavaType())) {
                isGenericDocumentEndpoint = true;
                this.argValues[0] = this.body;
            }
            if (!isGenericDocumentEndpoint) {
                for (int i = 0; i < numArgs; ++i) {
                    RPCParam rpcParam = (RPCParam)args.get(i);
                    Object value = rpcParam.getValue();
                    ParameterDesc paramDesc = rpcParam.getParamDesc();
                    if (paramDesc != null && paramDesc.getJavaType() != null) {
                        Class sigType = paramDesc.getJavaType();
                        if (value instanceof AttachmentPart) {
                            value = sigType.equals(class$javax$activation$DataHandler == null ? RPCInvocation.class$("javax.activation.DataHandler") : class$javax$activation$DataHandler) ? ((AttachmentPart)value).getDataHandler() : ((AttachmentPart)value).getContent();
                        }
                        value = JavaUtils.convert(value, sigType);
                        rpcParam.setValue(value);
                        if (paramDesc.getMode() == 3) {
                            this.outParams.add(rpcParam);
                        }
                    }
                    if (paramDesc == null || paramDesc.getOrder() == -1) {
                        this.argValues[i] = value;
                    } else {
                        this.argValues[paramDesc.getOrder()] = value;
                    }
                    log.debug((Object)("  " + Messages.getMessage("value00", "" + this.argValues[i])));
                }
            }
            String allowedMethods = (String)service.getOption("allowedMethods");
            this.rpcProvider.checkMethodName(this.messageContext, allowedMethods, this.opDesc.getName());
            int count = numArgs;
            for (int i = 0; i < this.argValues.length; ++i) {
                ParameterDesc param = this.opDesc.getParameter(i);
                if (param.getMode() == 1) continue;
                Class holderClass = param.getJavaType();
                if (holderClass != null && (class$javax$xml$rpc$holders$Holder == null ? RPCInvocation.class$("javax.xml.rpc.holders.Holder") : class$javax$xml$rpc$holders$Holder).isAssignableFrom(holderClass)) {
                    int index = count++;
                    if (param.getMode() != 2 && param.getMode() == 3) {
                        if (param.getOrder() != -1) {
                            index = param.getOrder();
                        } else {
                            ++count;
                        }
                        if (this.argValues[index] != null) continue;
                    }
                    this.argValues[index] = holderClass.newInstance();
                    RPCParam p = new RPCParam(param.getQName(), this.argValues[index]);
                    p.setParamDesc(param);
                    this.outParams.add(p);
                    continue;
                }
                String message = Messages.getMessage("badOutParameter00", "" + param.getQName(), this.opDesc.getName());
                log.error((Object)message);
                throw new JAXRPCException(message);
            }
            log.debug((Object)"Exit: prepareFromRequestEnvelope");
        }
        catch (JAXRPCException e) {
            log.error((Object)e.toString(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error((Object)e.toString(), (Throwable)e);
            throw new JAXRPCException((Throwable)e);
        }
    }

    public OperationDesc getOperation(ServiceDesc serviceDesc, QName qname) {
        return serviceDesc.getOperationByElementQName(qname);
    }

    public void prepareResponseEnvelope(Object resObject) {
        this.returnValue = resObject;
        log.debug((Object)("Enter: prepareResponseEnvelope: [resObject=" + resObject + "]"));
        if (this.responsePrepared) {
            log.debug((Object)"Ignoring request to prepare response envelope");
            log.debug((Object)("Exit: prepareResponseEnvelope\n" + this.responseEnvelope));
            return;
        }
        SOAPService service = this.messageContext.getService();
        ServiceDesc serviceDesc = service.getServiceDescription();
        ArrayList<SOAPElementAxisImpl> immutableElements = new ArrayList<SOAPElementAxisImpl>();
        try {
            String encodingStyle = this.messageContext.getEncodingStyle();
            String bodyEncStyle = this.responseEnvelope.getBody().getEncodingStyle();
            if (!bodyEncStyle.equals(encodingStyle)) {
                if (bodyEncStyle.equals("")) {
                    this.responseEnvelope.getBody().setEncodingStyle(encodingStyle);
                } else {
                    log.warn((Object)("Mixed encoding styles are not supported: " + bodyEncStyle + "!=" + encodingStyle));
                }
            }
            RPCElement resBody = null;
            boolean isGenericDocumentReturn = false;
            Style style = serviceDesc.getStyle();
            Use use = serviceDesc.getUse();
            if (style.equals(Style.DOCUMENT) && use.equals(Use.LITERAL) && resObject != null && Element.class.isAssignableFrom(resObject.getClass())) {
                Element resElement = (Element)resObject;
                resBody = new RPCElement(resElement.getLocalName());
                resBody.setPrefix(resElement.getPrefix());
                resBody.setNamespaceURI(resElement.getNamespaceURI());
                immutableElements.add(resBody);
                isGenericDocumentReturn = true;
            }
            if (!isGenericDocumentReturn) {
                String methodName = this.opDesc.getMethod().getName();
                resBody = new RPCElement(methodName + "Response");
                resBody.setPrefix(this.body.getPrefix());
                resBody.setNamespaceURI(this.body.getNamespaceURI());
                immutableElements.add(resBody);
            }
            if (this.opDesc.getMethod().getReturnType() != Void.TYPE) {
                Class retType;
                QName returnQName = this.opDesc.getReturnQName();
                if (returnQName == null) {
                    String methodName = this.opDesc.getMethod().getName();
                    returnQName = new QName(this.body.getNamespaceURI(), methodName + "Response");
                }
                ParameterDesc retParamDesc = this.opDesc.getReturnParamDesc();
                QName retTypeQName = retParamDesc.getTypeQName();
                if (resObject != null && retTypeQName != null && (retType = this.messageContext.getTypeMapping().getClassForQName(retTypeQName)) != null && JavaUtils.isConvertable(resObject, retType)) {
                    resObject = JavaUtils.convert(resObject, retType);
                }
                RPCParam param = new RPCParam(returnQName, resObject);
                param.setParamDesc(retParamDesc);
                param.setRPCCall(resBody);
                if (this.opDesc.getUse().equals(Use.LITERAL)) {
                    param.setXSITypeGeneration(Boolean.TRUE);
                }
                RPCParamElementImpl paramElement = new RPCParamElementImpl(param);
                resBody.addChildElement(paramElement);
                immutableElements.add(paramElement);
                if (!this.opDesc.isReturnHeader()) {
                    if (this.messageContext.getSOAPConstants() == SOAPConstants.SOAP12_CONSTANTS && serviceDesc.getStyle().equals(Style.RPC)) {
                        RPCParam resultParam = new RPCParam(Constants.QNAME_RPC_RESULT, (Object)returnQName);
                        resultParam.setXSITypeGeneration(Boolean.FALSE);
                        resBody.addParam(resultParam);
                    }
                    resBody.addParam(param);
                } else {
                    this.responseEnvelope.addHeader(new RPCHeaderParam(param));
                }
            }
            if (!this.outParams.isEmpty()) {
                Iterator i = this.outParams.iterator();
                while (i.hasNext()) {
                    RPCParam param = (RPCParam)i.next();
                    Object value = param.getValue();
                    if (value instanceof Holder) {
                        Holder holder = (Holder)value;
                        value = JavaUtils.getHolderValue(holder);
                    }
                    ParameterDesc paramDesc = param.getParamDesc();
                    param.setValue(value);
                    if (paramDesc != null && paramDesc.isOutHeader()) {
                        this.responseEnvelope.addHeader(new RPCHeaderParam(param));
                        continue;
                    }
                    resBody.addParam(param);
                }
            }
            this.responseEnvelope.addBodyElement(resBody);
            this.responsePrepared = true;
            Iterator it = immutableElements.iterator();
            while (it.hasNext()) {
                SOAPElementAxisImpl soapElement = (SOAPElementAxisImpl)it.next();
                soapElement.setImmutable(true);
            }
            this.messageContext.setPastPivot(true);
            Message respMessage = (Message)this.messageContext.getMessage();
            ((MessagePart)respMessage.getSOAPPart()).setSOAPEnvelope(this.responseEnvelope);
            log.debug((Object)("Exit: prepareResponseEnvelope\n" + this.responseEnvelope));
        }
        catch (JAXRPCException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JAXRPCException((Throwable)e);
        }
    }

    public Object[] getArgValues() {
        return this.argValues;
    }

    public RPCElement getBody() {
        return this.body;
    }

    public MessageContext getMessageContext() {
        return this.messageContext;
    }

    public OperationDesc getOperation() {
        return this.opDesc;
    }

    public List getOutParams() {
        return this.outParams;
    }

    public SOAPEnvelopeAxisImpl getRequestEnvelope() {
        return this.requestEnvelope;
    }

    public SOAPEnvelopeAxisImpl getResponseEnvelope() {
        return this.responseEnvelope;
    }

    public Object getTargetObject() {
        return this.targetObject;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer("\nRPCInvocation:\n");
        ret.append("TargetObject=" + this.targetObject + "\n");
        ret.append("Operation=" + this.opDesc);
        ret.append("ArgValues=" + (this.argValues != null ? Arrays.asList(this.argValues) : null) + "\n");
        ret.append("ReturnValue=" + this.returnValue + "\n");
        return ret.toString();
    }
}

