/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.CacheMode;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.Criteria;
import org.hibernate.EmptyInterceptor;
import org.hibernate.EntityMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.Query;
import org.hibernate.QueryException;
import org.hibernate.SQLQuery;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.SessionException;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.StatefulPersistenceContext;
import org.hibernate.engine.Versioning;
import org.hibernate.event.EventListeners;
import org.hibernate.hql.QueryTranslator;
import org.hibernate.id.IdentifierGeneratorFactory;
import org.hibernate.impl.AbstractSessionImpl;
import org.hibernate.impl.CriteriaImpl;
import org.hibernate.impl.QueryImpl;
import org.hibernate.impl.SQLQueryImpl;
import org.hibernate.impl.SessionFactoryImpl;
import org.hibernate.jdbc.Batcher;
import org.hibernate.jdbc.JDBCContext;
import org.hibernate.loader.criteria.CriteriaLoader;
import org.hibernate.loader.custom.CustomLoader;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.type.Type;
import org.hibernate.util.CollectionHelper;

public class StatelessSessionImpl
extends AbstractSessionImpl
implements JDBCContext.Context,
StatelessSession {
    private JDBCContext jdbcContext;
    private boolean closed;
    private PersistenceContext temporaryPersistenceContext = new StatefulPersistenceContext(this);

    StatelessSessionImpl(Connection connection, SessionFactoryImpl factory) {
        super(factory);
        this.jdbcContext = new JDBCContext(this, connection, EmptyInterceptor.INSTANCE);
    }

    public void delete(Object entity) {
        this.delete(null, entity);
    }

    public Serializable insert(Object entity) {
        return this.insert(null, entity);
    }

    public void update(Object entity) {
        this.update(null, entity);
    }

    public Serializable insert(String entityName, Object entity) {
        boolean substitute;
        EntityPersister persister = this.getEntityPersister(entityName, entity);
        Serializable id = persister.getIdentifierGenerator().generate(this, entity);
        Object[] state = persister.getPropertyValues(entity, EntityMode.POJO);
        if (persister.isVersioned() && (substitute = Versioning.seedVersion(state, persister.getVersionProperty(), persister.getVersionType(), this))) {
            persister.setPropertyValues(entity, state, EntityMode.POJO);
        }
        if (id == IdentifierGeneratorFactory.POST_INSERT_INDICATOR) {
            id = persister.insert(state, entity, this);
        } else {
            persister.insert(id, state, entity, this);
        }
        persister.setIdentifier(entity, id, EntityMode.POJO);
        return id;
    }

    public void update(String entityName, Object entity) {
        Object oldVersion;
        EntityPersister persister = this.getEntityPersister(entityName, entity);
        Serializable id = persister.getIdentifier(entity, EntityMode.POJO);
        Object[] state = persister.getPropertyValues(entity, EntityMode.POJO);
        if (persister.isVersioned()) {
            oldVersion = persister.getVersion(entity, EntityMode.POJO);
            Object newVersion = Versioning.increment(oldVersion, persister.getVersionType(), this);
            Versioning.setVersion(state, newVersion, persister);
            persister.setPropertyValues(entity, state, EntityMode.POJO);
        } else {
            oldVersion = null;
        }
        persister.update(id, state, null, false, null, oldVersion, entity, null, this);
    }

    public void delete(String entityName, Object entity) {
        EntityPersister persister = this.getEntityPersister(entityName, entity);
        Serializable id = persister.getIdentifier(entity, EntityMode.POJO);
        Object version = persister.getVersion(entity, EntityMode.POJO);
        persister.delete(id, version, entity, this);
    }

    public void close() {
        this.managedClose();
    }

    public ConnectionReleaseMode getConnectionReleaseMode() {
        return this.factory.getSettings().getConnectionReleaseMode();
    }

    public boolean isAutoCloseSessionEnabled() {
        return this.factory.getSettings().isAutoCloseSessionEnabled();
    }

    public boolean isFlushBeforeCompletionEnabled() {
        return true;
    }

    public boolean isFlushModeNever() {
        return false;
    }

    public void managedClose() {
        this.jdbcContext.getConnectionManager().close();
        this.closed = true;
    }

    public void managedFlush() {
        this.getBatcher().executeBatch();
    }

    public boolean shouldAutoClose() {
        return this.isAutoCloseSessionEnabled() && this.isOpen();
    }

    public void afterTransactionCompletion(boolean successful, Transaction tx) {
    }

    public void beforeTransactionCompletion(Transaction tx) {
    }

    public String bestGuessEntityName(Object object) {
        if (object instanceof HibernateProxy) {
            object = ((HibernateProxy)object).getHibernateLazyInitializer().getImplementation();
        }
        return this.guessEntityName(object);
    }

    public Connection connection() {
        return this.jdbcContext.userConnection();
    }

    public int executeUpdate(String query, QueryParameters queryParameters) throws HibernateException {
        return 0;
    }

    public Batcher getBatcher() {
        return this.jdbcContext.getConnectionManager().getBatcher();
    }

    public CacheMode getCacheMode() {
        return CacheMode.IGNORE;
    }

    public int getDontFlushFromFind() {
        return 0;
    }

    public Map getEnabledFilters() {
        return CollectionHelper.EMPTY_MAP;
    }

    public Serializable getContextEntityIdentifier(Object object) {
        return null;
    }

    public EntityMode getEntityMode() {
        return EntityMode.POJO;
    }

    public EntityPersister getEntityPersister(String entityName, Object object) throws HibernateException {
        if (entityName == null) {
            return this.factory.getEntityPersister(this.guessEntityName(object));
        }
        return this.factory.getEntityPersister(entityName).getSubclassEntityPersister(object, this.getFactory(), EntityMode.POJO);
    }

    public Object getEntityUsingInterceptor(EntityKey key) throws HibernateException {
        return null;
    }

    public SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    public Type getFilterParameterType(String filterParameterName) {
        throw new UnsupportedOperationException();
    }

    public Object getFilterParameterValue(String filterParameterName) {
        throw new UnsupportedOperationException();
    }

    public FlushMode getFlushMode() {
        return FlushMode.COMMIT;
    }

    public Interceptor getInterceptor() {
        return EmptyInterceptor.INSTANCE;
    }

    public EventListeners getListeners() {
        throw new UnsupportedOperationException();
    }

    public PersistenceContext getPersistenceContext() {
        return this.temporaryPersistenceContext;
    }

    public long getTimestamp() {
        throw new UnsupportedOperationException();
    }

    public Object get(Class entityClass, Serializable id) {
        return this.get(entityClass.getName(), id);
    }

    public Object get(Class entityClass, Serializable id, LockMode lockMode) {
        return this.get(entityClass.getName(), id, lockMode);
    }

    public Object get(String entityName, Serializable id) {
        return this.get(entityName, id, LockMode.NONE);
    }

    public Object get(String entityName, Serializable id, LockMode lockMode) {
        Object result = this.getFactory().getEntityPersister(entityName).load(id, null, lockMode, this);
        this.temporaryPersistenceContext.clear();
        return result;
    }

    public String guessEntityName(Object entity) throws HibernateException {
        return entity.getClass().getName();
    }

    public Object immediateLoad(String entityName, Serializable id) throws HibernateException {
        throw new SessionException("proxies cannot be fetched by a stateless session");
    }

    public void initializeCollection(PersistentCollection collection, boolean writing) throws HibernateException {
        throw new SessionException("collections cannot be fetched by a stateless session");
    }

    public Object instantiate(String entityName, Serializable id) throws HibernateException {
        return this.getFactory().getEntityPersister(entityName).instantiate(id, EntityMode.POJO);
    }

    public Object internalLoad(String entityName, Serializable id, boolean eager, boolean nullable) throws HibernateException {
        EntityPersister persister = this.getFactory().getEntityPersister(entityName);
        if (!eager && persister.hasProxy()) {
            return persister.createProxy(id, this);
        }
        Object loaded = this.temporaryPersistenceContext.getEntity(new EntityKey(id, persister, EntityMode.POJO));
        return loaded == null ? this.get(entityName, id) : loaded;
    }

    public boolean isConnected() {
        return this.jdbcContext.getConnectionManager().isCurrentlyConnected();
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public boolean isTransactionInProgress() {
        return this.jdbcContext.isTransactionInProgress();
    }

    public Iterator iterate(String query, QueryParameters queryParameters) throws HibernateException {
        throw new UnsupportedOperationException();
    }

    public Iterator iterateFilter(Object collection, String filter, QueryParameters queryParameters) throws HibernateException {
        throw new UnsupportedOperationException();
    }

    public List listFilter(Object collection, String filter, QueryParameters queryParameters) throws HibernateException {
        throw new UnsupportedOperationException();
    }

    public void setAutoClear(boolean enabled) {
        throw new UnsupportedOperationException();
    }

    public void setCacheMode(CacheMode cm) {
        throw new UnsupportedOperationException();
    }

    public void setFlushMode(FlushMode fm) {
        throw new UnsupportedOperationException();
    }

    public Transaction getTransaction() throws HibernateException {
        return this.jdbcContext.getTransaction();
    }

    public Transaction beginTransaction() throws HibernateException {
        Transaction result = this.getTransaction();
        result.begin();
        return result;
    }

    public boolean isEventSource() {
        return false;
    }

    public Query createQuery(String queryString) {
        QueryImpl query = new QueryImpl(queryString, this);
        query.setComment(queryString);
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List list(String query, QueryParameters queryParameters) throws HibernateException {
        queryParameters.validateParameters();
        QueryTranslator[] q = this.getQueries(query, false);
        List results = CollectionHelper.EMPTY_LIST;
        boolean success = false;
        try {
            for (int i = 0; i < q.length; ++i) {
                List currentResults = q[i].list(this, queryParameters);
                currentResults.addAll(results);
                results = currentResults;
            }
            success = true;
        }
        finally {
            this.afterOperation(success);
        }
        this.temporaryPersistenceContext.clear();
        return results;
    }

    public void afterOperation(boolean success) {
        if (!this.jdbcContext.isTransactionInProgress()) {
            this.jdbcContext.afterNontransactionalQuery(success);
        }
    }

    private QueryTranslator[] getQueries(String query, boolean scalar) throws HibernateException {
        QueryTranslator[] q = this.factory.getQuery(query, scalar, this.getEnabledFilters());
        return this.prepareQueries(q);
    }

    private QueryTranslator[] prepareQueries(QueryTranslator[] q) {
        HashSet qs = new HashSet();
        for (int i = 0; i < q.length; ++i) {
            qs.addAll(q[i].getQuerySpaces());
        }
        return q;
    }

    public Criteria createCriteria(Class persistentClass, String alias) {
        return new CriteriaImpl(persistentClass.getName(), alias, this);
    }

    public Criteria createCriteria(String entityName, String alias) {
        return new CriteriaImpl(entityName, alias, this);
    }

    public Criteria createCriteria(Class persistentClass) {
        return new CriteriaImpl(persistentClass.getName(), this);
    }

    public Criteria createCriteria(String entityName) {
        return new CriteriaImpl(entityName, this);
    }

    public ScrollableResults scroll(CriteriaImpl criteria, ScrollMode scrollMode) {
        String entityName = criteria.getEntityOrClassName();
        CriteriaLoader loader = new CriteriaLoader(this.getOuterJoinLoadable(entityName), this.factory, criteria, entityName, this.getEnabledFilters());
        return loader.scroll(this, scrollMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List list(CriteriaImpl criteria) throws HibernateException {
        String[] implementors = this.factory.getImplementors(criteria.getEntityOrClassName());
        int size = implementors.length;
        CriteriaLoader[] loaders = new CriteriaLoader[size];
        HashSet spaces = new HashSet();
        for (int i = 0; i < size; ++i) {
            loaders[i] = new CriteriaLoader(this.getOuterJoinLoadable(implementors[i]), this.factory, criteria, implementors[i], this.getEnabledFilters());
            spaces.addAll(loaders[i].getQuerySpaces());
        }
        List results = Collections.EMPTY_LIST;
        boolean success = false;
        try {
            for (int i = 0; i < size; ++i) {
                List currentResults = loaders[i].list(this);
                currentResults.addAll(results);
                results = currentResults;
            }
            success = true;
        }
        finally {
            this.afterOperation(success);
        }
        this.temporaryPersistenceContext.clear();
        return results;
    }

    private OuterJoinLoadable getOuterJoinLoadable(String entityName) throws MappingException {
        EntityPersister persister = this.factory.getEntityPersister(entityName);
        if (!(persister instanceof OuterJoinLoadable)) {
            throw new MappingException("class persister is not OuterJoinLoadable: " + entityName);
        }
        return (OuterJoinLoadable)persister;
    }

    public SQLQuery createSQLQuery(String sql) {
        SQLQueryImpl query = new SQLQueryImpl(sql, (SessionImplementor)this);
        query.setComment("dynamic native SQL query");
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List listCustomQuery(CustomQuery customQuery, QueryParameters queryParameters) throws HibernateException {
        List results;
        CustomLoader loader = new CustomLoader(customQuery, this.getFactory());
        boolean success = false;
        try {
            results = loader.list(this, queryParameters);
            success = true;
        }
        finally {
            this.afterOperation(success);
        }
        this.temporaryPersistenceContext.clear();
        return results;
    }

    public ScrollableResults scrollCustomQuery(CustomQuery customQuery, QueryParameters queryParameters) throws HibernateException {
        CustomLoader loader = new CustomLoader(customQuery, this.getFactory());
        return loader.scroll(queryParameters, this);
    }

    public ScrollableResults scroll(String query, QueryParameters queryParameters) throws HibernateException {
        QueryTranslator[] q = this.factory.getQuery(query, false, this.getEnabledFilters());
        if (q.length != 1) {
            throw new QueryException("implicit polymorphism not supported for scroll() queries");
        }
        return q[0].scroll(queryParameters, this);
    }

    public void afterScrollOperation() {
        this.temporaryPersistenceContext.clear();
    }

    public void flush() {
    }

    public String getFetchProfile() {
        return null;
    }

    public void setFetchProfile(String name) {
    }

    public void afterTransactionBegin(Transaction tx) {
    }
}

