/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.Session;
import org.hibernate.TransientObjectException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.ForeignKeys;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.IdentifierGeneratorFactory;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public class ForeignGenerator
implements IdentifierGenerator,
Configurable {
    private String propertyName;
    private String entityName;

    public Serializable generate(SessionImplementor sessionImplementor, Object object) throws HibernateException {
        Serializable id;
        Session session = (Session)((Object)sessionImplementor);
        Object associatedObject = sessionImplementor.getFactory().getClassMetadata(this.entityName).getPropertyValue(object, this.propertyName, session.getEntityMode());
        if (associatedObject == null) {
            throw new IdentifierGenerationException("attempted to assign id from null one-to-one property: " + this.propertyName);
        }
        EntityType type = (EntityType)sessionImplementor.getFactory().getClassMetadata(this.entityName).getPropertyType(this.propertyName);
        try {
            id = ForeignKeys.getEntityIdentifierIfNotUnsaved(type.getAssociatedEntityName(), associatedObject, sessionImplementor);
        }
        catch (TransientObjectException toe) {
            id = session.save(associatedObject);
        }
        if (session.contains(object)) {
            return IdentifierGeneratorFactory.SHORT_CIRCUIT_INDICATOR;
        }
        return id;
    }

    public void configure(Type type, Properties params, Dialect d) throws MappingException {
        this.propertyName = params.getProperty("property");
        this.entityName = params.getProperty("entity_name");
        if (this.propertyName == null) {
            throw new MappingException("param named \"property\" is required for foreign id generation strategy");
        }
    }
}

