/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;

public abstract class TransactionHelper {
    private static final Log log = LogFactory.getLog((Class)TransactionHelper.class);

    protected abstract Serializable doWorkInCurrentTransaction(Connection var1, String var2) throws SQLException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Serializable doWorkInNewTransaction(SessionImplementor session) throws HibernateException {
        Serializable serializable;
        Connection conn;
        block26: {
            TransactionManager tm = session.getFactory().getTransactionManager();
            Transaction surroundingTransaction = null;
            conn = null;
            String sql = null;
            boolean isJta = tm != null;
            boolean catchedException = false;
            try {
                try {
                    if (isJta) {
                        surroundingTransaction = tm.suspend();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"surrounding tx suspended");
                        }
                        tm.begin();
                        conn = session.getBatcher().openConnection();
                    } else {
                        conn = session.getBatcher().openConnection();
                        if (conn.getAutoCommit()) {
                            conn.setAutoCommit(false);
                        }
                    }
                    Serializable result = this.doWorkInCurrentTransaction(conn, sql);
                    if (isJta) {
                        session.getBatcher().closeConnection(conn);
                        tm.commit();
                    } else {
                        conn.commit();
                    }
                    serializable = result;
                    Object var11_16 = null;
                    if (!isJta) break block26;
                    if (!isJta) return serializable;
                    if (surroundingTransaction == null) return serializable;
                }
                catch (SQLException sqle) {
                    catchedException = true;
                    if (!isJta) throw JDBCExceptionHelper.convert(session.getFactory().getSQLExceptionConverter(), sqle, "could not get or update next value", sql);
                    try {
                        try {
                            if (!conn.isClosed()) {
                                session.getBatcher().closeConnection(conn);
                            }
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        tm.rollback();
                        throw JDBCExceptionHelper.convert(session.getFactory().getSQLExceptionConverter(), sqle, "could not get or update next value", sql);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    throw JDBCExceptionHelper.convert(session.getFactory().getSQLExceptionConverter(), sqle, "could not get or update next value", sql);
                }
                catch (Exception e) {
                    catchedException = true;
                    if (!isJta) throw new HibernateException(e);
                    try {
                        try {
                            if (!conn.isClosed()) {
                                session.getBatcher().closeConnection(conn);
                            }
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        tm.rollback();
                        throw new HibernateException(e);
                    }
                    catch (SystemException e1) {
                        throw new HibernateException(e1);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_17 = null;
                if (!isJta) {
                    session.getBatcher().closeConnection(conn);
                    throw throwable;
                }
                if (!isJta) throw throwable;
                if (surroundingTransaction == null) throw throwable;
                try {
                    tm.resume(surroundingTransaction);
                    if (!log.isDebugEnabled()) throw throwable;
                    log.debug((Object)"surrounding tx resumed");
                    throw throwable;
                }
                catch (Exception e) {
                    if (catchedException) throw throwable;
                    throw new HibernateException(e);
                }
            }
            try {}
            catch (Exception e) {
                if (catchedException) return serializable;
                throw new HibernateException(e);
            }
            tm.resume(surroundingTransaction);
            if (!log.isDebugEnabled()) return serializable;
            log.debug((Object)"surrounding tx resumed");
            return serializable;
        }
        session.getBatcher().closeConnection(conn);
        return serializable;
    }
}

