/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.factory;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.factory.PortRangeFactory;
import org.jacorb.orb.factory.ServerSocketFactory;

public class PortRangeServerSocketFactory
extends PortRangeFactory
implements ServerSocketFactory {
    public static final String MIN_PROP = "jacorb.net.server_socket_factory.port.min";
    public static final String MAX_PROP = "jacorb.net.server_socket_factory.port.max";
    private Logger logger;

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = (org.jacorb.config.Configuration)configuration;
        this.logger = this.configuration.getNamedLogger("jacorb.orb.port_rang_fctry");
        this.portMin = this.getPortProperty(MIN_PROP);
        this.portMax = this.getPortProperty(MAX_PROP);
        if (this.portMin > this.portMax) {
            throw new ConfigurationException("PortRangeFactory: minimum port number not less than or equal to maximum");
        }
    }

    public ServerSocket createServerSocket(int n, int n2) throws IOException {
        for (int i = this.portMin; i <= this.portMax; ++i) {
            try {
                ServerSocket serverSocket = new ServerSocket(i, n2);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("PortRangeServerSocketFactory: Created server socket at :" + i);
                }
                return serverSocket;
            }
            catch (IOException iOException) {
                continue;
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Cannot create server socket between ports " + this.portMin + " and " + this.portMax);
        }
        throw new BindException("PortRangeServerSocketFactory: no free port between " + this.portMin + " and " + this.portMax);
    }

    public ServerSocket createServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        for (int i = this.portMin; i <= this.portMax; ++i) {
            try {
                ServerSocket serverSocket = new ServerSocket(i, n2, inetAddress);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Created server socket at :" + i);
                }
                return serverSocket;
            }
            catch (IOException iOException) {
                continue;
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Cannot create server socket between ports " + this.portMin + " and " + this.portMax);
        }
        throw new BindException("PortRangeServerSocketFactory: no free port between " + this.portMin + " and " + this.portMax);
    }

    public ServerSocket createServerSocket(int n) throws IOException {
        for (int i = this.portMin; i <= this.portMax; ++i) {
            try {
                ServerSocket serverSocket = new ServerSocket(i);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Created server socket at :" + i);
                }
                return serverSocket;
            }
            catch (IOException iOException) {
                continue;
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Cannot create server socket between ports " + this.portMin + " and " + this.portMax);
        }
        throw new BindException("PortRangeServerSocketFactory: no free port between " + this.portMin + " and " + this.portMax);
    }
}

