/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import org.jacorb.notification.engine.PushSequenceOperation;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.servant.StructuredProxyPushSupplierImpl;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventChannelAdmin.TypeError;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.ProxyType;
import org.omg.CosNotifyChannelAdmin.SequenceProxyPushSupplierOperations;
import org.omg.CosNotifyChannelAdmin.SequenceProxyPushSupplierPOATie;
import org.omg.CosNotifyComm.SequencePushConsumer;
import org.omg.PortableServer.Servant;
import org.omg.TimeBase.TimeTHelper;

public class SequenceProxyPushSupplierImpl
extends StructuredProxyPushSupplierImpl
implements SequenceProxyPushSupplierOperations {
    static final StructuredEvent[] STRUCTURED_EVENT_ARRAY_TEMPLATE = new StructuredEvent[0];
    private SequencePushConsumer sequencePushConsumer_;
    private int maxBatchSize_;
    private long pacingInterval_;
    private Object taskId_;

    public ProxyType MyType() {
        return ProxyType.PUSH_SEQUENCE;
    }

    public void preActivate() throws UnsupportedQoS, Exception {
        super.preActivate();
        this.configureMaxBatchSize();
        this.configurePacingInterval();
    }

    public void deliverMessage(Message message) {
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("deliverEvent connected=" + this.isConnected() + " suspended=" + this.isSuspended() + " enabled=" + this.isEnabled());
        }
        if (this.isConnected()) {
            this.enqueue(message);
            if (!this.isSuspended() && this.isEnabled() && this.getPendingMessagesCount() >= this.maxBatchSize_) {
                this.deliverPendingMessages(false);
            }
        } else {
            this.logger_.debug("Not connected");
        }
    }

    public void deliverPendingData() {
        this.deliverPendingMessages(true);
    }

    private void deliverPendingMessages(boolean bl) {
        Message[] messageArray = bl ? this.getAllMessages() : this.getAtLeastMessages(this.maxBatchSize_);
        if (messageArray != null && messageArray.length > 0) {
            StructuredEvent[] structuredEventArray = new StructuredEvent[messageArray.length];
            for (int i = 0; i < messageArray.length; ++i) {
                structuredEventArray[i] = messageArray[i].toStructuredEvent();
                messageArray[i].dispose();
            }
            try {
                this.sequencePushConsumer_.push_structured_events(structuredEventArray);
                this.resetErrorCounter();
            }
            catch (Throwable throwable) {
                PushSequenceOperation pushSequenceOperation = new PushSequenceOperation(this.sequencePushConsumer_, structuredEventArray);
                this.handleFailedPushOperation(pushSequenceOperation, throwable);
            }
        }
    }

    public void connect_sequence_push_consumer(SequencePushConsumer sequencePushConsumer) throws AlreadyConnected, TypeError {
        this.logger_.debug("connect_sequence_push_consumer");
        this.assertNotConnected();
        this.sequencePushConsumer_ = sequencePushConsumer;
        this.connectClient(sequencePushConsumer);
        this.startCronJob();
    }

    protected void connectionResumed() {
        this.scheduleDeliverPendingMessagesOperation_.run();
        this.startCronJob();
    }

    protected void connectionSuspended() {
        this.stopCronJob();
    }

    public void disconnect_sequence_push_supplier() {
        this.dispose();
    }

    protected void disconnectClient() {
        this.stopCronJob();
        this.sequencePushConsumer_.disconnect_sequence_push_consumer();
        this.sequencePushConsumer_ = null;
    }

    private void startCronJob() {
        if (this.pacingInterval_ > 0L) {
            this.taskId_ = this.getTaskProcessor().executeTaskPeriodically(this.pacingInterval_, this.scheduleDeliverPendingMessagesOperation_, true);
        }
    }

    private synchronized void stopCronJob() {
        if (this.taskId_ != null) {
            this.getTaskProcessor().cancelTask(this.taskId_);
            this.taskId_ = null;
        }
    }

    private boolean configurePacingInterval() {
        long l;
        if (this.qosSettings_.containsKey("PacingInterval") && this.pacingInterval_ != (l = TimeTHelper.extract(this.qosSettings_.get("PacingInterval")))) {
            this.pacingInterval_ = l;
            return true;
        }
        return false;
    }

    private boolean configureMaxBatchSize() {
        int n = this.qosSettings_.get("MaximumBatchSize").extract_long();
        if (this.maxBatchSize_ != n) {
            if (this.logger_.isInfoEnabled()) {
                this.logger_.info("set MaxBatchSize=" + n);
            }
            this.maxBatchSize_ = n;
            return true;
        }
        return false;
    }

    public synchronized Servant getServant() {
        if (this.thisServant_ == null) {
            this.thisServant_ = new SequenceProxyPushSupplierPOATie(this);
        }
        return this.thisServant_;
    }
}

