/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.AbstractFilter;
import org.jacorb.notification.ApplicationContext;
import org.jacorb.notification.MappingFilterImpl;
import org.jacorb.notification.filter.etcl.ETCLFilter;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.servant.ManageableServant;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.UNKNOWN;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.FilterFactory;
import org.omg.CosNotifyFilter.FilterFactoryHelper;
import org.omg.CosNotifyFilter.FilterFactoryPOA;
import org.omg.CosNotifyFilter.FilterHelper;
import org.omg.CosNotifyFilter.InvalidGrammar;
import org.omg.CosNotifyFilter.MappingFilter;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.Servant;

public class FilterFactoryImpl
extends FilterFactoryPOA
implements Disposable,
Configurable,
ManageableServant {
    private ApplicationContext applicationContext_;
    private ORB orb_;
    private POA poa_;
    private boolean isApplicationContextCreatedHere_;
    private List allFilters_ = new ArrayList();
    private java.lang.Object allFiltersLock_ = this.allFilters_;
    private FilterFactory thisRef_;
    private Logger logger_ = null;
    private org.jacorb.config.Configuration config_ = null;
    private Object reference_;
    private Map availableFilters_ = new HashMap();
    static /* synthetic */ Class class$org$jacorb$notification$ApplicationContext;

    private static Iterator getAttributeNamesWithPrefix(Configuration configuration, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = configuration.getAttributeNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith(string)) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList.iterator();
    }

    public FilterFactoryImpl() throws InvalidName, AdapterInactive {
        this.orb_ = ORB.init(new String[0], null);
        this.poa_ = POAHelper.narrow(this.orb_.resolve_initial_references("RootPOA"));
        this.applicationContext_ = new ApplicationContext(this.orb_, this.poa_);
        this.applicationContext_.configure((Configuration)((org.jacorb.orb.ORB)this.orb_).getConfiguration());
        this.isApplicationContextCreatedHere_ = true;
        this.getFilterFactory();
        this.poa_.the_POAManager().activate();
        Thread thread = new Thread(new Runnable(){

            public void run() {
                FilterFactoryImpl.this.orb_.run();
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public FilterFactoryImpl(ApplicationContext applicationContext) {
        this.applicationContext_ = applicationContext;
        this.poa_ = applicationContext.getPoa();
        this.orb_ = applicationContext.getOrb();
        this.isApplicationContextCreatedHere_ = false;
    }

    private void loadFilterPlugins(Configuration configuration) throws ConfigurationException {
        Iterator iterator = FilterFactoryImpl.getAttributeNamesWithPrefix(configuration, "jacorb.notification.filter.plugin");
        while (iterator.hasNext()) {
            String string = null;
            String string2 = null;
            try {
                string = (String)iterator.next();
                String string3 = string.substring("jacorb.notification.filter.plugin".length() + 1);
                this.logger_.info("Loading Filterplugin for Grammar: " + string3);
                string2 = configuration.getAttribute(string);
                Class clazz = ObjectUtil.classForName(string2);
                Constructor constructor = clazz.getConstructor(class$org$jacorb$notification$ApplicationContext == null ? FilterFactoryImpl.class$("org.jacorb.notification.ApplicationContext") : class$org$jacorb$notification$ApplicationContext);
                this.availableFilters_.put(string3, constructor);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ConfigurationException("Property " + string + ": class " + string2 + " is unknown");
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new ConfigurationException("Property " + string + ": does the c'tor of class " + string2 + " accept param ApplicationContext ?");
            }
        }
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.config_ = (org.jacorb.config.Configuration)configuration;
        this.logger_ = this.config_.getNamedLogger(this.getClass().getName());
        this.loadFilterPlugins(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Filter create_filter(String string) throws InvalidGrammar {
        final AbstractFilter abstractFilter = this.create_filter_servant(string);
        abstractFilter.setORB(this.orb_);
        abstractFilter.setPOA(this.poa_);
        abstractFilter.preActivate();
        Filter filter = FilterHelper.narrow(abstractFilter.activate());
        java.lang.Object object = this.allFiltersLock_;
        synchronized (object) {
            this.allFilters_.add(abstractFilter);
            abstractFilter.setDisposeHook(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    java.lang.Object object = FilterFactoryImpl.this.allFiltersLock_;
                    synchronized (object) {
                        FilterFactoryImpl.this.allFilters_.remove(abstractFilter);
                    }
                }
            });
        }
        return filter;
    }

    private String getFilterGrammarNames() {
        Iterator iterator = this.availableFilters_.keySet().iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            stringBuffer.append(", ");
            stringBuffer.append(iterator.next());
        }
        return stringBuffer.toString();
    }

    private AbstractFilter create_filter_servant(String string) throws InvalidGrammar {
        AbstractFilter abstractFilter;
        if ("EXTENDED_TCL".equals(string)) {
            abstractFilter = new ETCLFilter(this.applicationContext_);
        } else if (this.availableFilters_.containsKey(string)) {
            try {
                Constructor constructor = (Constructor)this.availableFilters_.get(string);
                abstractFilter = (AbstractFilter)constructor.newInstance(this.applicationContext_);
            }
            catch (Exception exception) {
                this.logger_.fatalError("unable to create custom filter", (Throwable)exception);
                throw new UNKNOWN();
            }
        } else {
            throw new InvalidGrammar("Constraint Language '" + string + "' is not supported. Try one of the following: " + "EXTENDED_TCL" + this.getFilterGrammarNames());
        }
        abstractFilter.configure((Configuration)this.config_);
        return abstractFilter;
    }

    public MappingFilter create_mapping_filter(String string, Any any) throws InvalidGrammar {
        AbstractFilter abstractFilter = this.create_filter_servant(string);
        MappingFilterImpl mappingFilterImpl = new MappingFilterImpl(this.applicationContext_, abstractFilter, any);
        mappingFilterImpl.configure((Configuration)this.config_);
        MappingFilter mappingFilter = mappingFilterImpl._this(this.orb_);
        return mappingFilter;
    }

    public void setPOA(POA pOA) {
    }

    public void setORB(ORB oRB) {
    }

    public void preActivate() {
    }

    public void deactivate() {
        try {
            this.poa_.deactivate_object(this.poa_.servant_to_id(this.getServant()));
        }
        catch (Exception exception) {
            this.logger_.fatalError("cannot deactivate object", (Throwable)exception);
            throw new RuntimeException();
        }
    }

    private Servant getServant() {
        return this;
    }

    public synchronized Object activate() {
        if (this.reference_ == null) {
            this.reference_ = FilterFactoryHelper.narrow(this.getServant()._this_object(this.orb_));
        }
        return this.reference_;
    }

    public void dispose() {
        this.deactivate();
        Iterator iterator = this.getAllFilters().iterator();
        while (iterator.hasNext()) {
            Disposable disposable = (Disposable)iterator.next();
            iterator.remove();
            disposable.dispose();
        }
        if (this.isApplicationContextCreatedHere_) {
            this.orb_.shutdown(true);
            this.applicationContext_.dispose();
        }
    }

    public synchronized FilterFactory getFilterFactory() {
        if (this.thisRef_ == null) {
            this.thisRef_ = this._this(this.orb_);
        }
        return this.thisRef_;
    }

    public POA _default_POA() {
        return this.poa_;
    }

    public List getAllFilters() {
        return this.allFilters_;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

