/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.troubledetection.monitor;

import com.clustercontrol.monitor.message.LogOutputBasicInfo;
import com.clustercontrol.monitor.message.LogOutputInfo;
import com.clustercontrol.troubledetection.monitor.MonitorBase;
import com.clustercontrol.troubledetection.output.OutputLog;
import com.clustercontrol.troubledetection.util.NotifyMessages;
import java.util.Date;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MonitorLdap
extends MonitorBase {
    private static Log log = LogFactory.getLog(MonitorLdap.class);

    public void run() {
        InitialLdapContext dirCtx;
        InitialContext iniCtx;
        log.debug((Object)"run() start :");
        boolean providerServer = false;
        boolean consumerServer = false;
        try {
            iniCtx = new InitialContext();
            dirCtx = (InitialLdapContext)iniCtx.lookup("external/hinemos/ldap/provider");
            providerServer = true;
        }
        catch (NamingException e) {
            log.error((Object)("run() : LDAP Connection Error : " + e.getMessage()));
        }
        try {
            iniCtx = new InitialContext();
            dirCtx = (InitialLdapContext)iniCtx.lookup("external/hinemos/ldap/consumer");
            consumerServer = true;
        }
        catch (NamingException e) {
            log.error((Object)("run() : LDAP Connection Error : " + e.getMessage()));
        }
        this.logout(providerServer, consumerServer);
        log.debug((Object)"run() end :");
    }

    protected void logout(boolean providerServer, boolean consumerServer) {
        String application = NotifyMessages.getString("ldap.application");
        OutputLog output = new OutputLog(this.troubleDetectionInfo);
        if (providerServer && consumerServer) {
            LogOutputInfo info = new LogOutputInfo();
            info.setPluginId("SYSMON");
            info.setApplication(application);
            info.setMonitorId("LDAP01");
            info.setMessageId("001");
            info.setMessage(NotifyMessages.getString("ldap01.001.message"));
            Object[] args = new String[]{this.troubleDetectionInfo.getLdapProvider(), this.troubleDetectionInfo.getLdapConsumer()};
            info.setMessageOrg(NotifyMessages.getString("ldap01.001.org.message", args));
            info.setFacilityId("SYSTEM");
            info.setScopeText("");
            info.setPriority(this.getPriority(NotifyMessages.getString("ldap01.001.priority")));
            info.setGenerationDate(new Date());
            output.outputLog(this.notifyInfo, (LogOutputBasicInfo)info);
        } else if (!providerServer && consumerServer) {
            LogOutputInfo info = new LogOutputInfo();
            info.setPluginId("SYSMON");
            info.setApplication(application);
            info.setMonitorId("LDAP01");
            info.setMessageId("002");
            Object[] args1 = new String[]{this.troubleDetectionInfo.getLdapProvider()};
            info.setMessage(NotifyMessages.getString("ldap01.002.message", args1));
            Object[] args2 = new String[]{this.troubleDetectionInfo.getLdapProvider(), this.troubleDetectionInfo.getLdapConsumer()};
            info.setMessageOrg(NotifyMessages.getString("ldap01.002.org.message", args2));
            info.setFacilityId("SYSTEM");
            info.setScopeText("");
            info.setPriority(this.getPriority(NotifyMessages.getString("ldap01.002.priority")));
            info.setGenerationDate(new Date());
            output.outputLog(this.notifyInfo, (LogOutputBasicInfo)info);
        } else if (providerServer && !consumerServer) {
            LogOutputInfo info = new LogOutputInfo();
            info.setPluginId("SYSMON");
            info.setApplication(application);
            info.setMonitorId("LDAP01");
            info.setMessageId("003");
            Object[] args1 = new String[]{this.troubleDetectionInfo.getLdapConsumer()};
            info.setMessage(NotifyMessages.getString("ldap01.003.message", args1));
            Object[] args2 = new String[]{this.troubleDetectionInfo.getLdapProvider(), this.troubleDetectionInfo.getLdapConsumer()};
            info.setMessageOrg(NotifyMessages.getString("ldap01.003.org.message", args2));
            info.setFacilityId("SYSTEM");
            info.setScopeText("");
            info.setPriority(this.getPriority(NotifyMessages.getString("ldap01.003.priority")));
            info.setGenerationDate(new Date());
            output.outputLog(this.notifyInfo, (LogOutputBasicInfo)info);
        } else if (!providerServer && !consumerServer) {
            LogOutputInfo info = new LogOutputInfo();
            info.setPluginId("SYSMON");
            info.setApplication(application);
            info.setMonitorId("LDAP01");
            info.setMessageId("004");
            info.setMessage(NotifyMessages.getString("ldap01.004.message"));
            Object[] args = new String[]{this.troubleDetectionInfo.getLdapProvider(), this.troubleDetectionInfo.getLdapConsumer()};
            info.setMessageOrg(NotifyMessages.getString("ldap01.004.org.message", args));
            info.setFacilityId("SYSTEM");
            info.setScopeText("");
            info.setPriority(this.getPriority(NotifyMessages.getString("ldap01.004.priority")));
            info.setGenerationDate(new Date());
            output.outputLog(this.notifyInfo, (LogOutputBasicInfo)info);
        }
    }

    public void logout(String monitorId, String messageId) {
        String application = NotifyMessages.getString("ldap.application");
        String key = monitorId.toLowerCase() + "." + messageId;
        OutputLog output = new OutputLog(this.troubleDetectionInfo);
        LogOutputInfo info = new LogOutputInfo();
        info.setPluginId("SYSMON");
        info.setApplication(application);
        info.setMonitorId(monitorId);
        info.setMessageId(messageId);
        if (key.equals("ldap02.001")) {
            info.setMessage(NotifyMessages.getString(key + ".message"));
            Object[] args = new String[]{this.troubleDetectionInfo.getLdapProvider(), this.troubleDetectionInfo.getLdapConsumer()};
            info.setMessageOrg(NotifyMessages.getString(key + ".org.message", args));
        } else if (key.equals("ldap02.002")) {
            Object[] args1 = new String[]{this.troubleDetectionInfo.getLdapProvider(), this.troubleDetectionInfo.getLdapConsumer()};
            info.setMessage(NotifyMessages.getString(key + ".message", args1));
            Object[] args2 = new String[]{this.troubleDetectionInfo.getLdapProvider(), this.troubleDetectionInfo.getLdapConsumer()};
            info.setMessageOrg(NotifyMessages.getString(key + ".org.message", args2));
        } else if (key.equals("ldap03.001")) {
            info.setMessage(NotifyMessages.getString(key + ".message"));
            Object[] args = new String[]{this.troubleDetectionInfo.getLdapConsumer(), this.troubleDetectionInfo.getLdapProvider()};
            info.setMessageOrg(NotifyMessages.getString(key + ".org.message", args));
        } else if (key.equals("ldap03.002")) {
            Object[] args1 = new String[]{this.troubleDetectionInfo.getLdapConsumer(), this.troubleDetectionInfo.getLdapProvider()};
            info.setMessage(NotifyMessages.getString(key + ".message", args1));
            Object[] args2 = new String[]{this.troubleDetectionInfo.getLdapConsumer(), this.troubleDetectionInfo.getLdapProvider()};
            info.setMessageOrg(NotifyMessages.getString(key + ".org.message", args2));
        } else {
            info.setMessage(NotifyMessages.getString(key + ".message"));
            info.setMessageOrg(NotifyMessages.getString(key + ".org.message"));
        }
        info.setFacilityId("SYSTEM");
        info.setScopeText("");
        info.setPriority(this.getPriority(NotifyMessages.getString(key + ".priority")));
        info.setGenerationDate(new Date());
        output.outputLog(this.notifyInfo, (LogOutputBasicInfo)info);
    }
}

