/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice.server;

import javax.xml.soap.SOAPException;
import org.jboss.axis.AxisFault;
import org.jboss.axis.EngineConfiguration;
import org.jboss.axis.Handler;
import org.jboss.axis.MessageContext;
import org.jboss.axis.SimpleTargetedChain;
import org.jboss.axis.description.OperationDesc;
import org.jboss.axis.server.AxisServer;
import org.jboss.axis.soap.SOAPConstants;
import org.jboss.axis.utils.Messages;
import org.jboss.logging.Logger;

public class ServerEngine
extends AxisServer {
    static final long serialVersionUID = 5160872757245559530L;
    private static final Logger log = Logger.getLogger((Class)ServerEngine.class);

    public ServerEngine(EngineConfiguration config) {
        super(config);
        log.debug((Object)("new ServerEngine [config=" + config + "]"));
    }

    public void invoke(final MessageContext msgContext) throws AxisFault {
        try {
            long t1 = System.currentTimeMillis();
            msgContext.getMessage().getSOAPPart().getEnvelope();
            long t2 = System.currentTimeMillis();
            Logger.getLogger((String)"org.jboss.axis.TIME").debug((Object)("Get SOAPEnvelope in " + (t2 - t1) + "ms"));
            OperationDesc currOperation = msgContext.getOperation();
            if (currOperation != null && currOperation.isOneWay()) {
                Thread th = new Thread(){

                    public void run() {
                        try {
                            ServerEngine.this.invokeInternal(msgContext);
                        }
                        catch (AxisFault fault) {
                            log.error((Object)("Asyncronous Server error: " + fault.dumpToString()));
                        }
                    }
                };
                th.start();
                msgContext.setResponseMessage(null);
                log.debug((Object)("Returning immediately from one-way operation: " + currOperation.getName()));
                return;
            }
            this.invokeInternal(msgContext);
        }
        catch (AxisFault af) {
            log.error((Object)("Server error: " + af.dumpToString()));
            throw af;
        }
        catch (SOAPException ex) {
            log.error((Object)"Server error", (Throwable)ex);
            throw AxisFault.makeFault((Exception)((Object)ex));
        }
        catch (RuntimeException ex) {
            log.error((Object)"Server error", (Throwable)ex);
            throw ex;
        }
    }

    private void invokeInternal(MessageContext msgContext) throws AxisFault {
        log.debug((Object)("invoke: " + msgContext));
        long t1 = 0L;
        long t2 = 0L;
        long t3 = 0L;
        long t4 = 0L;
        long t5 = 0L;
        long t6 = 0L;
        if (!this.isRunning()) {
            throw new AxisFault("Server.disabled", Messages.getMessage((String)"serverDisabled00"), null, null);
        }
        String hName = null;
        Handler handler = null;
        MessageContext previousContext = ServerEngine.getCurrentMessageContext();
        try {
            ServerEngine.setCurrentMessageContext((MessageContext)msgContext);
            hName = msgContext.getTransportName();
            SimpleTargetedChain transportChain = null;
            log.debug((Object)("TransportHandler: " + hName));
            t1 = System.currentTimeMillis();
            if (hName != null && (handler = this.getTransport(hName)) != null && handler instanceof SimpleTargetedChain && (handler = (transportChain = (SimpleTargetedChain)handler).getRequestHandler()) != null) {
                handler.invoke(msgContext);
            }
            t2 = System.currentTimeMillis();
            handler = this.getGlobalRequest();
            if (handler != null) {
                handler.invoke(msgContext);
            }
            t3 = System.currentTimeMillis();
            handler = msgContext.getService();
            if (handler == null) {
                throw new AxisFault("Server.NoService", Messages.getMessage((String)"noService05", (String)msgContext.getTargetService()), null, null);
            }
            if (msgContext.getSOAPConstants() != null) {
                SOAPConstants soapConstants = msgContext.getSOAPConstants();
                msgContext.setSOAPConstants(soapConstants);
            }
            handler.invoke(msgContext);
            t4 = System.currentTimeMillis();
            handler = this.getGlobalResponse();
            if (handler != null) {
                handler.invoke(msgContext);
            }
            t5 = System.currentTimeMillis();
            if (transportChain != null && (handler = transportChain.getResponseHandler()) != null) {
                handler.invoke(msgContext);
            }
            t6 = System.currentTimeMillis();
            if (log.isTraceEnabled()) {
                String serviceName = msgContext.getTargetService();
                if (msgContext.getOperation() != null) {
                    serviceName = serviceName + "." + msgContext.getOperation().getName();
                }
                log.trace((Object)(serviceName + " [" + "trIn=" + (t2 - t1) + ",glIn=" + (t3 - t2) + ",invoke=" + (t4 - t3) + ",glOut=" + (t5 - t4) + ",trOut=" + (t6 - t5) + "]"));
            }
        }
        catch (AxisFault e) {
            throw e;
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Exception)e);
        }
        finally {
            ServerEngine.setCurrentMessageContext((MessageContext)previousContext);
        }
    }
}

