/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.failover.monitor.jmx;

import com.clustercontrol.troubledetection.bean.TroubleDetectionInfo;
import com.clustercontrol.troubledetection.ejb.session.TroubleDetectionControllerLocal;
import com.clustercontrol.troubledetection.ejb.session.TroubleDetectionControllerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.ha.framework.interfaces.ClusterNode;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FailoverMonitor {
    private static Log log = LogFactory.getLog(FailoverMonitor.class);
    private static final String LOOKUP_NAME = "jmx/invoker/RMIAdaptor";
    private static final String OBJECT_NAME = "user:name=TroubleDetection,service=TroubleDetectionService";
    private static final String OPERATION_NAME = "putMessage";
    private static ArrayList<String> members = new ArrayList();
    protected TroubleDetectionInfo troubleDetectionInfo = this.getTroubleDetectionInfo();

    public void monitor(Vector deadMembers, Vector newMembers, Vector allMembers) {
        String newTopAddr;
        String addr;
        int i;
        String addr2;
        int m;
        log.info((Object)("DeadMembers: size=" + deadMembers.size()));
        for (m = 0; m < deadMembers.size(); ++m) {
            addr2 = this.getMemberAddress(deadMembers.get(m));
            log.info((Object)addr2);
        }
        log.info((Object)("NewMembers: size=" + newMembers.size()));
        for (m = 0; m < newMembers.size(); ++m) {
            addr2 = this.getMemberAddress(newMembers.get(m));
            log.info((Object)addr2);
        }
        log.info((Object)("AllMembers: size=" + allMembers.size()));
        for (m = 0; m < allMembers.size(); ++m) {
            addr2 = this.getMemberAddress(allMembers.get(m));
            log.info((Object)addr2);
        }
        boolean removeServer1 = false;
        boolean removeServer2 = false;
        for (i = 0; i < deadMembers.size(); ++i) {
            addr = this.getMemberAddress(deadMembers.get(i));
            log.info((Object)("deadMember = " + addr));
            if (addr.equals(this.troubleDetectionInfo.getJbossServer1())) {
                removeServer1 = true;
                log.info((Object)("removeServer1 = " + removeServer1));
                continue;
            }
            if (!addr.equals(this.troubleDetectionInfo.getJbossServer2())) continue;
            removeServer2 = true;
            log.info((Object)("removeServer2 = " + removeServer2));
        }
        if (removeServer1 && members.size() > 0 && allMembers.size() > 0) {
            String oldTopAddr = members.get(0);
            newTopAddr = this.getMemberAddress(allMembers.get(0));
            log.info((Object)("oldTopAddr = " + oldTopAddr));
            log.info((Object)("newTopAddr = " + newTopAddr));
            if (oldTopAddr.equals(this.troubleDetectionInfo.getJbossServer1()) && newTopAddr.equals(this.troubleDetectionInfo.getJbossServer2())) {
                this.outputLog("JBOSS02", "001");
            }
        }
        if (removeServer2 && members.size() > 0 && allMembers.size() > 0) {
            String oldTopAddr = members.get(0);
            newTopAddr = this.getMemberAddress(allMembers.get(0));
            log.info((Object)("oldTopAddr = " + oldTopAddr));
            log.info((Object)("newTopAddr = " + newTopAddr));
            if (oldTopAddr.equals(this.troubleDetectionInfo.getJbossServer2()) && newTopAddr.equals(this.troubleDetectionInfo.getJbossServer1())) {
                this.outputLog("JBOSS03", "001");
            }
        }
        members.clear();
        for (i = 0; i < allMembers.size(); ++i) {
            addr = this.getMemberAddress(allMembers.get(i));
            members.add(addr);
        }
    }

    private void outputLog(String monitorId, String messageId) {
        try {
            InitialContext ic = new InitialContext();
            RMIAdaptor server = (RMIAdaptor)ic.lookup(LOOKUP_NAME);
            ObjectName name = new ObjectName(OBJECT_NAME);
            Object[] args = new Object[]{monitorId, messageId};
            String[] signature = new String[]{String.class.getName(), String.class.getName()};
            server.invoke(name, OPERATION_NAME, args, signature);
        }
        catch (NamingException e) {
            log.debug((Object)("outputLog() : " + e.getMessage()));
        }
        catch (MalformedObjectNameException e) {
            log.debug((Object)("outputLog() : " + e.getMessage()));
        }
        catch (NullPointerException e) {
            log.debug((Object)("outputLog() : " + e.getMessage()));
        }
        catch (InstanceNotFoundException e) {
            log.debug((Object)("outputLog() : " + e.getMessage()));
        }
        catch (MBeanException e) {
            log.debug((Object)("outputLog() : " + e.getMessage()));
        }
        catch (ReflectionException e) {
            log.debug((Object)("outputLog() : " + e.getMessage()));
        }
        catch (IOException e) {
            log.debug((Object)("outputLog() : " + e.getMessage()));
        }
    }

    public void setAllMembers(ArrayList<String> members) {
        FailoverMonitor.members = members;
    }

    public ArrayList<String> getAllMembers() {
        return members;
    }

    public TroubleDetectionInfo getTroubleDetectionInfo() {
        TroubleDetectionInfo info = null;
        try {
            TroubleDetectionControllerLocal controller = TroubleDetectionControllerUtil.getLocalHome().create();
            info = controller.getInfo();
        }
        catch (CreateException e) {
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return info;
    }

    private String getMemberAddress(Object addr) {
        String address = null;
        try {
            ClusterNode node = (ClusterNode)addr;
            address = node.getIpAddress().getHostAddress();
        }
        catch (Exception e) {
            log.warn((Object)("Failed to obtain address/port from addr: " + addr), (Throwable)e);
        }
        return address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean callExternalCommand(String[] cmd) {
        Process process;
        Runtime runtime = Runtime.getRuntime();
        try {
            if (log.isInfoEnabled()) {
                String command = null;
                for (int i = 0; i < cmd.length; ++i) {
                    command = command == null ? cmd[i] : command + " " + cmd[i];
                }
                log.info((Object)("Command Execute : " + command));
            }
            process = runtime.exec(cmd);
        }
        catch (IOException e) {
            log.error((Object)e);
            return false;
        }
        try {
            int exitValue;
            try {
                exitValue = process.waitFor();
            }
            catch (InterruptedException e) {
                log.error((Object)e);
                boolean bl = false;
                process.destroy();
                return bl;
            }
            log.info((Object)("ExitCode : " + exitValue));
            if (exitValue == 0) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            process.destroy();
        }
        return false;
    }
}

