/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpConnectionManager;

public class SimpleHttpConnectionManager
implements HttpConnectionManager {
    private HttpConnection httpConnection;
    private boolean connectionStaleCheckingEnabled = true;

    static void finishLastResponse(HttpConnection conn) {
        block2: {
            InputStream lastResponse = conn.getLastResponseInputStream();
            if (lastResponse == null) break block2;
            conn.setLastResponseInputStream(null);
            try {
                lastResponse.close();
            }
            catch (IOException iOException) {
                conn.close();
            }
        }
    }

    public HttpConnection getConnection(HostConfiguration hostConfiguration) {
        return this.getConnection(hostConfiguration, 0L);
    }

    public HttpConnection getConnection(HostConfiguration hostConfiguration, long timeout) {
        if (this.httpConnection == null) {
            this.httpConnection = new HttpConnection(hostConfiguration);
            this.httpConnection.setStaleCheckingEnabled(this.connectionStaleCheckingEnabled);
        } else if (!hostConfiguration.hostEquals(this.httpConnection) || !hostConfiguration.proxyEquals(this.httpConnection)) {
            if (this.httpConnection.isOpen()) {
                this.httpConnection.close();
            }
            this.httpConnection.setStaleCheckingEnabled(this.connectionStaleCheckingEnabled);
            this.httpConnection.setHost(hostConfiguration.getHost());
            this.httpConnection.setVirtualHost(hostConfiguration.getVirtualHost());
            this.httpConnection.setPort(hostConfiguration.getPort());
            this.httpConnection.setProtocol(hostConfiguration.getProtocol());
            this.httpConnection.setLocalAddress(hostConfiguration.getLocalAddress());
            this.httpConnection.setProxyHost(hostConfiguration.getProxyHost());
            this.httpConnection.setProxyPort(hostConfiguration.getProxyPort());
        } else {
            SimpleHttpConnectionManager.finishLastResponse(this.httpConnection);
        }
        return this.httpConnection;
    }

    public boolean isConnectionStaleCheckingEnabled() {
        return this.connectionStaleCheckingEnabled;
    }

    public void releaseConnection(HttpConnection conn) {
        if (conn != this.httpConnection) {
            throw new IllegalStateException("Unexpected close on a different connection.");
        }
        SimpleHttpConnectionManager.finishLastResponse(this.httpConnection);
    }

    public void setConnectionStaleCheckingEnabled(boolean connectionStaleCheckingEnabled) {
        this.connectionStaleCheckingEnabled = connectionStaleCheckingEnabled;
    }
}

