/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.modelmbean;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeChangeNotificationFilter;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.jboss.logging.Logger;
import org.jboss.mx.interceptor.AbstractInterceptor;
import org.jboss.mx.interceptor.Interceptor;
import org.jboss.mx.interceptor.ModelMBeanAttributeInterceptor;
import org.jboss.mx.interceptor.ModelMBeanInfoInterceptor;
import org.jboss.mx.interceptor.ModelMBeanOperationInterceptor;
import org.jboss.mx.interceptor.NullInterceptor;
import org.jboss.mx.interceptor.PersistenceInterceptor;
import org.jboss.mx.modelmbean.ModelMBeanConstants;
import org.jboss.mx.persistence.NullPersistence;
import org.jboss.mx.persistence.PersistenceManager;
import org.jboss.mx.server.AbstractMBeanInvoker;
import org.jboss.mx.server.Invocation;
import org.jboss.mx.server.InvocationContext;
import org.jboss.mx.util.JBossNotificationBroadcasterSupport;

public abstract class ModelMBeanInvoker
extends AbstractMBeanInvoker
implements ModelMBean,
ModelMBeanConstants {
    Logger log = Logger.getLogger((String)(class$org$jboss$mx$modelmbean$ModelMBeanInvoker == null ? (class$org$jboss$mx$modelmbean$ModelMBeanInvoker = ModelMBeanInvoker.class$("org.jboss.mx.modelmbean.ModelMBeanInvoker")) : class$org$jboss$mx$modelmbean$ModelMBeanInvoker).getName());
    protected String resourceType = null;
    protected PersistenceManager persistence = new NullPersistence();
    protected JBossNotificationBroadcasterSupport notifier = new JBossNotificationBroadcasterSupport();
    protected long notifierSequence = 1L;
    protected long attrNotifierSequence = 1L;
    static /* synthetic */ Class class$org$jboss$mx$modelmbean$ModelMBeanInvoker;
    static /* synthetic */ Class class$javax$management$MBeanInfo;
    static /* synthetic */ Class class$org$jboss$mx$interceptor$ModelMBeanInterceptor;
    static /* synthetic */ Class class$org$jboss$mx$interceptor$ObjectReferenceInterceptor;
    static /* synthetic */ Class class$org$jboss$mx$interceptor$PersistenceInterceptor2;
    static /* synthetic */ Class class$org$jboss$mx$server$MBeanInvoker;

    public ModelMBeanInvoker() {
    }

    public ModelMBeanInvoker(ModelMBeanInfo info) throws MBeanException {
        this.setModelMBeanInfo(info);
    }

    public void setModelMBeanInfo(ModelMBeanInfo info) throws MBeanException, RuntimeOperationsException {
        if (info == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("MBeanInfo cannot be null"));
        }
        this.info = new ModelMBeanInfoSupport(info);
        ModelMBeanInfo minfo = info;
        Descriptor mbeanDescriptor = null;
        try {
            mbeanDescriptor = minfo.getDescriptor("", "mbean");
        }
        catch (MBeanException e) {
            this.log.warn((Object)"Failed to obtain descriptor: mbean", (Throwable)e);
            return;
        }
        String type = (String)mbeanDescriptor.getFieldValue("MBeanInfoType");
        if (type != null) {
            this.inject("MBeanInfoType", type, class$javax$management$MBeanInfo == null ? (class$javax$management$MBeanInfo = ModelMBeanInvoker.class$("javax.management.MBeanInfo")) : class$javax$management$MBeanInfo, info);
        }
    }

    public void setManagedResource(Object ref, String resourceType) throws MBeanException, InstanceNotFoundException, InvalidTargetObjectTypeException {
        if (!this.isSupportedResourceType(ref, resourceType)) {
            throw new InvalidTargetObjectTypeException("Unsupported resource type: " + resourceType);
        }
        this.setResource(ref);
        this.resourceType = resourceType;
        if (this.getServer() != null) {
            try {
                this.init(this.getServer(), this.resourceEntry.getObjectName());
            }
            catch (Exception e) {
                throw new MBeanException(e, "Failed to init from resource");
            }
        }
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        this.notifier.addNotificationListener(listener, filter, handback);
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.notifier.removeNotificationListener(listener);
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.notifier.removeNotificationListener(listener, filter, handback);
    }

    public void sendNotification(String ntfyText) throws MBeanException, RuntimeOperationsException {
        if (ntfyText == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ntfyText cannot be null"));
        }
        Notification notif = new Notification("jmx.modelmbean.generic", (Object)this, 1L, ntfyText);
        this.sendNotification(notif);
    }

    public void sendNotification(Notification ntfyObj) throws MBeanException, RuntimeOperationsException {
        if (ntfyObj == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ntfyText cannot be null"));
        }
        this.notifier.sendNotification(ntfyObj);
    }

    public void sendAttributeChangeNotification(AttributeChangeNotification notification) throws MBeanException {
        if (notification == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("notification cannot be null"));
        }
        this.notifier.sendNotification(notification);
    }

    public void sendAttributeChangeNotification(Attribute oldValue, Attribute newValue) throws MBeanException, RuntimeOperationsException {
        if (oldValue == null || newValue == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"));
        }
        if (!oldValue.getName().equals(newValue.getName())) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name mismatch between oldvalue and newvalue"));
        }
        String attr = oldValue.getName();
        String type = ((ModelMBeanInfo)((Object)this.info)).getAttribute(attr).getType();
        AttributeChangeNotification notif = new AttributeChangeNotification(this, 1L, System.currentTimeMillis(), "" + attr + " changed from " + oldValue + " to " + newValue, attr, type, oldValue.getValue(), newValue.getValue());
        this.notifier.sendNotification(notif);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.info.getNotifications();
    }

    public void addAttributeChangeNotificationListener(NotificationListener listener, String attributeName, Object handback) throws MBeanException {
        ModelMBeanInfo minfo = (ModelMBeanInfo)((Object)this.info);
        AttributeChangeNotificationFilter filter = null;
        if (attributeName != null) {
            ModelMBeanAttributeInfo ainfo = minfo.getAttribute(attributeName);
            if (ainfo == null) {
                throw new RuntimeOperationsException(new IllegalArgumentException("Attribute does not exist: " + attributeName));
            }
            filter = new AttributeChangeNotificationFilter();
            filter.enableAttribute(attributeName);
        } else {
            filter = new AttributeChangeNotificationFilter();
            MBeanAttributeInfo[] allAttributes = minfo.getAttributes();
            for (int i = 0; i < allAttributes.length; ++i) {
                filter.enableAttribute(allAttributes[i].getName());
            }
        }
        this.notifier.addNotificationListener(listener, filter, handback);
    }

    public void removeAttributeChangeNotificationListener(NotificationListener listener, String attributeName) throws MBeanException, ListenerNotFoundException {
        ModelMBeanInfo minfo;
        ModelMBeanAttributeInfo ainfo;
        if (attributeName != null && (ainfo = (minfo = (ModelMBeanInfo)((Object)this.info)).getAttribute(attributeName)) == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute does not exist: " + attributeName));
        }
        this.notifier.removeNotificationListener(listener);
    }

    public void load() throws MBeanException, InstanceNotFoundException {
        if (this.info == null) {
            return;
        }
        this.persistence.load(this, this.info);
    }

    public void store() throws MBeanException, InstanceNotFoundException {
        this.persistence.store(this.info);
    }

    public ObjectName invokePreRegister(MBeanServer server, ObjectName name) throws Exception {
        if (this.info == null) {
            throw new RuntimeErrorException(new Error("MBeanInfo has not been set."));
        }
        final ModelMBeanInfo minfo = (ModelMBeanInfo)((Object)this.info);
        Descriptor mbeanDescriptor = minfo.getMBeanDescriptor();
        this.getMBeanInfoCtx = new InvocationContext();
        this.getMBeanInfoCtx.setInvoker(this);
        this.getMBeanInfoCtx.setDescriptor(mbeanDescriptor);
        this.getMBeanInfoCtx.setDispatcher(new AbstractInterceptor("MBeanInfo Dispatcher"){

            public Object invoke(Invocation invocation) throws Throwable {
                return minfo;
            }
        });
        String[] signature = new String[]{};
        AbstractMBeanInvoker.OperationKey opKey = new AbstractMBeanInvoker.OperationKey((AbstractMBeanInvoker)this, "getMBeanInfo", signature);
        this.operationContextMap.put(opKey, this.getMBeanInfoCtx);
        signature = new String[]{"java.lang.Object", "java.lang.String"};
        opKey = new AbstractMBeanInvoker.OperationKey((AbstractMBeanInvoker)this, "setManagedResource", signature);
        InvocationContext ctx = new InvocationContext();
        ctx.setInvoker(this);
        ctx.setDispatcher(new AbstractInterceptor("SetMangedResource Dispatcher"){

            public Object invoke(Invocation invocation) throws Throwable {
                Object[] args = invocation.getArgs();
                ModelMBeanInvoker.this.setManagedResource(args[0], (String)args[1]);
                return null;
            }
        });
        this.operationContextMap.put(opKey, ctx);
        if (this.getResource() == null) {
            return name;
        }
        this.init(server, name);
        return super.invokePreRegister(server, name);
    }

    protected void init(MBeanServer server, ObjectName name) throws Exception {
        ModelMBeanInfo minfo = (ModelMBeanInfo)((Object)this.info);
        this.configureInterceptorStack(minfo, server, name);
        this.initDispatchers();
        Object resource = this.getResource();
        if (resource != null) {
            Descriptor mbeanDescriptor = minfo.getMBeanDescriptor();
            String resClassName = this.getResource().getClass().getName();
            mbeanDescriptor.setField("resourceClass", resClassName);
            minfo.setMBeanDescriptor(mbeanDescriptor);
        }
        this.setValuesFromMBeanInfo();
        this.initPersistence(server, name);
        this.load();
    }

    protected void initPersistence(MBeanServer server, ObjectName name) throws MBeanException, InstanceNotFoundException {
        Descriptor[] descriptors;
        ModelMBeanInfo minfo = (ModelMBeanInfo)((Object)this.getMetaData());
        try {
            descriptors = minfo.getDescriptors("mbean");
        }
        catch (MBeanException e) {
            this.log.error((Object)"Failed to obtain MBEAN_DESCRIPTORs", (Throwable)e);
            return;
        }
        if (descriptors == null) {
            return;
        }
        String persistMgrName = null;
        for (int i = 0; i < descriptors.length && persistMgrName == null; ++i) {
            persistMgrName = (String)descriptors[i].getFieldValue("persistence-manager");
        }
        if (persistMgrName == null) {
            this.log.trace((Object)"No persistence-manager descriptor found, null persistence will be used");
            return;
        }
        try {
            this.persistence = (PersistenceManager)server.instantiate(persistMgrName);
            this.log.debug((Object)("Loaded persistence mgr: " + persistMgrName));
            Descriptor descriptor = minfo.getMBeanDescriptor();
            descriptor.setField("objectname", name);
            minfo.setMBeanDescriptor(descriptor);
        }
        catch (Exception cause) {
            this.log.error((Object)("Unable to instantiate the persistence manager:" + persistMgrName), (Throwable)cause);
        }
    }

    protected void initOperationContexts(MBeanOperationInfo[] operations) {
        super.initOperationContexts(operations);
        for (int i = 0; i < operations.length; ++i) {
            AbstractMBeanInvoker.OperationKey key = new AbstractMBeanInvoker.OperationKey(this, operations[i]);
            InvocationContext ctx = (InvocationContext)this.operationContextMap.get(key);
            ModelMBeanOperationInfo info = (ModelMBeanOperationInfo)operations[i];
            ctx.setDescriptor(info.getDescriptor());
        }
    }

    protected void initAttributeContexts(MBeanAttributeInfo[] attributes) {
        super.initAttributeContexts(attributes);
        for (int i = 0; i < attributes.length; ++i) {
            ModelMBeanAttributeInfo info = (ModelMBeanAttributeInfo)attributes[i];
            String name = info.getName();
            InvocationContext ctx = (InvocationContext)this.attributeContextMap.get(name);
            ctx.setDescriptor(info.getDescriptor());
            ctx.setReadable(info.isReadable());
            ctx.setWritable(info.isWritable());
        }
    }

    protected void configureInterceptorStack(ModelMBeanInfo info, MBeanServer server, ObjectName name) throws Exception {
        List<ModelMBeanOperationInterceptor> list;
        InvocationContext ctx;
        Map.Entry entry;
        List defaultInterceptors = this.getInterceptors(this.getMBeanInfoCtx.getDescriptor());
        List<ModelMBeanInfoInterceptor> interceptors = null;
        if (defaultInterceptors != null) {
            interceptors = new ArrayList(defaultInterceptors);
        }
        if (interceptors == null) {
            interceptors = this.getMBeanInfoCtx.getInterceptors();
        }
        String mbeanName = name != null ? name.toString() : info.getClassName();
        interceptors.add(new ModelMBeanInfoInterceptor(mbeanName));
        this.getMBeanInfoCtx.setInterceptors(interceptors);
        Iterator it = this.attributeContextMap.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            ctx = (InvocationContext)entry.getValue();
            list = this.getInterceptors(ctx.getDescriptor());
            if (list == null) {
                list = defaultInterceptors != null ? new ArrayList(defaultInterceptors) : new ArrayList<PersistenceInterceptor>();
            }
            list.add((ModelMBeanOperationInterceptor)((Object)new PersistenceInterceptor()));
            list.add((ModelMBeanOperationInterceptor)((Object)new ModelMBeanAttributeInterceptor()));
            ctx.setInterceptors(list);
        }
        it = this.operationContextMap.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            ctx = (InvocationContext)entry.getValue();
            list = this.getInterceptors(ctx.getDescriptor());
            if (list == null && defaultInterceptors != null) {
                list = new ArrayList(defaultInterceptors);
            }
            if (this.dynamicResource) {
                if (list == null) {
                    list = new ArrayList();
                }
                list.add(new ModelMBeanOperationInterceptor());
            }
            if (list == null) continue;
            list.add((ModelMBeanOperationInterceptor)((Object)new NullInterceptor()));
            ctx.setInterceptors(list);
        }
    }

    protected List getInterceptors(Descriptor d) throws Exception {
        if (d == null) {
            return null;
        }
        Descriptor[] interceptorDescriptors = (Descriptor[])d.getFieldValue("interceptors");
        if (interceptorDescriptors == null) {
            return null;
        }
        ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        for (int i = 0; i < interceptorDescriptors.length; ++i) {
            Descriptor desc = interceptorDescriptors[i];
            String code = (String)desc.getFieldValue("code");
            if (code.equals((class$org$jboss$mx$interceptor$ModelMBeanInterceptor == null ? ModelMBeanInvoker.class$("org.jboss.mx.interceptor.ModelMBeanInterceptor") : class$org$jboss$mx$interceptor$ModelMBeanInterceptor).getName()) || code.equals((class$org$jboss$mx$interceptor$ObjectReferenceInterceptor == null ? ModelMBeanInvoker.class$("org.jboss.mx.interceptor.ObjectReferenceInterceptor") : class$org$jboss$mx$interceptor$ObjectReferenceInterceptor).getName()) || code.equals((class$org$jboss$mx$interceptor$PersistenceInterceptor2 == null ? ModelMBeanInvoker.class$("org.jboss.mx.interceptor.PersistenceInterceptor2") : class$org$jboss$mx$interceptor$PersistenceInterceptor2).getName())) {
                this.log.debug((Object)("Ignoring obsolete legacy interceptor: " + code));
                continue;
            }
            Class<?> interceptorClass = loader.loadClass(code);
            Interceptor interceptor = null;
            Class[] ctorSig = new Class[]{class$org$jboss$mx$server$MBeanInvoker == null ? ModelMBeanInvoker.class$("org.jboss.mx.server.MBeanInvoker") : class$org$jboss$mx$server$MBeanInvoker};
            try {
                Constructor<?> ctor = interceptorClass.getConstructor(ctorSig);
                Object[] ctorArgs = new Object[]{this};
                interceptor = (Interceptor)ctor.newInstance(ctorArgs);
            }
            catch (Throwable t) {
                this.log.debug((Object)("Failed to invoke ctor(MBeanInvoker) for: " + interceptorClass), t);
                interceptor = (Interceptor)interceptorClass.newInstance();
            }
            interceptors.add(interceptor);
            String[] names = desc.getFieldNames();
            HashMap<String, PropertyDescriptor> propertyMap = new HashMap<String, PropertyDescriptor>();
            if (names.length <= 1) continue;
            BeanInfo beanInfo = Introspector.getBeanInfo(interceptorClass);
            PropertyDescriptor[] props = beanInfo.getPropertyDescriptors();
            for (int p = 0; p < props.length; ++p) {
                String fieldName = props[p].getName();
                propertyMap.put(fieldName, props[p]);
            }
            for (int n = 0; n < names.length; ++n) {
                String name = names[n];
                if (name.equals("code")) continue;
                String text = (String)desc.getFieldValue(name);
                PropertyDescriptor pd = (PropertyDescriptor)propertyMap.get(name);
                if (pd == null) {
                    throw new IntrospectionException("No PropertyDescriptor for attribute:" + name);
                }
                Method setter = pd.getWriteMethod();
                if (setter == null) continue;
                Class<?> ptype = pd.getPropertyType();
                PropertyEditor editor = PropertyEditorManager.findEditor(ptype);
                if (editor == null) {
                    throw new IntrospectionException("Cannot convert string to interceptor attribute:" + name);
                }
                editor.setAsText(text);
                Object[] args = new Object[]{editor.getValue()};
                setter.invoke((Object)interceptor, args);
            }
        }
        if (interceptors.size() == 0) {
            interceptors = null;
        }
        return interceptors;
    }

    protected void setValuesFromMBeanInfo() throws JMException {
        Iterator it = this.attributeContextMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            InvocationContext ctx = (InvocationContext)entry.getValue();
            Object value = ctx.getDescriptor().getFieldValue("value");
            if (value == null) continue;
            this.setAttribute(new Attribute(key, value));
        }
    }

    protected boolean isSupportedResourceType(Object resource, String resourceType) {
        return resourceType.equalsIgnoreCase("ObjectReference");
    }

    protected void override(Invocation invocation) throws MBeanException {
        ModelMBeanInfo mminfo;
        Descriptor descriptor;
        Descriptor current;
        if (this.dynamicResource && this.info != null && (current = invocation.getDescriptor()) != null && (descriptor = (mminfo = (ModelMBeanInfo)((Object)this.info)).getDescriptor((String)current.getFieldValue("name"), (String)current.getFieldValue("descriptorType"))) != null) {
            invocation.setDescriptor(descriptor);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

